@part[internet, root "progman"]

@chapter[Internet]

This chapter is by no means complete yet (like most of the manual).

This chapter describes the internet layer which implements the DoD standard
internet protocol. This implementation does not do packet fragmentation
or reassembly and does not understand internet options. Packets with options
will still be accepted, but the options will be ignored. Packet fragments
will be dropped. See @cite[internet] for the Internet protocol specification.

@section[Internet Layer]
The internet layer contains no tasks. It is upcalled by network drivers when
internet packets are received and it provides the internet header on packets
when they are transmitted and does the routing. The internet layer is
actually side-by-side with the ICMP layer, and packet routing is done with
information provided by ICMP. Packets are routed on a per-packet basis and
no long-term information is kept on "connections." The term "internet
connection" when used to describe the interface between higher level
protocols is only used because it is convenient; in reality there is no
connection of the type which TCP provides.

@section[Routing]

This internet implementation uses a subnet routing scheme based on
masks@cite[mask-route].  Basically, a host is said to be accessible
over a physical net interface if its address is equal to the internet
address of that interface when masked to keep just the network number
plus some number of contiguous bits after the network number. This
contiguous bit field is called the @i[subnet] number. At MIT, subnet
numbers are 8 bits, so for a Class A internet address the high 16 bits
of an internet address are compared instead of just the high  8. The
customizer allows the user to specify the length of the subnet bit
field and then generates a mask, based on the internet address and the
length of the bit field, which is suitable for use in comparing
internet addresses.  Note that you can only compare foreign addresses
with addresses of net interfaces on the machine that's doing the
comparison.

If a host is not directly accessible over any interface, the packet is sent
to the default gateway specified for the first net interface.

@section[Include Files and Library Files]

The include file @i[<ip.h>] defines the internet header structure, the
@i[IPCONN] type which @i[in@us2()open()] returns and a variety of constants.
The internet library is @i[internet].

@section[Internet Calls]

Descriptions of internet user functions follow.


@subsection[@i{in@us2()init()}]

@begin[verbatim]

in@us()init()

@end[verbatim]

Initialize the internet layer. This function should be called before any
other function in the internet layer is called, and before any protocol of a
higher level than internet is used (or initialized).

@subsection[@i{in@us2()alloc()}]

@begin[verbatim]

PACKET in@us()alloc(length, len@us()options)

@end[verbatim]

Attempts to allocate a packet buffer with room for @i[length] bytes of
internet data and @i[len@us2()options] bytes of internet options. It does not
initialize the data to anything, so the contents of the packet buffer are
garbage (actually the old contents of the packet buffer, whatever they
were). Since all packet buffers are the same length, the @i[length] argument
isn't very useful but it's good to use it correctly in case we ever decide
to use more flexible packet buffers.

This function returns @i[NULL] if it can't allocate a packet buffer.

@subsection[@i{in@us2()free()}]

@begin[verbatim]

in@us()free(p)
	PACKET p;

@end[verbatim]

Free packet buffer @i[p]. This really just calls the @i[putfree()] macro to
thread the buffer onto the queue of free packets.

@subsection[@i{in@us2()open()}]

@begin[verbatim]

IPCONN in@us()open(prot, handler)
	unsigned prot;
	int (*handler)();

@end[verbatim]

Open an "internet connection." After this operation, whenever an internet
packet of protocol @i[prot] is received, the function @i[handler] is called
with the following arguments:

@begin[verbatim]
	(*handler)(p, length, source)
		PACKET p;
		unsigned length;
		in@us()name source;
@end[verbatim]

where @i[p] is the packet received, @i[length] is the length of the internet
data (everything after the internet header) and @i[source] is the internet
address of the host which sent the packet.

Only one connection per protocol can be opened, and a maximum of ten
protocols can be listened for. No corresponding @i[in@us2()close()] is
provided. If the connection cannot be opened, @i[in@us2()open()] returns
@i[NULL].

The one way this call has been used thus far is by higher level protocol
initialization functions. Thus, UDP when it is initialized opens an internet
connection to listen for all UDP packets and have them processed by its
demultiplexing function. If a packet of a protocol which isn't being
listened to is received, an ICMP Destination Unreachable will be generated
and sent to the sender of the packet.

@subsection[@i{in@us2()write()}]

@Begin[verbatim]

in@us()write(con, p, len, dest)
	IPCONN con;
	PACKET p;
	int len;
	in@us()name dest;

@End[verbatim]

This call puts an internet header on packet @i[p] and sends it to host
@i[dest]. The IP "connection" @i[con] is used only for the protocol
number. ICMP errors generated by the packet are at best displayed on
the screen (if the right debugging levels are set) and at worst simply
ignored. @i[in@us2()write()] blocks until the send is complete.
