
comment
	The purpose of this program is to show how to create
	and use a clear screen, print prompt and cursor movement
	procedures.  I will also show how to use a function to
	convert lower case characters to their upper case values.
end of comment

remark	declare global variables, names known to the entire program

var	name		= string:24	
var	street.address  = string:32	
var	city.address	= string:35	
var	query		= string:3	

remark	set up the files file number 2 will be sequential 1 sector.
files	d,d,s(1)

PROCEDURE cls
comment
	Procedure to clear the screen and home the cursor to the
	uppper left corner of the screen, cordinate 0,0.
end 

	print chr(26)	
end of cls

PROCEDURE pprompt(z,p = integer)
comment
	Procedure to print a number of prompt characters.  The
	value passed -z-  will determine the number of prompt characters.

	The ascii value of the prompt character is passed in the
	variable p.

	The first for loop will print the prompt character then
	the second for loop will move the cursor back to the start
	of the prompt string.  
end of comment

remark	var m is a local variable, known only to pprompt.

var m = integer
	for m = 1 to z 
		print chr(p);
	next m
	remark print chr(08) prints the non destruct crusor left char.
	for m = 1 to z
		print chr(08);		
	next m
end of pprompt

PROCEDURE cursor(x,y = integer)
comment
	This procedure will move the cursor to any location on
	the screen.  The value of x will be the roll number 0 to 24.
	The y value is the column value 0 to 79.
end 

	print chr(27);'=';chr(x + 32);chr(y + 32);
end of cursor
	
FUNCTION upcase(s = string) = string
comment
	This function will convert an input string from lower to
	upper case characters.

	If the temporary string (s1) is less then the
	space character then we will make the corresponding
	character position in outs equal to the space character.

	While s1 is greater then the back slash (\) character then subtract
	32 from the characters value until the character is less
	then the back slash character.

	The output string is made up by adding the character held
	in string s1 to the output string  outs .
end of comment

var 	s1	= string:1		
var	outs	= string
var	length	= integer		
	outs = ""			
	for length = 1 to len(s)
		s1 = mid(s,length,1)
		if s1 < " " then s1 = " "
		while s1 > "\" do s1 = chr(ascii(s1) - 32)
		outs = outs + s1
	next length
end = outs

PROCEDURE print.screen		
remark	Show what data will be requested.

	cls			
	cursor 5,10
	print "NAME           : ";
	cursor 5,35		
	cursor 8,10		
	print "STREET ADDRESS : ";
	cursor 8,35		
	cursor 11,10		
	print "CITY ADDRESS   : ";
	cursor 11,35		
end  of print screen

PROCEDURE get.name
comment	Get the persons name.  We could check for alphabetic characters
 	only in the name string.  To do this we would write a function
	that checks for characters greater then Z or less then A,
	the function would have to allow commas and periods but
	rign the bell (print chr(07)) and tell the user that they entered
	a non alphabetic character.  Call this alpha check
	function after converting the string to upper case.
end of comment

	cursor 5,35		
	pprompt 24,45		
	input3 name
	name = upcase (name)
	remark name = alpha.check(name) for alphabetic check.
end of get.name

PROCEDURE get.street.address
remark	Get the street address.

	cursor 8,35		
	pprompt 32,45		
	input3 street.address 	
	street.address = upcase (street.address)
end of get.street.address

PROCEDURE get.city.address
remark	Get the city address.

	cursor 11,35		
	pprompt 35,45		
	input3 city.address
	city.address = upcase (city.address)
end of get.city.address

PROCEDURE print.data
comment
	Will print out the current information held in the
	variables name, street address and city address.
end of comment
	cls
	print.screen
	cursor 5,35
	print name;		
	cursor 8,35		
	print street.address;	
	cursor 11,35		
	print city.address
end of print.data

PROCEDURE check.input		
comment
	Used to ask the operator if the data is correct and allows
	them to change any incorrect information.
end
var response = string:1

remark 	This loop will continue until we say YES to information correct.

repeat
begin				
	print.data		
	cursor 17,10
	input3 "IS THIS INFORMATION CORRECT   YES   OR   NO ? ",query
	query = upcase (query)
	remark if you typed YES then skip then chance to correct data.
	if query <> "YES" then		
	   begin
		cursor 20,0	
		print "TYPE  N FOR  NAME CHANGE"
		print "TYPE  S FOR  STREET ADDRESS CHANGE"
		print "TYPE  C FOR  CITY CHANGE"
		input3 " ",response
		response = upcase (response)
			case response of
			"N" : get.name
			"S" : get.street.address
			"C" : get.city.address
			end of case
	    end
end 
until query = "YES"		
end of check.input
	



remark **************************************************************
remark ************** START OF MAIN LINE PROGRAM CODE ***************
remark **************************************************************

create "ADDRESS.DAT"		
open #2,"ADDRESS.DAT"		
repeat
begin				
	cls
	cursor 12,20		
	input2 "WOULD YOU LIKE TO ENTER DATA  --  YES OR NO ",query
	query = upcase (query)		
	if query = "YES" then		
	  begin	
		print.screen
		get.name
		get.street.address
		get.city.address
		check.input		
		write #2;name,street.address,city.address
	  end 
end 
until query <> "YES"		
close #2
stop
		
ry <> "YES" then		
	   begin
		cursor 20,0	
		print "TYPE  N FOR  NAME CHANGE"
		print "TY