/*  VDP Pacman   graphics and screen utilities    */
/*      29 December 1983    Version 2.1 DLB       */

#define EXTERN extern

#include "stdio.h"
#include "pacdefs.h"


display(number)
int number;
{
    struct pactyp *pointer;
    
    pointer = &monst[number];
    vdpram(SATBASE + 4 * number, WRITE);
    out(VDPDATA, 8 * pointer->ypos - 2);
    out(VDPDATA, 8 * pointer->xpos - 4);
    out(VDPDATA, 4 * pointer->name);
    out(VDPDATA, pointer->color);
}


offdsply(number)
int number;
{
    int yoffset, xoffset;
    struct pactyp *pointer;
    
    yoffset = xoffset = 0;
    pointer = &monst[number];
    switch(pointer->dirn)	{
    case DUP :
	yoffset = 4;
	break;
    case DDOWN :
	yoffset = -4;
	break;
    case DLEFT :
	xoffset = 4;
	break;
    case DRIGHT :
	xoffset = -4;
	break;
    }
    vdpram(SATBASE + 4 * number, WRITE);
    out(VDPDATA, 8 * pointer->ypos - 2 + yoffset);
    out(VDPDATA, 8 * pointer->xpos - 4 + xoffset);
    out(VDPDATA, 4 * (pointer->name + 1));
    out(VDPDATA, pointer->color);
}


#define PACLOC	96

int pacloc[4] = {62, 60, 58, 56};

xpacs()
{
    register i;
    for(i = 0; i < paccnt - 1; i++)
	pntmap(pacloc[i], PACLOC);
    while(i < (MAXPAC - 1)) pntmap(pacloc[i++], BLANK);
}


int scoreloc[5] = {13, 14, 15, 16, 17};
char str[5];


update()

{

    register i;
    sprintf(str,"%5u", score);
    for(i = 0; i < 5; i++)
	pntmap(scoreloc[i], (str[i] == ' ') ? BLANK : str[i] - '0');
}



sleep(x)
unsigned x;

{

    unsigned i, j;

    for(j = 0; j < x; j++)
	for(i = 0; i < 6 * ticks; i++)
	    ;
}



#ifdef JOYSTICK

poll()

{
    int keyhit, joystick;

    if(keyhit = keyboard())	{
	switch (toupper(keyhit))	{
	case QUIT :
	    over();

	    break;
	case SUSPEND :
	    while(!(keyhit = keyboard()));
	    break;

	}
    }


    olddirn = pacptr->dirn;

    graphics(OFF);
    joystick = (in(JOYPORT) & 0x0F);
	if(joystick == 0x07)
	    pacptr->dirn = DRIGHT;
	else if(joystick == 0x0B)
	    pacptr->dirn = DLEFT;
        else if(joystick == 0x0D)
	    pacptr->dirn = DDOWN;
	else if(joystick == 0x0E)
            pacptr->dirn = DUP;
	else pacptr->dirn = DNULL;
    graphics(ON);
}

#endif


#ifdef KEYBOARD


poll()

{
    int keyhit;
    
    olddirn = pacptr->dirn;

kbdloop:
    keyhit = toupper(in(KBDPORT) ^ KEYMASK);
    if(keyhit == left)
	pacptr->dirn = DLEFT;
    else if(keyhit == right)

	pacptr->dirn = DRIGHT;
    else if(keyhit == up)

	pacptr->dirn = DUP;
    else if(keyhit == down)

	pacptr->dirn = DDOWN;
    else if(keyhit == quit)

	over();
    else if(keyhit == suspend)	{

	while((in(KBDPORT) ^ KEYMASK) == suspend)
	;
	goto kbdloop;

    }
}

#endif


#asm
	public keyboard
keyboard:
	push b
	mvi c,6
	mvi e,0ffh
	call 0005h
	mov l,a
	mvi h,0
	ora a
	pop b
	ret
#endasm


#define MULTIPLIER	25173
#define INCREMENT	13849
#define	MODULUS		32767

unsigned seed;

srand()
{
    int keyhit;
    printf("\n\nTo redo the key settings, type 'R'.");
    printf("\nTo change the difficulty level, type 'L'.");
    printf("\nPressing any other key will start the game!\n");
    while(!(keyhit = keyboard())) seed++;
    if(keyhit == 'r' || keyhit == 'R')	{
	instruct();
	game();
    }
    if(keyhit == 'l' || keyhit == 'L')	{
	setlevel();
	game();
    }
}


rand()
{
    seed = (MULTIPLIER * seed + INCREMENT);
    return(seed % MODULUS);
}


getrand(range)
unsigned range;
{
    return(rand() % range);
}


static char initarray[8]  =  {0x02, 0x82, 0x07, 0xff, 0x03, 0x3e, 0x03, 0x0};

getscreen()
{
    FILE *fopen(), *fp;
    register i;
    
    printf("Getting pacman.scr.\n");
    if((fp = fopen("pacman.scr", "r")) == NULL)	{
	fprintf(stderr, "Error: Can't open pacman.scr.\n");
	exit(0);
    }

#ifdef BIGBOARD
    out(SYSPORT + 1, 0xcf);
    out(SYSPORT + 1, 0x08);
    out(SYSPORT, 0x10 | in(SYSPORT));	
#endif

#ifdef SIO
    out(BSIO + 2, 0x05);
    out(BSIO + 2, 0x68);
#endif

    for(i = 0; i < 8; i++)	{
	out(VDPCNTL, initarray[i]);
	out(VDPCNTL, 0x80 + i);
    }

    vdpram(0, WRITE);
    for(i = 0; i < 0x3800; i++)
	out(VDPDATA, getc(fp));
    out(VDPCNTL, 0xc2);
    out(VDPCNTL, 0x81);
}


vdpram(addr, mode)
unsigned addr;
int mode;
{
    if(mode)
	addr &=  0x3fff;
    else
	addr |=  0x4000;
    out(VDPCNTL, addr);
    out(VDPCNTL, addr / 0x100);
}


pntmap(box, pattern)
unsigned box, pattern;
{
    vdpram(PNTBASE + box, WRITE);
    out(VDPDATA, pattern);
}

#ifndef SIO

graphics(flag)		/*   turns access to the VDP chip ON and OFF	*/
int flag;
{
    out(SYSPORT + 1, 0xcf);	/* program SYSPIO toggle bit as output	*/
    out(SYSPORT + 1, 0x08);
    if(flag)
	out(SYSPORT, (char)(ONMASK | in(SYSPORT)));	/*  VDP -> ON	*/
    else
	out(SYSPORT, (char)(OFFMASK & in(SYSPORT)));	/*  VDP -> OFF	*/
}

#endif

#ifdef SIO

graphics(flag)
int flag;
{
	out(BSIO + 2, 0x05);
	if(flag)
		out(BSIO + 2, 0x68);         /* VDP ON */ 
	else
		out(BSIO + 2, 0xe8);         /* VDP OFF */
}

#endif

