#define SVC6
#define	M3240

/*
 * tunable variables
 */

#define	NBUF	50		/* size of buffer cache */
#define	NINODE	200		/* number of in core inodes */
#define	NFILE	175		/* number of in core file structures */
#define	NMOUNT	24		/* number of mountable file systems */
#define	MAXUPRC	25		/* max processes per user */
#define	MAXMEM	((1024*1024)>>CSHIFT)	/* max core per process - first # is Kb */
#define	SSIZE	((4*1024)>>CSHIFT)	/* initial stack size (*CLICK bytes) */
#define	SINCR	((4*1024)>>CSHIFT)	/* increment of stack (*CLICK bytes) */
#define	NOFILE	20		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	CMAPSIZ	100		/* size of core allocation area */
#define	SMAPSIZ	100		/* size of swap allocation area */
#define	NCALL	20		/* max simultaneous time callouts */
#define	NPROC	150		/* max number of processes */
#define	NTEXT	40		/* max number of pure texts */
#define	NTTY	30		/* approx number of terminals */
#define	NCLIST	(NTTY*10)	/* max total clist size */
#define	HZ	100		/* Ticks/second of the clock */
#define	TIMEZONE (-10*60)	/* Minutes westward from Greenwich */
#define	DSTFLAG	1		/* Daylight Saving Time applies in this locality */
#define	MSGBUFS	128		/* Characters saved from error messages */
#define	NCARGS	5120		/* # characters in exec arglist */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	40
#define	PUSER	50

/*
 * signals
 * dont change
 */

#define	NSIG	17
/*
 * No more than 16 signals (1-16) because they are
 * stored in bits in a word.
 */
#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (FS) */
#define	SIGINS	4	/* illegal instruction */
#define	SIGTRC	5	/* trace or breakpoint */
#define	SIGIOT	6	/* iot */
#define	SIGEMT	7	/* emt */
#define	SIGFPT	8	/* floating exception */
#define	SIGKIL	9	/* kill, uncatchable termination */
#define	SIGBUS	10	/* bus error */
#define	SIGSEG	11	/* segmentation violation */
#define	SIGSYS	12	/* bad system call */
#define	SIGPIPE	13	/* end of pipe */
#define	SIGCLK	14	/* alarm clock */
#define	SIGTRM	15	/* Catchable termination */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define NREGS	(16+2)		/* user registers + pc + ps (in regloc) */
#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define WSHIFT	2		/* log2(NBPW) */
#define	BSIZE	512		/* size of secondary block (bytes) */
/* BSLOP can be 0 unless you have a TIU/Spider */
#define	BSLOP	0		/* In case some device needs bigger buffers */
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	BMASK	0777		/* BSIZE-1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */
#define	NMASK	0177		/* NINDIR-1 */
#define	NSHIFT	7		/* LOG2(NINDIR) */
#define	SEGMENT	(64*1024)	/* memory segment size (bytes) */
#ifdef	M3240
#define	CLICK	2048		/* memory click size (bytes) */
#define	CSHIFT	11		/* LOG2(CLICK) */
#else
#define	CLICK	256		/* memory click size (bytes) */
#define	CSHIFT	8		/* LOG2(CLICK) */
#endif
#define	USIZE	((2*1024)>>CSHIFT)	/* size of user block (*CLICK) */
#define	UBASE	0xf0000		/* abs. addr of user block */
#define	NULL	0
#define	CMASK	0		/* default mask for file creation */
#define	NODEV	(dev_t)(-1)
#ifdef V6
#define ROOTINO	((ino_t)1)	/* i number of all roots */
#else
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#endif
#define	SUPERB	((daddr_t)1)	/* block number of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#ifdef V6
#define NICINOD	50		/* number of superblock inodes */
#else
#define	NICINOD	100		/* number of superblock inodes */
#endif
#define	NICFREE	50		/* number of superblock free blocks */
#define	INFSIZE	138		/* size of per-proc info for users */
#define	CBSIZE	12		/* number of chars in a clist block */
#define	CROUND	017		/* clist rounding: sizeof(int *) + CBSIZE - 1*/

/*
 * Some macros for units conversion
 */
/* Core clicks to segments and vice versa */
#define	ctos(x)	((x+((SEGMENT/CLICK)-1))/(SEGMENT/CLICK))
#define stoc(x) ((x)*(SEGMENT/CLICK))

/* Core clicks to disk blocks */
#if	CSHIFT > BSHIFT
#define	ctod(x)	((x)<<(CSHIFT-BSHIFT))
#else
#define	ctod(x)	(((x)+((1<<(BSHIFT-CSHIFT))-1))>>(BSHIFT-CSHIFT))
#endif

/* inumber to disk address */
#define	itod(x)	(daddr_t)(((/***(unsigned)***/x+15)>>3))

/* inumber to disk offset */
#define	itoo(x)	(int)((x+15)&07)

/* clicks to bytes */
#define	ctob(x)	(x<<CSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((/***(unsigned)***/x+(CLICK-1))>>CSHIFT))

/* major part of a device */
#define	major(x)	(int)((/***(unsigned)***/x>>8))

/* minor part of a device */
#define	minor(x)	(int)(x&0377)

/* make a device number */
#define	makedev(x,y)	(dev_t)((x)<<8 | (y))

typedef	struct { int r[1]; } *	physadr;
typedef	long		daddr_t;
typedef char *		caddr_t;
typedef	unsigned short	ino_t;
typedef	long		time_t;
typedef	int		label_t[9];	/* regs 7-15 */
typedef short		dev_t;
typedef	long		off_t;

/*
 * Machine-dependent bits and macros
 */
#define	UMODE	0x100		/* usermode bits */
#define	USERMODE(ps)	(ps & UMODE)

#define	INTPRI	0340		/* Priority bits */
#define	BASEPRI(ps)	((ps & INTPRI) != 0)
