/* SCCS_ID @(#)inode.h    	3.3	 07:55:51 - 83/04/05 */

#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif

/*
 * The I node is the focus of all
 * file activity in unix. There is a unique
 * inode allocated for each active file,
 * each current directory, each mounted-on
 * file, text file, and the root. An inode is 'named'
 * by its dev/inumber pair. (iget/iget.c)
 * Data, from mode on, is read in
 * from permanent inode on volume.
 */

#ifdef V6
#define NADDR	8
#else  V6
#ifdef  UCB_SMINO
#define	NADDR	7
#else   UCB_SMINO
#define	NADDR	13
#endif  UCB_SMINO
#endif V6

#ifdef  UCB_SMINO
#define	NINDEX	6
#else   UCB_SMINO
#define	NINDEX	15
#endif  UCB_SMINO

struct group {
	short	g_state;
	char	g_index;
	char	g_rot;
	struct	group	*g_group;
	struct	inode	*g_inode;
	struct	file	*g_file;
	short	g_rotmask;
	short	g_datq;
	struct	chan *g_chans[NINDEX];
};
struct	inode
{
	char	i_flag;
	char	i_count;	/* reference count */
	dev_t	i_dev;		/* device where inode resides */
	ino_t	i_number;	/* i number, 1-to-1 with device address */
#ifdef V6
	long	i_mode;
#else  V6
	unsigned short	i_mode;
#endif V6
	short	i_nlink;	/* directory entries */
	short	i_uid;		/* owner */
	short	i_gid;		/* group of owner */
	off_t	i_size;		/* size of file */
	union {
		struct {
			daddr_t I_addr[NADDR];  /* if normal file/directory */
			daddr_t I_lastr;        /* last logical block read (for read-ahead) */
		} i_f;
#define i_addr  i_f.I_addr
#define i_lastr i_f.I_lastr
		struct  {
			daddr_t I_rdev;         /* i_addr[0] */
			struct  group I_group;  /* multiplexor group file */
		} i_d;
#define i_rdev  i_d.I_rdev
#define i_group i_d.I_group
#ifdef  UCB_QUOTAS
		struct  {
			daddr_t I_qused;
			daddr_t I_qmax;
		} i_q;
#define i_qused i_q.I_qused
#define i_qmax  i_q.I_qmax
#endif  UCB_QUOTAS
	} i_un;
#ifdef  UCB_QUOTAS
	struct inode    *i_quot;        /* pointer to quota inode */
#endif  UCB_QUOTAS
#ifdef	UCB_IHASH
	struct	inode *i_link;	/* link in hash chain (iget/iput/ifind) */
#endif  UCB_IHASH
	struct locklist *i_locklist;	/* file locking locked region list */
};

/* file locking hooks */
struct locklist
{
	/* NOTE link must be first in struct */
	struct	locklist *ll_link;	/* link to next lock region */
	int	ll_flags;		/* misc flags ** sleeping */
	struct	proc *ll_proc;		/* process which owns region */
	off_t	ll_start;		/* starting offset */
	off_t	ll_end;			/* ending offset, zero is eof */
};

#define	NFLOCKS	200
#ifdef  KERNEL
extern struct locklist locklist[];	/* the lock table itself */
extern struct inode *inode;     /* The inode table itself */
extern struct inode *inodeNINODE;/* &inode[ninode] */
struct inode *mpxip;		/* mpx virtual inode */
#endif  KERNEL

/* flags */
#define	ILOCK	01		/* inode is locked */
#define	IUPD	02		/* file has been modified */
#define	IACC	04		/* inode access time to be updated */
#define	IMOUNT	010		/* inode is mounted on */
#define	IWANT	020		/* some process waiting on lock */
#define	ITEXT	040		/* inode is pure text prototype */
#define	ICHG	0100		/* inode has been changed */
#ifdef  UCB_QUOTAS
#define IQUOT   0200    /* directory that has original quota pointer */
#endif  UCB_QUOTAS

/* modes */
#define	IFMT	0170000		/* type of file */
#define		IFDIR	0040000	/* directory */
#define		IFCHR	0020000	/* character special */
#define		IFBLK	0060000	/* block special */
#define		IFREG	0100000	/* regular */
#define		IFMPC	0030000	/* multiplexed char special */
#define		IFMPB	0070000	/* multiplexed block special */
#ifdef  UCB_QUOTAS
#define         IFQUOT  0140000 /* quota */
#endif  UCB_QUOTAS
#define	ISUID	04000		/* set user id on execution */
#define	ISGID	02000		/* set group id on execution */
#define ISVTX	01000		/* save swapped text even after use */
#define	IREAD	0400		/* read, write, execute permissions */
#define	IWRITE	0200
#define	IEXEC	0100
#ifdef SVC6
#define	DIALLOC	0100000
#define	DIFMT	060000
#define	DILARG	010000
#define ILARG	0200000
#endif SVC6

#ifdef  UCB_GRPMAST
#define grpmast()       (u.u_uid == u.u_gid)
#endif  UCB_GRPMAST
