/* SCCS_ID @(#)filsys.h    	3.1	 11:58:32 - 81/10/28 */

#ifndef LOCALS_INCLUDED
# include <sys/local.h>
#endif

/*
 * Structure of the super-block
 */
#ifdef	V6
struct	filsys
{
	int	s_isize;	/* size in blocks of I list */
	int	s_fsize;	/* size in blocks of entire volume */
	int	s_nfree;	/* number of in core free blocks (0-50) */	/***/
	int	s_free[NICFREE];	/* in core free blocks */	/***/
	int	s_ninode;	/* number of in core I nodes (0-50) */	/***/
	int	s_inode[NICINOD];	/* in core free I nodes */	/***/
	char	s_flock;	/* lock during free list manipulation */
	char	s_ilock;	/* lock during I list manipulation */
	char	s_fmod;		/* super block modified flag */
	char	s_ronly;	/* mounted read-only flag */
	int	s_timx;
	time_t	s_time;		/* current data of last update */
	int	pad[21];	/***/
};
#else
struct	filsys {
	unsigned short s_isize;	/* size in blocks of i-list */
	daddr_t	s_fsize;   	/* size in blocks of entire volume */
	short  	s_nfree;   	/* number of addresses in s_free */
	daddr_t	s_free[NICFREE];/* free block list */
	short  	s_ninode;  	/* number of i-nodes in s_inode */
	ino_t  	s_inode[NICINOD];/* free i-node list */
	char   	s_flock;   	/* lock during free list manipulation */
	char   	s_ilock;   	/* lock during i-list manipulation */
	char   	s_fmod;    	/* super block modified flag */
	char   	s_ronly;   	/* mounted read-only flag */
	time_t 	s_time;    	/* last super block update */
	/* remainder maintained by system only if ifdefs turned on */
	daddr_t	s_tfree;   	/* total free blocks*/
	ino_t  	s_tinode;  	/* total free inodes */
	short	s_dinfo[2];	/* interleave stuff */
#define	s_m	s_dinfo[0]
#define	s_n	s_dinfo[1]
#ifdef	UCB_FSNAM
	char	s_fsmnt[12];	/* ordinary file mounted on */
#define	s_fname	s_fsmnt
#define s_fpack	""
#else   UCB_FSNAM
	char   	s_fname[6];	/* file system name */
	char   	s_fpack[6];	/* file system pack name */
#endif  UCB_FSNAM
#ifdef	CGL_ISRCH
	ino_t	s_lasti;	/* start place for circular search */
	ino_t	s_nbehind;	/* est # free inodes before s_lasti */
#endif
};
#endif
