/* xdr_dbx.c  - xdr routines for remote dbx interface to VxWorks  */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
modification history
--------------------
01d,14dec87,gae  documentation.
01c,17nov87,dnw  changed name to xdr_dbx.[hc].
01b,17nov87,ecs  lint.
01a,23oct87,rdc  written.
*/

/*
DESCRIPTION
This module contains the eXternal Data Representation (XDR) routines
for the DBX interface for VxWorks.
*/

#include "UniWorks.h"
#include "wait.h"
#include "rpc.h"
#include "xdr_dbx.h"

LOCAL char *argvec[MAXNCMDARGS];


/* forward declarations */

bool_t xdr_String();   	/* xdr routine for argument list */


/*******************************************************************************
*
* xdr_arg_info - xdr routine for argument list
*
* INTERNAL
* not reentrant
*/

bool_t xdr_arg_info (xdrs, objp)
    XDR	*xdrs;
    Arg_info *objp;

    {
    /* allocate storage here to pass arg list in null terminated
     * fashion expected by execv
     */
    if (xdrs->x_op == XDR_DECODE) 
	{
	bzero((char *) argvec, sizeof(argvec));
	objp->rargv = argvec;
	}

    return (xdr_array (xdrs, (char *) &objp->rargv, (UINT *) &objp->rargc,
	    MAXNCMDARGS, sizeof(char *), xdr_String));
    }
/*******************************************************************************
*
* xdr_String - xdr routine for strings.
* 
* Used by xdr_arg_info to handle the actual argument
* strings.  normally calls xdr_string - but does something 
* reasonable encode of null pointer.
*/

LOCAL bool_t xdr_String (xdrs, strp)
    XDR	*xdrs;
    char **strp;

    {
    if ((*strp == NULL) & (xdrs->x_op == XDR_ENCODE)) 
	return(FALSE);
    else 
	return(xdr_string(xdrs, strp, MAXSTRLEN));
    }
/*******************************************************************************
*
* xdr_wait_info - xdr routine for wait3 result
*/

bool_t xdr_wait_info (xdrs, objp)
    XDR	*xdrs;
    Wait_info *objp;

    {	
    if (! xdr_int(xdrs, &objp->pid)) 
	return(FALSE);

    if (! xdr_int(xdrs, &objp->status)) 
	return(FALSE);

    return(TRUE);
    }
/*******************************************************************************
*
* xdr_ldfile - xdr routine for a single element in the load table 
*/

bool_t xdr_ldfile (xdrs, objp)
    XDR *xdrs;
    ldfile *objp;

    {
    if (! xdr_String(xdrs, &objp->name)) 
	return(FALSE);
    if (! xdr_int(xdrs, &objp->txt_addr)) 
	return(FALSE);
    if (! xdr_int(xdrs, &objp->data_addr)) 
	return(FALSE);
    if (! xdr_int(xdrs, &objp->bss_addr)) 
	return(FALSE);

    return(TRUE);
    }
/*******************************************************************************
*
* xdr_ldtabl -
*
* xdr routine for a list of files and load addresses loaded into VxWorks.
*/

bool_t xdr_ldtabl (xdrs,objp)
    XDR *xdrs;
    ldtabl *objp;

    {
    return (xdr_array (xdrs, (char *) &objp->tbl_ent, (UINT *) &objp->tbl_size, 
	    MAXTBLSZ, sizeof(ldfile), xdr_ldfile));
    }
