/* m68562.h - M68562 Serial I/O Chip header */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01c,10aug88,gae  got rid of ^L which are unloved by some assemblers.
01b,21jun88,mcl  changed to be generic, not just mz7122; adds documentation.
01a,26jan88,sah  written.
*/

#ifndef	INCm68562h
#define	INCm68562h


#define N_CHANNELS	2	/* number of channels per chip */

/* channel mode register one (CMR1A, CMR1B) */

#define M562_CMR1_BOP_PRIMARY		0x00	/* BOP: channel protocol mode */
#define M562_CMR1_BOP_SECONDARY		0x01	/* BOP: channel protocol mode */
#define M562_CMR1_BOP_LOOP		0x02	/* BOP: channel protocol mode */
#define M562_CMR1_BOP_LOOP_NO_ADR_CMP	0x03	/* BOP: channel protocol mode */
#define M562_CMR1_BOP_8BIT_ADRS		0x00	/* BOP: single octet address */
#define M562_CMR1_BOP_EXT_ADRS		0x08	/* BOP: extended address */
#define M562_CMR1_BOP_16BIT_ADRS	0x10	/* BOP: dual octet address */
#define M562_CMR1_BOP_16BIT_GRP_ADRS	0x18	/* BOP: dual octet address with group */
#define M562_CMR1_BOP_1_OCTET_CNT	0x00	/* BOP: 1 control field follows address */
#define M562_CMR1_BOP_2_OCTET_CNT	0x20	/* BOP: 2 control fields follow address */

#define M562_CMR1_COP_DUAL_SYN		0x04	/* COP: channel protocol mode */
#define M562_CMR1_COP_BISYNC		0x05	/* COP: channel protocol mode */
#define M562_CMR1_COP_SINGLE_SYN	0x06	/* COP: channel protocol mode */
#define M562_CMR1_COP_NO_PARITY		0x00	/* COP: channel parity none */
#define M562_CMR1_COP_WITH_PARITY	0x10	/* COP: channel parity odd/even */
#define M562_CMR1_COP_FORCE_PARITY	0x18	/* COP: channel parity hi/lo */
#define M562_CMR1_COP_EVEN_PARITY	0x00	/* COP: channel parity even */
#define M562_CMR1_COP_ODD_PARITY	0x20	/* COP: channel parity odd */
#define M562_CMR1_COP_BISYNC_EBCDIC	0x00	/* COP: comparisons in EBCDIC */
#define M562_CMR1_COP_BISYNC_ASCII	0x20	/* COP: comparisons in ASCII */

#define M562_CMR1_ASYNC			0x07	/* channel protocol mode: asynchronous */

#define M562_CMR1_NRZ			0x00	/* non-return-to-zero */
#define M562_CMR1_NRZI			0x40	/* non-return-to-zero, inverted */
#define M562_CMR1_FM0			0x80	/* bi-phase space */
#define M562_CMR1_FM1			0xc0	/* bi-phase mark */


/* equates for channel mode register two (CMR2A, CMR2B) */

#define M562_CMR2_FCS_SEL_NONE		0x00	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_LRC_8_PRS0	0x02	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_LRC_8_PRS1	0x03	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_CRC_16_PRS0	0x04	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_CRC_16_PRS1	0x05	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_CRC_CC_PRS0	0x06	/* frame check sequence select */
#define M562_CMR2_FCS_SEL_CRC_CC_PRS1	0x07	/* frame check sequence select */

#define M562_CMR2_DTI_HLFDUP_SADRDMA	0x00	/* data transfer interface */
#define M562_CMR2_DTI_HLFDUP_DADRDMA	0x08	/* data transfer interface */
#define M562_CMR2_DTI_FULDUP_SADRDMA	0x10	/* data transfer interface */
#define M562_CMR2_DTI_FULDUP_DADRDMA	0x18	/* data transfer interface */
#define M562_CMR2_DTI_WAIT_RX		0x20	/* data transfer interface */
#define M562_CMR2_DTI_WAIT_TX		0x28	/* data transfer interface */
#define M562_CMR2_DTI_WAIT_RX_TX	0x30	/* data transfer interface */
#define M562_CMR2_DTI_POLL_OR_INT	0x38	/* data transfer interface */

#define M562_CMR2_CHN_CON_NORNAL	0x00	/* channel connection */
#define M562_CMR2_CHN_CON_AUTO_ECHO	0x40	/* channel connection */
#define M562_CMR2_CHN_CON_LOCAL_LOOP	0x80	/* channel connection */

/* equates for transmit parameter register (TPRA, TPRB) */

#define M562_TPR_5BITS			0x00	/* transmit 5 bits per character */
#define M562_TPR_6BITS			0x01	/* transmit 6 bits per character */
#define M562_TPR_7BITS			0x02	/* transmit 7 bits per character */
#define M562_TPR_8BITS			0x03	/* transmit 8 bits per character */

#define M562_TPR_CTS_EN_TX_ENABLE	0x04	/* CTS_N affects transmitter */

#define M562_TPR_TX_RTS_CONT_YES	0x08	/* RTS_N affected by transmitter */

#define M562_TPR_ASYNC_9_16		0x00	/* async: 9/16 stop bits */
#define M562_TPR_ASYNC_10_16		0x10	/* async: 10/16 stop bits */
#define M562_TPR_ASYNC_11_16		0x20	/* async: 11/16 stop bits */
#define M562_TPR_ASYNC_12_16		0x30	/* async: 12/16 stop bits */
#define M562_TPR_ASYNC_13_16		0x40	/* async: 13/16 stop bits */
#define M562_TPR_ASYNC_14_16		0x50	/* async: 14/16 stop bits */
#define M562_TPR_ASYNC_15_16		0x60	/* async: 15/16 stop bits */
#define M562_TPR_ASYNC_1		0x70	/* async: 16/16 stop bits */
#define M562_TPR_ASYNC_1_9_16		0x80	/* async: 1 stop bit */
#define M562_TPR_ASYNC_1_10_16		0x90	/* async: 10/16 stop bits */
#define M562_TPR_ASYNC_1_11_16		0xa0	/* async: 11/16 stop bits */
#define M562_TPR_ASYNC_1_12_16		0xb0	/* async: 12/16 stop bits */
#define M562_TPR_ASYNC_1_13_16		0xc0	/* async: 13/16 stop bits */
#define M562_TPR_ASYNC_1_14_16		0xd0	/* async: 14/16 stop bits */
#define M562_TPR_ASYNC_1_15_16		0xe0	/* async: 15/16 stop bits */
#define M562_TPR_ASYNC_2		0xf0	/* async: 2 stop bits */

#define M562_TPR_COP_TEOM_NO		0x00	/* COP: no EOM on zero or done */
#define M562_TPR_COP_TEOM_YES		0x10	/* COP: transmit EOM on zero or done */
#define M562_TPR_COP_IDLE_MARK		0x00	/* COP: idle in marking condition */
#define M562_TPR_COP_IDLE_SYN		0x20	/* COP: idle sending SYNs */
#define M562_TPR_COP_UNDR_FCS		0x00	/* COP: normal end of msg termination */
#define M562_TPR_COP_UNDR_MARK		0x80	/* COP: place TxD in marking condition */
#define M562_TPR_COP_UNDR_SYN		0xc0	/* COP: send SYNs */

#define M562_TPR_BOP_TEOM_NO		0x00	/* BOP: no EOM on zero or done */
#define M562_TPR_BOP_TEOM_YES		0x10	/* BOP: transmit EOM on zero or done */
#define M562_TPR_BOP_IDLE_MARK		0x00	/* BOP: idle in marking condition */
#define M562_TPR_BOP_IDLE_SYN		0x20	/* BOP: idle sending FLAGs */
#define M562_TPR_BOP_UNDR_FCS		0x00	/* BOP: normal end of msg termination */
#define M562_TPR_BOP_UNDR_ABORT_MARK	0x80	/* BOP: place TxD in marking condition */
#define M562_TPR_BOP_UNDR_ABORT_FLAG	0xc0	/* BOP: send ABORTs */


/* equates for transmitter timing register (TTRA, TTRB) */

#define M562_TTR_BAUD_50		0x00	/* transmit speed */
#define M562_TTR_BAUD_75		0x01	/* transmit speed */
#define M562_TTR_BAUD_110		0x02	/* transmit speed */
#define M562_TTR_BAUD_134_5		0x03	/* transmit speed */
#define M562_TTR_BAUD_150		0x04	/* transmit speed */
#define M562_TTR_BAUD_200		0x05	/* transmit speed */
#define M562_TTR_BAUD_300		0x06	/* transmit speed */
#define M562_TTR_BAUD_600		0x07	/* transmit speed */
#define M562_TTR_BAUD_1050		0x08	/* transmit speed */
#define M562_TTR_BAUD_1200		0x09	/* transmit speed */
#define M562_TTR_BAUD_2000		0x0a	/* transmit speed */
#define M562_TTR_BAUD_2400		0x0b	/* transmit speed */
#define M562_TTR_BAUD_4800		0x0c	/* transmit speed */
#define M562_TTR_BAUD_9600		0x0d	/* transmit speed */
#define M562_TTR_BAUD_19200		0x0e	/* transmit speed */
#define M562_TTR_BAUD_38400		0x0f	/* transmit speed */

#define M562_TTR_CLK_1x_EXT		0x00	/* external clock, 1x baud rate */
#define M562_TTR_CLK_16x_EXT		0x10	/* external clock, 16x baud rate, async */
#define M562_TTR_CLK_DPLL		0x20	/* internal, DPLL, 1x baud rate, half duplex */
#define M562_TTR_CLK_BRG		0x30	/* internal, BRG, 32x baud rate */
#define M562_TTR_CLK_2x_OTHER_CHAN	0x40	/* internal, other channel C/T, 2x baud rate */
#define M562_TTR_CLK_32x_OTHER_CHAN	0x50	/* internal, other channel C/T, 32x baud rate */
#define M562_TTR_CLK_2x_OWN_CHAN	0x60	/* internal, this channel C/T, 2x baud rate */
#define M562_TTR_CLK_32x_OWN_CHAN	0x70	/* internal, this channel C/T, 32x baud rate */

#define M562_TTR_EXT_SOURCE_RTXC	0x00	/* external input from RTxC */
#define M562_TTR_EXT_SOURCE_TRXC	0x80	/* external input from TRxC */

/* equates for receiver parameter register (RPRA, RPRB) */

#define M562_RPR_5BITS			0x00	/* receive 5 bits per character */
#define M562_RPR_6BITS			0x01	/* receive 6 bits per character */
#define M562_RPR_7BITS			0x02	/* receive 7 bits per character */
#define M562_RPR_8BITS			0x03	/* receive 8 bits per character */

#define M562_RPR_DCD_EN_RX_DISABLE	0x00	/* DCD not used to enable receiver */
#define M562_RPR_DCD_EN_RX_ENABLE	0x04	/* DCD used to enable receiver */

#define M562_RPR_ASYNC_STRIP_PARITY_NO	0x00	/* async: do not strip RX parity */
#define M562_RPR_ASYNC_STRIP_PARITY_YES	0x08	/* async: strip RX parity */
#define M562_RPR_ASYNC_RX_RTS_CONT_NO	0x00	/* async: receiver cannot negate RTS_N */
#define M562_RPR_ASYNC_RX_RTS_CONT_YES	0x10	/* async: receiver can negate RTS_N */

#define M562_RPR_COP_STRIP_PARITY_NO	0x00	/* COP: do not strip RX parity */
#define M562_RPR_COP_STRIP_PARITY_YES	0x08	/* COP: strip RX parity */
#define M562_RPR_COP_EXT_SYNC_NO	0x00	/* COP: external SYNC disable */
#define M562_RPR_COP_EXT_SYNC_YES	0x10	/* COP: external SYNC enable */
#define M562_RPR_COP_AUTO_HUNT_NO	0x00	/* COP: disable auto-hunt and PAD check */
#define M562_RPR_COP_AUTO_HUNT_YES	0x20	/* COP: enable auto-hunt and PAD check */
#define M562_RPR_COP_FCS_FIFO_NO	0x00	/* COP: do not transfer FCS to RxFIFO */
#define M562_RPR_COP_FCS_FIFO_YES	0x40	/* COP: transfer FCS to RxFIFO */
#define M562_RPR_COP_SYN_STRIP_LEADING	0x00	/* COP: strip leading SYNs only */
#define M562_RPR_COP_SYN_STRIP_ALL	0x80	/* COP: strip all SYNs */

#define M562_RPR_BOP_ALL_PARITY_ADR_NO	0x00	/* BOP: do not recognize all parties address */
#define M562_RPR_BOP_ALL_PARITY_ADR_YES	0x08	/* BOP: recognize all parties address */
#define M562_RPR_BOP_OVRUN_HUNT		0x00	/* BOP: hunt for FLAG on overrun */
#define M562_RPR_BOP_OVRUN_CONT		0x20	/* BOP: continue on overrun */
#define M562_RPR_BOP_FCS_FIFO_NO	0x00	/* BOP: do not transfer FCS to RxFIFO */
#define M562_RPR_BOP_FCS_FIFO_YES	0x40	/* BOP: transfer FCS to RxFIFO */

/* equates for receiver timing register (RTRA, RTRB) */

#define M562_RTR_BAUD_50		0x00	/* receiver speed */
#define M562_RTR_BAUD_75		0x01	/* receiver speed */
#define M562_RTR_BAUD_110		0x02	/* receiver speed */
#define M562_RTR_BAUD_134_5		0x03	/* receiver speed */
#define M562_RTR_BAUD_150		0x04	/* receiver speed */
#define M562_RTR_BAUD_200		0x05	/* receiver speed */
#define M562_RTR_BAUD_300		0x06	/* receiver speed */
#define M562_RTR_BAUD_600		0x07	/* receiver speed */
#define M562_RTR_BAUD_1050		0x08	/* receiver speed */
#define M562_RTR_BAUD_1200		0x09	/* receiver speed */
#define M562_RTR_BAUD_2000		0x0a	/* receiver speed */
#define M562_RTR_BAUD_2400		0x0b	/* receiver speed */
#define M562_RTR_BAUD_4800		0x0c	/* receiver speed */
#define M562_RTR_BAUD_9600		0x0d	/* receiver speed */
#define M562_RTR_BAUD_19200		0x0e	/* receiver speed */
#define M562_RTR_BAUD_38400		0x0f	/* receiver speed */

#define M562_RTR_CLK_1x_EXT		0x00	/* external clock, 1x baud rate */
#define M562_RTR_CLK_16x_EXT		0x10	/* external clock, 16x baud rate, async */
#define M562_RTR_CLK_BRG		0x20	/* internal BRG clock, 32x baud rate, async */
#define M562_RTR_CLK_CT			0x30	/* internal C/T clock, 32x baud rate, async */
#define M562_RTR_CLK_DPLL_64x		0x40	/* DPLL, internal clock, 64x baud rate */
#define M562_RTR_CK_DPLL_32x_EXT	0x50	/* DPLL, external clock, 32x baud rate */
#define M562_RTR_CK_DPLL_32x_BRG	0x60	/* DPLL, internal BRG clock, 32x baud rate */
#define M562_RTR_CK_DPLL_32x_CT		0x70	/* DPLL, internal C/T clock, 32x baud rate */

#define M562_RTR_EXT_SOURCE_RTXC	0x00	/* external input from RTxC */
#define M562_RTR_EXT_SOURCE_TRXC	0x80	/* external input from TRxC */

/* equates for counter/timer control register (CTCRA, CTCRB) */

#define M562_CTCR_CLK_RTXC		0x00	/* clock source is RTxC pin */
#define M562_CTCR_CLK_TRXC		0x01	/* clock source is TRxC pin */
#define M562_CTCR_CLK_X1_CLK		0x02	/* clock source is clock/4 */
#define M562_CTCR_CLK_X1_CLK_RXD	0x03	/* clock source is clock/4 gated by RxD */
#define M562_CTCR_CLK_RX_BRG		0x04	/* clock source is BRG */
#define M562_CTCR_CLK_TX_BRG		0x05	/* clock source is BRG */
#define M562_CTCR_CLK_RX_CHAR		0x06	/* clock source is rxload */
#define M562_CTCR_CLK_TX_CHAR		0x07	/* clock source is txload */

#define M562_CTCR_PRESCALER_DIV_1	0x00	/* prescale by 1 (no prescale) */
#define M562_CTCR_PRESCALER_DIV_16	0x08	/* prescale by 16 */
#define M562_CTCR_PRESCALER_DIV_32	0x10	/* prescale by 32 */
#define M562_CTCR_PRESCALER_DIV_64	0x18	/* prescale by 64 */

#define M562_CTCR_OUTPUT_CONT_SQUARE	0x00	/* counter roll toggles output */
#define M562_CTCR_OUTPUT_CONT_PULSE	0x20	/* counter roll pulses output */

#define M562_CTCR_ZERO_DET_CONT_PRESET	0x00	/* counter is preset to preset value */
#define M562_CTCR_ZERO_DET_CONT_CONT	0x40	/* counter is preset to 0xffff */

#define M562_CTCR_ZERO_DET_INTR_DISABLE	0x00	/* disable zero detect interrupt */
#define M562_CTCR_ZERO_DET_INTR_ENABLE	0x80	/* enable zero detect interrupt */

/* equates for output and miscellaneous register (OMRA, OMRB) */

#define M562_OMR_RTS_0			0x00	/* request-to-send lo */
#define M562_OMR_RTS_1			0x01	/* request-to-send hi */

#define M562_OMR_GPO1_0			0x00	/* general purpose output 1 lo */
#define M562_OMR_GP01_1			0x02	/* general purpose output 1 hi */

#define M562_OMR_GPO2_0			0x00	/* general purpose output 2 lo */
#define M562_OMR_GPO2_1			0x04	/* general purpose output 2 hi */

#define M562_OMR_RXRDY_FIFO_NOT_EMPTY	0x00	/* set TxRDY until FIFO empty */
#define M562_OMR_RXRDY_FIFO_FULL	0x08	/* set TxRDY if FIFO full */

#define M562_OMR_TXRDY_FIFO_NOT_FULL	0x00	/* set TxRDY until FIFO full */
#define M562_OMR_TXRDY_FIFO_EMPTY	0x10	/* set TxRDY if FIFO empty */

#define M562_OMR_TX_RES_CHAR_LENGTH_1	0x00	/* BOP: last char is 1 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_2	0x20	/* BOP: last char is 2 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_3	0x40	/* BOP: last char is 3 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_4	0x60	/* BOP: last char is 4 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_5	0x80	/* BOP: last char is 5 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_6	0xa0	/* BOP: last char is 6 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_7	0xc0	/* BOP: last char is 7 bits long */
#define M562_OMR_TX_RES_CHAR_LENGTH_TPR	0xe0	/* BOP: last char is TPR[1:0] bits long */


/* equates for pin configuration register (PCRA, PCRB) */

#define M562_PCR_TRXC_INPUT		0x00	/* TRxC function: input */
#define M562_PCR_TRXC_XTAL_2		0x01	/* TRxC function: XTAL/2 output */
#define M562_PCR_TRXC_DPLL		0x02	/* TRxC function: DPLL output */
#define M562_PCR_TRXC_CT		0x03	/* TRxC function: counter/timer output */
#define M562_PCR_TRXC_TXCLK_16x		0x04	/* TRxC function: TTRx16 output */
#define M562_PCR_TRXC_RXCLK_16x		0x05	/* TRxC function: RTRx16 utput */
#define M562_PCR_TRXC_TXCLK_1x		0x06	/* TRxC function: TXC output */
#define M562_PCR_TRXC_RXCLK_1x		0x07	/* TRxC function: RXC output */

#define M562_PCR_RTXC_INPUT		0x00	/* RTxC function: input */
#define M562_PCR_RTXC_CT		0x08	/* RTxC function: counter/timer output */
#define M562_PCR_RTXC_TXCLK_1x		0x10	/* RTxC function: TXC output */
#define M562_PCR_RTXC_RXCLK_1x		0x18	/* RTxC function: RXC output */

#define M562_PCR_SYNOUT_RTS_SYNOUT	0x00	/* RTS is a SYNOUT */
#define M562_PCR_SYNOUT_RTS_RTS		0x20	/* RTS is an RTS */

#define M562_PCR_GPO2_RTS_GPO2		0x00	/* GP02 is a GP02 */
#define M562_PCR_GPO2_RTS_RTS		0x40	/* GP02 is an RTS */

#define M562_PCR_X2_IDC_X2		0x00	/* X2 is crystal connection */
#define M562_PCR_X2_IDC_IDC		0x80	/* X2 is interrupt daisy chain */

/* equates for channel command register (CCRA, CCRB) commands */

#define M562_CCR_TX_RESET_TX		0x00	/* reset transmitter */
#define M562_CCR_TX_RESET_TXCRC		0x01	/* reset transmit CRC */
#define M562_CCR_TX_ENABLE_TX		0x02	/* enable transmitter */
#define M562_CCR_TX_DISABLE_TX		0x03	/* disable transmitter */
#define M562_CCR_TX_TX_TSOM		0x04	/* transmit start of message */
#define M562_CCR_TX_TX_TSOMP		0x05	/* transmit start of message with opening PAD */
#define M562_CCR_TX_TX_TEOM		0x06	/* transmit end-of-message */
#define M562_CCR_TX_TX_TABRK		0x07	/* transmit async break */
#define M562_CCR_TX_TX_TABORT		0x07	/* transmit BOP abort */
#define M562_CCR_TX_TX_DLE		0x08	/* transmit DLE */
#define M562_CCR_TX_ACT_ON_POLL		0x09	/* go active on poll */
#define M562_CCR_TX_RESET_ON_POLL	0x0a	/* reset go active on poll */
#define M562_CCR_TX_GO_ON_LOOP		0x0b	/* go on-loop */
#define M562_CCR_TX_GO_OFF_LOOP		0x0c	/* go off-loop */
#define M562_CCR_TX_EXCLD_CRC		0x0d	/* exclude from CRC */

#define M562_CCR_RX_RESET_RX		0x40	/* reset receiver */
#define M562_CCR_RX_ENABLE_RX		0x42	/* enable receiver */
#define M562_CCR_RX_DISABLE_RX		0x43	/* disable receiver */

#define M562_CCR_CT_START		0x80	/* start counter/timer */
#define M562_CCR_CT_STOP		0x81	/* stop counter/timer */
#define M562_CCR_CT_PRE_FFFF		0x82	/* preset counter/timer to ffff */
#define M562_CCR_CT_PRE_CTPRHL		0x83	/* preset counter/timer per CTPRH/CTPRL */

#define M562_CCR_DPLL_ENTR_SEARCH	0xc0	/* DPLL: enter search mode */
#define M562_CCR_DPLL_DISABLE_DPLL	0xc1	/* DPLL: disable */
#define M562_CCR_DPLL_SET_FM		0xc2	/* DPLL: set FM mode */
#define M562_CCR_DPLL_SET_NRZ1		0xc3	/* DPLL: set NRZI mode */

/* equates for receiver status register (RSRA, RSRB) */

#define M562_RSR_ASYNC_PARITY_ERROR	0x01	/* parity error detected */
#define M562_RSR_ASYNC_FRAMING_ERR	0x02	/* framing error detected */
#define M562_RSR_ASYNC_BRK_STR_DET	0x04	/* break start detected */
#define M562_RSR_ASYNC_BRK_END_DET	0x08	/* break detected */
#define M562_RSR_ASYNC_OVERN_ERROR	0x20	/* overrun error */
#define M562_RSR_ASYNC_RTS_NEGATED	0x40	/* RTS negated while FIFO full */
#define M562_RSR_ASYNC_CHAR_COMP	0x80	/* character compared to S1R */

#define M562_RSR_COP_PARITY_ERROR	0x01	/* parity error detected */
#define M562_RSR_COP_CRC_ERROR		0x02	/* CRC error detected */
#define M562_RSR_COP_SYN_DETECT		0x04	/* SYN detected */
#define M562_RSR_COP_OVERN_ERROR	0x20	/* overrun error */
#define M562_RSR_COP_PAD_ERROR		0x40	/* PAD error detected */
#define M562_RSR_COP_EOM_DETECT		0x80	/* end-of-message detected */

#define M562_RSR_BOP_RCL_NOT_ZERO	0x01	/* xcvd character length not zero */
#define M562_RSR_BOP_FCS_ERROR		0x02	/* FCS error detected */
#define M562_RSR_BOP_FLAG_DETECT	0x04	/* FLAG sequence detected */
#define M562_RSR_BOP_IDLE_DETECT	0x08	/* idle sequence detected */
#define M562_RSR_BOP_SHORT_FRAM_DET	0x10	/* fields were missing in this frame */
#define M562_RSR_BOP_OVERN_ERROR	0x20	/* overrun error */
#define M562_RSR_BOP_ABORT_DETECT	0x40	/* abort sequence detected */
#define M562_RSR_BOP_EOM_DETECT		0x80	/* end-of-message detected */

#define M562_RSR_BOP_LOOP_RCL_NOT_ZERO		0x01	/* xcvd character length not zero */
#define M562_RSR_BOP_LOOP_FCS_ERROR		0x02	/* FCS error detected */
#define M562_RSR_BOP_LOOP_FLAG_DETECT		0x04	/* FLAG sequence detected */
#define M562_RSR_BOP_LOOP_TURN_DETECT		0x08	/* turnaround sequence detected */
#define M562_RSR_BOP_LOOP_SHORT_FRAM_DET	0x10	/* fields were missing in this frame */
#define M562_RSR_BOP_LOOP_OVERN_ERROR		0x20	/* overrun error */
#define M562_RSR_BOP_LOOP_ABORT_DETECT		0x40	/* abort sequence detected */
#define M562_RSR_BOP_LOOP_EOM_DETECT		0x80	/* end-of-message detected */

/* equates for transmitter and receiver status register (TRSRA, TRSRB) */

#define M562_TRSR_ASYNC_DPLL_ERROR	0x08	/* async: DPLL lost lock */
#define M562_TRSR_ASYNC_SND_BRK_ACK	0x10	/* async: xmit now sending break */
#define M562_TRSR_ASYNC_CTS_UNDERRUN	0x40	/* async: CTS underrun */
#define M562_TRSR_ASYNC_TX_EMPTY	0x80	/* async: transmit empty */

#define M562_TRSR_COP_RX_XPRNT		0x01	/* COP: rx in transparent mode*/
#define M562_TRSR_COP_RX_HUNT		0x02	/* COP: rx hunting for SYN */
#define M562_TRSR_COP_DPLL_ERROR	0x08	/* COP: DPLL lost lock */
#define M562_TRSR_COP_SND_ACK		0x10	/* COP: xmit now sending ACK */
#define M562_TRSR_COP_FRAME_COMP	0x20	/* COP: frame complete, end of msg */
#define M562_TRSR_COP_CTS_UNDERRUN	0x40	/* COP: CTS underrun */
#define M562_TRSR_COP_TX_EMPTY		0x80	/* COP: transmit empty */

#define M562_TRSR_BOP_RESDL_RX_0BIT	0x00	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_1BIT	0x01	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_2BIT	0x02	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_3BIT	0x03	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_4BIT	0x04	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_5BIT	0x05	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_6BIT	0x06	/* BOP: received residual character length */
#define M562_TRSR_BOP_RESDL_RX_7BIT	0x07	/* BOP: received residual character length */

#define M562_TRSR_BOP_DPLL_ERROR	0x08	/* BOP: DPLL lost lock */
#define M562_TRSR_BOP_SND_ABRT_ACK	0x10	/* BOP: xmit now sending ABORT */
#define M562_TRSR_BOP_FRAME_COMPLETE	0x20	/* BOP: frame complete, end of msg */
#define M562_TRSR_BOP_CTS_UNDERRUN	0x40	/* BOP: CTS underrun */
#define M562_TRSR_BOP_TX_EMPTY		0x80	/* BOP: transmit empty */

#define M562_TRSR_LOOP_LOOP_SND		0x40	/* LOOP: EOP sequence detected */


/* equates for input and counter/timer status register (ICTSRA, ICTSRB) */

#define M562_ICTSR_GPI1			0x01	/* state of GPI1 pin */

#define M562_ICTSR_GPI2			0x02	/* state of GPI2 pin */

#define M562_ICTSR_CTSLC		0x04	/* state of CTLSC pin */

#define M562_ICTSR_DCD			0x08	/* state of DCD pin */

#define M562_ICTSR_DELTA_CTSLC		0x10	/* CTS (async) or LC (SDLC) changed */
#define M562_ICTSR_DELTA_DCD		0x20	/* DCD changed */

#define M562_ICTSR_CT_ZERO_COUNT	0x40	/* 1 = zero detected */
#define M562_ICTSR_CT_RUNNING		0x80	/* counter/timer is running */


/* equates for general status register (GSR) */

#define M562_GSR_A_RXRDY		0x01	/* received a character on A */
#define M562_GSR_A_TXRDY		0x02	/* ready to transmit character on A */
#define M562_GSR_A_RXTX_STATUS		0x04	/* refer to RSRA[7:0], TRSRA[7:3] */
#define M562_GSR_A_EXTERNAL_STATUS	0x08	/* refer to ICTSRA[6:4] */
#define M562_GSR_A_ALL			0x0f	/* mask for above */

#define M562_GSR_B_RXRDY		0x10	/* received a character on B */
#define M562_GSR_B_TXRDY		0x20	/* ready to transmit character on B */
#define M562_GSR_B_RXTX_STATUS		0x40	/* refer to RSRB[7:0], TRSRB[7:3] */
#define M562_GSR_B_EXTERNAL_STATUS	0x80	/* refer to ICTSRB[6:4] */
#define M562_GSR_B_ALL			0xf0	/* mask for above */

/* equates for interrupt enable register (IERA, IERB) */

#define M562_IER_RSR_1_0		0x01	/* interrupt if RSR [0 or 1] */
#define M562_IER_RSR_3_2		0x02	/* interrupt if RSR [2 or 3] */
#define M562_IER_RSR_5_4		0x04	/* interrupt if RSR [4 or 5] */
#define M562_IER_RSR_7_6		0x08	/* interrupt if RSR [6 or 7] */

#define M562_IER_RXRDY			0x10	/* interrupt if RxRDY */
#define M562_IER_TRSR			0x20	/* interrupt if TRSR bits 3-7 */
#define M562_IER_TXRDY			0x40	/* interrupt if TxRDY */
#define M562_IER_DCD_CTS		0x80	/* interrupt if DCD or CTS */


/* equates for interrupt control register (ICR) */

#define M562_ICR_CHAN_B_MAST_INT_EN	0x01	/* channel B master interrupt enable */

#define M562_ICR_CHAN_A_MAST_INT_EN	0x02	/* channel A master interrupt enable */

#define M562_ICR_VECT_INCLDS_STATUS	0x04	/* 1 = use IVRM, 0 = use IVR */

#define M562_ICR_BITS_MOD_2_0		0x00	/* modify vector bits 2:0 */
#define M562_ICR_BITS_MOD_4_2		0x08	/* modify vector bits 4:2 */

#define M562_ICR_VECT_MODE_VECT_A	0x00	/* interrupts are vectored */
#define M562_ICR_VECT_MODE_VECT_B	0x10	/* interrupts are vectored */
#define M562_ICR_VECT_MODE_VECT_C	0x20	/* interrupts are vectored */
#define M562_ICR_VECT_MODE_NOT_VECT	0x30	/* interrupts are non-vectored */

#define M562_ICR_CHN_AB_INT_PRI_A	0x00	/* channel A has highest priority */
#define M562_ICR_CHN_AB_INT_PRI_B	0x40	/* interleaved priorities, A favored */
#define M562_ICR_CHN_AB_INT_PRI_INTL_A	0x80	/* channel B has highest priority */
#define M562_ICR_CHN_AB_INT_PRI_INTL_B	0xc0	/* interleaved priorities, B favored */


/* equates for interrupt vector - as modified by IVRM */

#define M562_IVRM_MASK			0x07	/* bits that can be modified */
#define M562_IVRM_MASK_CHANNEL		0x04	/* 1 = channel B, 0 = channel A */
#define M562_IVRM_RXRDY			0x00	/* offset for RxRDY interrupt */
#define M562_IVRM_TXRDY			0x01	/* offset for TxRDY interrupt */
#define M562_IVRM_RX_TX_EXCEPTION	0x02	/* offset for rx/tx error interrupt */
#define M562_IVRM_EXTERN_OR_CT		0x03	/* offset for external & counter/timer interrupt */

#endif	INCm68562h
