/* if_ln.h - MVME-147 LANCE ethernet interface header file */

/* Copyright (c) 1988 Wind River Systems, Inc. */

/*
modification history
--------------------
01b,09aug88,gae  bumped up LN_BUFSIZE to solve large packet problems.
01a,15apr88,dfm  written.
*/

#ifndef	INCif_lnh
#define	INCif_lnh

/*
 * Control block definitions for AMD LANCE (Ethernet) chip.
 * This has some of the same (mis)features as the Intel 82586 with
 * regards to byte ordering.  It assumes that a memory address specifies 
 * the location of the least significant byte of a multi-byte value.  This
 * is correct for most Intel & DEC processors, but is wrong for 680x0s.
 * As a result, all addresses specified to the chip must have their
 * words swapped.  At least it has a control bit to automatically swap
 * bytes during data transfer dma.  (The 82586 is much worse.)
 */

/*
 * Control and Status Register access structure
 * WARNING: bit operations should not be done on CSR0!
 * Many of the bits are Read/Clear and will be cleared by any other
 * bit operation on the register.  Note especially that if the
 * stop bit is set, all other operations will retain the stopped
 * condition.  This means that a bit set to do init and start will
 * always fail because stop has priority.
 */
typedef struct {
    union {
	u_short	    RDP;
        u_short	    lnCSR0;	/* RDP if (RAP==0) */

#define  lncsr_ERR    0x8000	/* (RO) error flag (BABL|CERR|MISS|MERR) */
#define  lncsr_BABL   0x4000	/* (RC) babble transmitter timeout */
#define  lncsr_CERR   0x2000	/* (RC) collision error */
#define  lncsr_MISS   0x1000	/* (RC) missed packet */
#define  lncsr_MERR   0x0800	/* (RC) memory error */
#define  lncsr_RINT   0x0400	/* (RC) receiver interrupt */
#define  lncsr_TINT   0x0200	/* (RC) transmitter interrupt */
#define  lncsr_IDON   0x0100	/* (RC) initialization done */
#define  lncsr_INTR   0x0080	/* (RO) interrupt flag (BABL|MISS|MERR|RINT|TINT|IDON) */
#define  lncsr_INEA   0x0040	/* (RW) interrupt enable */
#define  lncsr_RXON   0x0020	/* (RO) receiver on */
#define  lncsr_TXON   0x0010	/* (RO) transmitter on */
#define  lncsr_TDMD   0x0008	/* (WOO)transmit demand */
#define  lncsr_STOP   0x0004	/* (WOO)stop (& reset) chip */
#define  lncsr_STRT   0x0002	/* (RW) start chip */
#define  lncsr_INIT   0x0001	/* (RW) initialize (acces init block) */

	u_short	lnCSR1;		/* RDP if (RAP==1) */
	u_short	iadr_l;		/* Init Block addr bits 15:00 */

	u_short	lnCSR2;		/* RDP if (RAP==2) */
	u_short iadr_h;		/* Init Block addr bits 23:16 */

	u_short	lnCSR3;		/* RDP if (RAP==3) */
	struct {
	    u_short	    : 13;	/* reserved */
	    u_char  bswp    : 1;	/* (RW) byte swap data dma */
	    u_char  acon    : 1;	/* (RW) ale control mode */
	    u_char  bcon    : 1;	/* (RW) byte control */
	    } ln_csr3b;
	} ln_csr;
    u_short	RAP;
    } LN_DEVICE;

#define lncsr_0		ln_csr.lnCSR0

#define lncsr_iadr_l	ln_csr.iadr_l

#define lncsr_iadr_h	ln_csr.iadr_h

#define lncsr_bswp	ln_csr.ln_csr3b.bswp
#define lncsr_acon	ln_csr.ln_csr3b.acon
#define lncsr_bcon	ln_csr.ln_csr3b.bcon

#define lncsr_INTMASK (lncsr_BABL \
		     | lncsr_CERR \
		     | lncsr_MISS \
		     | lncsr_MERR \
		     | lncsr_RINT \
		     | lncsr_TINT \
		     | lncsr_IDON \
		     | lncsr_INEA)
/*
 * Initialization Block.
 * Specifies addresses of receive and transmit descriptor rings.
 */
typedef struct lnIB {
    u_short	lnIBMode;		/* mode register */
    char	lnIBPadr [6]; /* PADR: byte swapped ethernet physical address */
					/* LADRF: logical address filter */
    u_short	lnIBLadrfLow;		/* least significant word */
    u_short	lnIBLadrfMidLow;	/* low middle word */
    u_short	lnIBLadrfMidHigh;  	/* high middle word */
    u_short	lnIBLadrfHigh;		/* most significant word */
					/* RDRA: read ring address */
    u_short	lnIBRdraLow;		/* low word */
    u_short	lnIBRdraHigh;		/* high word */
					/* TDRA: transmit ring address */
    u_short	lnIBTdraLow;		/* low word */
    u_short	lnIBTdraHigh;		/* high word */
    } ln_ib;

/*
 * Receive Message Descriptor Entry.
 * Four words per entry.  Number of entries must be a power of two.
 */
typedef struct lnRMD {
    u_short	lnRMD0;		/* bits 15:00 of receive buffer address */
    union {
        u_short	    lnRMD1;	/* bits 23:16 of receive buffer address */
	struct {
	  	u_char	rmdOwn	: 1;	/* ownership bit */
		u_char	rmdErr	: 1;	/* or of FRAM, OFLO, CRC, BUFF */
		u_char	rmdFram	: 1;	/* framming error */
		u_char	rmdOflo	: 1;	/* silo overflow error */
		u_char	rmdCrc	: 1;	/* crc error */
		u_char	rmdBuff	: 1;	/* buffer ownership error */
		u_char	rmdStp	: 1;	/* start of packet */
		u_char	rmdEnp	: 1;	/* end of packet */
		u_char	rmdHadr	: 8;	/* high order bits of rbuf address */
	    } ln_rmd1b;
        } ln_rmd1;
    u_short	lnRMD2;			/* buffer byte count (negative) */
    u_short	lnRMD3;			/* message byte count */
    } ln_rmd;

#define	rbuf_ladr	lnRMD0
#define rbuf_rmd1	ln_rmd1.lnRMD1
#define rbuf_hadr	ln_rmd1.ln_rmd1b.rmdHadr
#define	rbuf_own	ln_rmd1.ln_rmd1b.rmdOwn
#define	rbuf_err	ln_rmd1.ln_rmd1b.rmdErr
#define	rbuf_fram	ln_rmd1.ln_rmd1b.rmdFram
#define	rbuf_oflo	ln_rmd1.ln_rmd1b.rmdOflo
#define	rbuf_crc	ln_rmd1.ln_rmd1b.rmdCrc
#define	rbuf_buff	ln_rmd1.ln_rmd1b.rmdBuff
#define	rbuf_stp	ln_rmd1.ln_rmd1b.rmdStp
#define	rbuf_enp	ln_rmd1.ln_rmd1b.rmdEnp
#define	rbuf_bcnt	lnRMD2
#define	rbuf_mcnt	lnRMD3

/*
 * Transmit Message Descriptor Entry.
 * Four words per entry.  Number of entries must be a power of two.
 */
typedef struct lnTMD {
    u_short	lnTMD0;		/* bits 15:00 of transmit buffer address */
    union {
        u_short	    lnTMD1;	/* bits 23:16 of transmit buffer address */
	struct {
	  	u_char	tmdOwn	: 1;	/* ownership bit */
		u_char	tmdErr	: 1;	/* or of LCOL, LCAR, UFLO, RTRY */
		u_char		: 1;	/* 0 */
		u_char	tmdMore	: 1;	/* more than one retry required */
		u_char	tmdOne	: 1;	/* exactly one retry required */
		u_char	tmdDef	: 1;	/* transmission was deferred */
		u_char	tmdStp	: 1;	/* start of packet */
		u_char	tmdEnp	: 1;	/* end of packet */
		u_char	tmdHadr	: 8;	/* high order bits of tbuf address */
	    } ln_tmd1b;
	} ln_tmd1;
    u_short	lnTMD2;			/* message byte count */
    union {
	u_short	    lnTMD3;		/* errors */
	struct {
		u_char	tmdBuff	: 1;	/* buffer error */
		u_char	tmdUflo	: 1;	/* underflow error */
		u_char		: 1;	/* 0 */
		u_char	tmdLcol	: 1;	/* late collision */
		u_char	tmdLcar	: 1;	/* loss of carrier */
		u_char	tmdRtry	: 1;	/* retry error */
		u_short	tmdTdr	: 10;	/* tdr value */
	    } ln_tmd3b;
        } ln_tmd3
    } ln_tmd;

#define	tbuf_ladr	lnTMD0
#define tbuf_tmd1	ln_tmd1.lnTMD1
#define tbuf_hadr	ln_tmd1.ln_tmd1b.tmdHadr
#define	tbuf_own	ln_tmd1.ln_tmd1b.tmdOwn
#define	tbuf_err	ln_tmd1.ln_tmd1b.tmdErr
#define	tbuf_more	ln_tmd1.ln_tmd1b.tmdMore
#define	tbuf_one	ln_tmd1.ln_tmd1b.tmdOne
#define	tbuf_def	ln_tmd1.ln_tmd1b.tmdDef
#define	tbuf_stp	ln_tmd1.ln_tmd1b.tmdStp
#define	tbuf_enp	ln_tmd1.ln_tmd1b.tmdEnp
#define	tbuf_bcnt	lnTMD2
#define tbuf_tmd3	ln_tmd3.lnTMD3
#define tbuf_buff	ln_tmd3.ln_tmd3b.tmdBuff
#define tbuf_uflo	ln_tmd3.ln_tmd3b.tmdUflo
#define tbuf_lcol	ln_tmd3.ln_tmd3b.tmdLcol
#define tbuf_lcar	ln_tmd3.ln_tmd3b.tmdLcar
#define tbuf_rtry	ln_tmd3.ln_tmd3b.tmdRtry
#define tbuf_tdr	ln_tmd3.ln_tmd3b.tmdTdr


#define	LN_BUFSIZE	(ETHERMTU + sizeof (struct ether_header) + 6)

/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure,
 * ls_if, which the routing code uses to locate the interface.
 * This structure contains the output queue for the interface,
 * its address, etc.
 */

struct ls_softc {
    struct arpcom  ls_ac;		/* ethernet common part */
    ln_ib	  *ib;			/* Initialization Block */
    struct {
        int	   r_po2;		/* RMD ring size as a power of 2! */
	int	   r_size;		/* RMD ring size (power of 2!) */
	int	   r_index;		/* index into RMD ring */
	ln_rmd	  *r_ring;		/* RMD ring */
	char	  *r_bufs;		/* receive buffers base */
        } rmd_ring;
    struct {
        int	   t_po2;		/* TMD ring size as a power of 2! */
	int	   t_size;		/* TMD ring size (power of 2!) */
	int	   t_index;		/* index into TMD ring */
	int	   d_index;		/* index into TMD ring */
	ln_tmd	  *t_ring;		/* TMD ring */
	char	  *t_bufs;		/* transmit buffers base */
        } tmd_ring;
    BOOL	   promiscuous;		/* TRUE = cntrlr receiving all packets,
				 	 * FALSE = cntrlr address filter on */
    int		   ivec;		/* interrupt vector */
    int		   ilevel;		/* interrupt level */
    LN_DEVICE	  *devAdrs;		/* device structure address */
    };

#define	ls_if		ls_ac.ac_if		/* network-visible interface */
#define	ls_enaddr 	ls_ac.ac_enaddr		/* hardware ethernet address */

#define	ls_rpo2		rmd_ring.r_po2
#define	ls_rsize	rmd_ring.r_size
#define	ls_rindex	rmd_ring.r_index
#define	ls_rring	rmd_ring.r_ring

#define	ls_tpo2		tmd_ring.t_po2
#define	ls_tsize	tmd_ring.t_size
#define	ls_tindex	tmd_ring.t_index
#define	ls_dindex	tmd_ring.d_index
#define	ls_tring	tmd_ring.t_ring


#endif	INCif_lnh
