/* sysALib.s - ubar system dependent assembly language routines */

/*
modification history
--------------------
03j,19nov87,dnw  changed TRAP_ names.
03i,16nov87,jcf  changed startType parameter to BOOT_WARM_AUTOBOOT
03h,27mar87,dnw  removed is68020 (now in vxALib.s).
		 removed sysMemProbe (now in vxALib.s).
		 removed sysToMonitor (now in sysLib.c).
		 deleted sysXput().
		 deleted sysIo...(), sysSupCall(), and sysTrap() (obsolete).
		 added sysKernelTrap() & sysVwTrap().
		 added sysInit().
03g,25mar87,jlf  documentation.
03f,17feb87,dnw  added is68020 for ISI 3.07 host.
		 changed negative displacements to be of form (-4) instead
		   of (0xfffc) which ISI 3.07 assembler rejects.
		 removed intEnt() & intExit() from sysTrap for new vrtx.
03e,21dec86,dnw  changed to not get include files from default directories.
03d,31oct86,dnw  removed defines for short names.
		 changed "mov[bwl]" to "move[bwl]" for compatiblity w/Sun as.
03c,07apr86,rdc  sysMemProbe now saves and restores d2.
03b,26mar86,jlf  changed sysToMon to use trap 3.
03a,18jul85,jlf  translated from asm to as.
02a,08apr85,rdc  installed modifications for vrtx version 3.  Specifically,
		   added call to UI_ENTER in sysTrap.
01a,27jun84,jlf  written, by modifying ubarAsmLib.s, v01b.  Added
		   trap vectoring stuff, and io read and write routines.
		   Removed the stuff that is now in intLib.
*/

/*
DESCRIPTION

This library contains asm language system-specific routines for the Microbar
DBC68k2 board.

INTERNAL
Many routines in this module "link" and "unlk" the "c" frame pointer
a6@ although they don't use it in any way!  This only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "sysLib.h"
#include "config.h"


	/* internals */

	.globl	_sysInit	/* start of system code */
	.globl  _sysKernelTrap
	.globl  _sysVwTrap
	.globl  _sysVwTrapRtn

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

/***********************************************************************
*
* sysInit - start after boot
*
* This is is the system start-up entry point for UniWorks in ram.
* It is the first code executed after booting.
* It disables the interrupts, sets up the stack,
* and jumps to the C routine usrInit in usrConfig.c.
*
* The initial stack is set to grow down from sysInit.
* Note that this initial stack is used only by usrInit,
* then is never used again.
* Memory for the stack needs to be accounted for when determining the load
* address of the system.
*
* THIS IS NOT A CALLABLE ROUTINE.

* sysInit ()

*/

_sysInit:
	movew	#0x2700,sr		/* disable interrupts */
	movel	#_sysInit,a7		/* set stack to grow down from code */
	movel	#BOOT_WARM_AUTOBOOT,a7@- /* push start type arg = WARM_BOOT */
	jsr	_usrInit		/* never returns - starts up kernel */

/***********************************************************************
*
* sysKernelTrap - trap to kernel function
*

* sysKernelTrap ()

*/
_sysKernelTrap:
	trap	#TRAP_KERNEL
	rts

/***********************************************************************
*
* sysVwTrap - trap to UniWorks function
*

* sysVwTrap ()

*/
_sysVwTrap:
	trap	#TRAP_UNIWORKS
	rts

/*
 * This routine calls the routine whose address is in a0.  Since the system
 * is now in supervisor state (since we got here from a trap) this can be
 * used to call a routine in supervisor state.
 * THIS IS NOT A C CALLABLE ROUTINE!!
 */

_sysVwTrapRtn:
	jsr	a0@		/* vector to proper routine. */
	rte			/* return from trap */
