/* sysALib.s - SUN 3/e system dependent assembly language routines */

/*
modification history
--------------------
01h,09sep88,gae  documentation.
01g,17dec87,jcf  fixed bug in sysCsW{B,W,L} so D2 won't be clobbered.
01f,24nov87,jcf  documentation.
01e,22nov87,dnw  changed TRAP_ names.
01d,19nov87,jcf  documentation.
01c,16nov87,jcf  added parameter startType to sysToMonitor
01b,13nov87,ecs  documentation.
01a,20may87,jcf  written, by modifying 01n of sysALib.s for is20
		 moved is68020 (now in vxALib.s).
		 moved sysMemProbe (now in vxALib.s)
		 moved sysToMonitor (now in sysLib.c).
		 deleted sysIo...(), sysSupCall(), and sysTrap() (obsolete).
		 added sysKernelTrap() & sysVwTrap().
		 added sysInit().
*/

/*
DESCRIPTION
This module contains system-dependent routines which must be written
in assembly language.  They perform functions such as locking and
unlocking interrupts, trapping to the ROM monitor, etc.  This module
is for the SUN 3/e.

INTERNAL
Many routines in this module "link" and "unlk" the "c" frame pointer
a6@ although they don't use it in any way!  This only for the benefit of
the stacktrace facility to allow it to properly trace tasks executing within
these routines.
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_sysInit
	.globl	_sysKernelTrap
	.globl	_sysVwTrap
	.globl	_sysVwTrapRtn
	.globl	_sysCacheEnable
	.globl	_sysClkAck
	.globl	_sysToMonitor
	.globl  _sysCsWB
	.globl  _sysCsRB
	.globl  _sysCsRW
	.globl  _sysCsWW
	.globl  _sysCsRL
	.globl  _sysCsWL

	/* externals */

	.globl  _usrInit

	.text
	.even
 
/*******************************************************************************
*
* sysInit - start after boot
*
* This is the system start-up entry point for UniWorks in RAM.
* It is the first code executed after booting.
* It disables the interrupts, sets up the stack,
* and jumps to the C routine usrInit (2) in usrConfig (1).
*
* The initial stack is set to grow down from sysInit.
* Note that this initial stack is used only by usrInit,
* then is never used again.
* Memory for the stack needs to be accounted for when determining the load
* address of the system.  THIS IS NOT A CALLABLE ROUTINE.

* sysInit ()		/* THIS IS NOT A CALLABLE ROUTINE *

*/

_sysInit:
	movew	#0x3700,sr		/* disable interrupts, turn on M bit */
	movel	#_sysInit,a7		/* set stack to grow down from code */
	movel	#BOOT_WARM_AUTOBOOT,a7@- /* push start type arg = WARM_BOOT */

	clrb	0x0fe0a000		/* turn off clock */
	moveb	#0x0c,0x0fe06011
	clrb	0x0fe0a000
	moveb	#0x1c,0x0fe06011
	orb	#0x01,0x0fe0a000

	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* sysKernelTrap - trap to kernel function
*
* This routine traps to the kernel.
* It can only be called from assembly language.
* The trap number for the kernel is defined in config.h.
*
* NOMANUAL

* sysKernelTrap ()

*/
_sysKernelTrap:
	trap	#TRAP_KERNEL
	rts

/*******************************************************************************
*
* sysVwTrap - trap to vxWorks function
*
* This routine traps to UniWorks. It can only be called from assembly language.
* The trap number for UniWorks is defined in config.h.
*
* NOMANUAL

* sysVwTrap ()

*/
_sysVwTrap:
	trap	#TRAP_UNIWORKS
	rts

/*
 * This routine calls the routine whose address is in a0.  Since the system
 * is now in supervisor state (since we got here from a trap) this can be
 * used to call a routine in supervisor state.
 * THIS IS NOT A C CALLABLE ROUTINE!!
 */

_sysVwTrapRtn:
	jsr	a0@		/* vector to proper routine. */
	rte			/* return from trap */

/*******************************************************************************
*
* sysToMonitor - transfer to rom monitor
*
* This routine transfers control to the rom monitor.
*
* RETURNS: OK (if we ever continue from the rom monitor).
*

* STATUS sysToMonitor (startType)
*     int startType;	/* parameter is passed to ROM to tell it how to boot *
*                       /* possible types are defined in sysLib.h            *

*/

_sysToMonitor:
	link	a6,#0
	andb	#0xfe,0x0fe0a000	/* turn on clock lvl 7 */
	andb	#0x5f,0x0fe0a000
	moveb	#0x0c,0x0fe06011
	orb	#0xa0,0x0fe0a000
	moveb	#0x1c,0x0fe06011
	orb	#0x01,0x0fe0a000
	movel	a6@(0x8),a7@-		/* push startType */
	trap	#TRAP_SUN		/* go to monitor-land */
	addl	#4,a7
	andb	#0xfe,0x0fe0a000	/* turn off lvl 7. */
	andb	#0x5f,0x0fe0a000
	moveb	#0x0c,0x0fe06011
	orb	#0x20,0x0fe0a000
	moveb	#0x1c,0x0fe06011
	orb	#0x01,0x0fe0a000
	clrl	d0
	unlk	a6
	rts				/* come back feeling refreshed */

/*******************************************************************************
*
* sysClkAck - acknowledge the clock interrupt
*
* This routine makes a dummy read from the the clocks status register to
* to enable interrupts.
* It is is located here because the C compiler will optimize out two
* consecutive reads from the same location!
*
* NOMANUAL

* VOID sysClkAck ()

*/
_sysClkAck:
	moveb	0x0fe06010,d0
	andb	#0xdf,0x0fe0a000
	orb	#0x20,0x0fe0a000
	moveb	0x0fe06010,d0
	rts

/*******************************************************************************
*
* sysCsRB - read byte from control space
*
* This reads the specified Control space byte.
*
* NOMANUAL

* int sysCsRB (address)
*	char *address;	/* address to read *

*/
_sysCsRB:
	link	a6,#0
	movel	a6@(0x8),a1	/* get address into a1 */
	movec	dfc,d1		/* Save old Destination Function Code */
	moveb	#3,d0		/* Set up FC3 (control space) */
	movec	d0,dfc		/* Set up FC3 (control space) */
	movesb	a1@,d0		/* read byte into return reg. */
	movec	d1,dfc		/* Restore Destination Function Code */
	extw	d0
	extl	d0
	unlk	a6
	rts

/*******************************************************************************
*
* sysCsWB - write byte to control space
*
* This writes a specified control byte.
*
* NOMANUAL

* VOID sysCsWB (address, byte)
*	char *address;	/* address to write to *
*	char byte;	/* byte to write *

*/

_sysCsWB:
	link	a6,#0
	movec	dfc,d0		/* Save old Destination Function Code */
	moveb	#3,d1		/* Set up FC3 (control space) */
	movec	d1,dfc		/* move to destination function code */
	movel	a6@(0x8),a1	/* get address */
	movel	a6@(0x0c),d1	/* get byte */
	movesb	d1,a1@		/* write byte. */
	movec	d0,dfc		/* Restore Destination Function Code */
	unlk	a6
	rts

/*******************************************************************************
*
* sysCsRW - read word from control space
*
* This reads the specified control space word.
*
* NOMANUAL

* int sysCsRW (address)
*	char *address;	/* address to read *

*/
_sysCsRW:
	link	a6,#0
	movel	a6@(0x8),a1	/* get address into a1 */
	movec	dfc,d1		/* Save old Destination Function Code */
	moveb	#3,d0		/* Set up FC3 (control space) */
	movec	d0,dfc		/* Set up FC3 (control space) */
	movesw	a1@,d0		/* read word into return reg. */
	movec	d1,dfc		/* Restore Destination Function Code */
	extl	d0
	unlk	a6
	rts

/*******************************************************************************
*
* sysCsWW - write word to control space
*
* This writes a specified control word.
*
* NOMANUAL

* VOID sysCsWW (address, word)
*	char *address;	/* address to write *
*	short word;	/* word to write there *

*/

_sysCsWW:
	link	a6,#0
	movec	dfc,d0		/* Save old Destination Function Code */
	moveb	#3,d1		/* Set up FC3 (control space) */
	movec	d1,dfc		/* move to destination fuction code */
	movel	a6@(0x8),a1	/* get address */
	movel	a6@(0x0c),d1	/* get word */
	movesw	d1,a1@		/* write word */
	movec	d0,dfc		/* Restore Destination Function Code */
	unlk	a6
	rts

/*******************************************************************************
*
* sysCsRL - read long from control space
*
* This reads the specified Control space long.
*
* NOMANUAL

* int sysCsRL (address)
*	char *address;	/* address to read *

*/
_sysCsRL:
	link	a6,#0
	movel	a6@(0x8),a1	/* get address into a1 */
	movec	dfc,d1		/* Save old Destination Function Code */
	moveb	#3,d0		/* Set up FC3 (control space) */
	movec	d0,dfc		/* Set up FC3 (control space) */
	movesl	a1@,d0		/* read long into return reg. */
	movec	d1,dfc		/* Restore Destination Function Code */
	unlk	a6
	rts

/*******************************************************************************
*
* sysCsWL - write long to control space
*
* This writes a specified control long.
*
* NOMANUAL

* VOID sysCsWL (address, long)
*	char *address;	/* address to write. *
*	unsigned long;	/* long to write there *

*/

_sysCsWL:
	link	a6,#0
	movec	dfc,d0		/* Save old Destination Function Code */
	moveb	#3,d1		/* Set up FC3 (control space) */
	movec	d1,dfc		/* move to destination function code */
	movel	a6@(0x8),a1	/* get address */
	movel	a6@(0x0c),d1	/* get long */
	movesl	d1,a1@		/* write long */
	movec	d0,dfc		/* Restore Destination Function Code */
	unlk	a6
	rts

/*******************************************************************************
*
* sysCacheEnable - enable cache memory
*
* Enable or disable the 68020 on-chip cache.
*
* SEE ALSO: "MC68020 32-Bit Microprocessor User's Manual"

* VOID sysCacheEnable (enable)
*     BOOL enable;		/* enable if TRUE, otherwise disable *

*/
_sysCacheEnable:

	link	a6,#0
	movel	a6@(0x08),d1		/* put enable in d1 */

	cmpl	#1,d1			/* does enable == TRUE? */
	bne	sce0			/* if not, disable cache */
	movel	#0x09,d0		/* else, clear and enable cache */
	bra	sce1

sce0:	movel	#0,d0			/* disable cache */

	/* Enable or disable the cache by writing to the cache control
	   register.  Since the assemblers differ on the syntax for this one
	   (if they even have it), it's done with two .word's.  Yucko. */

sce1:
	.word	0x4e7b,0x0002	/* movec d0,cacr */

	unlk	a6
	rts
