/* sun3e.h - SUN 3/e CPU board header file */

/*
modification history
--------------------
01d,05aug88,gae  removed z8530 definitions and used appropriate header.
01c,29apr88,gae  added BUS and CPU constants.
01b,22nov87,dnw  removed int vector definitions to config.h.
01a,29may87,jcf	 written.
*/

/*
This file contains I/O address and related constants
for the SUN 3/e CPU board.
*/

#ifndef	INCsun3eh
#define	INCsun3eh

#include "z8530.h"

#define TARGET_SUN3E

#define BUS		VME_BUS
#define CPU		MC68020


/******************************************************************************
*
* GENERAL INFO
*/

/* addresses */

#define SUN_CLK_HANDLER		0x0fef03a2
#define SUN_TO_MONITOR		0x0fef0258

/* memory management stuff */

#define SUN_PAGE_BASE		0x10000000	/* this is in control space */
#define SUN_SEG_BASE		0x20000000	/* this is in control space */
#define MMU_PAGE_ALL_OK		0xc0000000	/* Total priv page entry */

/* space types */

#define SUN_MEM		0x0			/* Main Memory/ video memory */
#define SUN_IO		0x1			/* SUN I/O space */
#define SUN_VME16	0x2			/* VME 16 bit data space */
#define SUN_VME32	0x3			/* VME 32 bit data space */

/******************************************************************************
*
* DEVICE SPACE ADDRESSING 
*/

#define N_USART_CHANNELS	3		/* Number of serial channels */
						/* One reserved for aux clk */

/* Port addresses for Z8530 SCC (Serial Communications Controller).
 * The addresses are virtual as per the SUN 3/e setup.
 */


#define	SUN_SCCA	((char *) 0x0fe02004)	/* Control channel A */
#define	SUN_SCDA	((char *) 0x0fe02006)	/* Data channel A */
#define	SUN_SCCB	((char *) 0x0fe02000)	/* Control channel B */
#define	SUN_SCDB	((char *) 0x0fe02002)	/* Data channel B */
#define	SUN_KYBC	((char *) 0x0fe00004)	/* Control keyboard */
#define	SUN_KYBD	((char *) 0x0fe00006)	/* Data keyboard */
#define	SUN_MSC		((char *) 0x0fe00000)	/* Control mouse */
#define	SUN_MSD		((char *) 0x0fe00002)	/* Data mouse */

/* port address for interrupt related registers */

#define SUN_IR		((char *) 0x0fe0a000)	/* Interrupt Register */

/* port address for bus error control and trace registers */

#define SUN_MCR		((char *) 0x0fe08000)	/* Memory Control Register */
#define SUN_MSR1	((char *) 0x0fe08004)	/* Memory Status byte 1 */
#define SUN_MSR2	((char *) 0x0fe08005)	/* Memory Status byte 2 */
#define SUN_MSR3	((char *) 0x0fe08006)	/* Memory Status byte 3 */
#define SUN_MSR4	((char *) 0x0fe08007)	/* Memory Status byte 4 */

/* Intersil 7170 Time-of-day Clock */

/* port address for real time clock registers */

#define	SUN_RTC_BASE	0x0fe06000

#define SUN_RTC_HUND	((char *) (SUN_RTC_BASE+0x00))
#define SUN_RTC_HOUR	((char *) (SUN_RTC_BASE+0x01))
#define SUN_RTC_MIN	((char *) (SUN_RTC_BASE+0x02))
#define SUN_RTC_SEC	((char *) (SUN_RTC_BASE+0x03))
#define SUN_RTC_MONTH	((char *) (SUN_RTC_BASE+0x04))
#define SUN_RTC_DATE	((char *) (SUN_RTC_BASE+0x05))
#define SUN_RTC_YEAR	((char *) (SUN_RTC_BASE+0x06))
#define SUN_RTC_DAY	((char *) (SUN_RTC_BASE+0x07))
#define SUN_RTC_HUND_A	((char *) (SUN_RTC_BASE+0x08))
#define SUN_RTC_HOUR_A	((char *) (SUN_RTC_BASE+0x09))
#define SUN_RTC_MIN_A	((char *) (SUN_RTC_BASE+0x0a))
#define SUN_RTC_SEC_A	((char *) (SUN_RTC_BASE+0x0b))
#define SUN_RTC_MONTH_A	((char *) (SUN_RTC_BASE+0x0c))
#define SUN_RTC_DATE_A	((char *) (SUN_RTC_BASE+0x0d))
#define SUN_RTC_YEAR_A	((char *) (SUN_RTC_BASE+0x0e))
#define SUN_RTC_DAY_A	((char *) (SUN_RTC_BASE+0x0f))
#define SUN_RTC_STAT	((char *) (SUN_RTC_BASE+0x10))	/* interupt status */
#define SUN_RTC_MASK	((char *) (SUN_RTC_BASE+0x10))	/* interupt mask */
#define SUN_RTC_CMD	((char *) (SUN_RTC_BASE+0x11))	/* command register */

/* Commands */
/* the only thing we ever change in the interupts.  Also, the command register
   is write only.  Instead of keeping a local copy we use the following 
   defaults :  always run/ 24 hr/ normal / 32.768 KHz */

#define RTC_CMD_ENA_INT	(0x1c)
#define RTC_CMD_DIS_INT	(0x0c)

/* Masks for both the stat and the mask registers */
/* Note that the global int bit is only on the stat register */

#define RTC_MASK_ALARM	0x1			/* alarm int */
#define RTC_MASK_HUND	0x2			/* 1/100 (sec)*/
#define RTC_MASK_TENTH	0x4			/* 1/10 (sec)*/
#define RTC_MASK_SEC	0x8			/* 1 (sec)*/
#define RTC_MASK_MIN	0x10			/* 60 (sec)*/
#define RTC_MASK_HOUR	0x20			/* 60 * 60 (sec)*/
#define RTC_MASK_DAY	0x40			/* 24 * 60 * 60 (sec)*/
#define RTC_MASK_INT	0x80			/* Global interupt check */
/* port address of watch dog timer */


/* INTERUPT */
/* Bit masks for interrupt register */

#define IR_ALL			0x1		/* Enable all interupts */
#define IR_SFT1			0x2		/* Enable lvl 1 interupts */
#define IR_SFT2			0x4		/* Enable lvl 2 interupts */
#define IR_SFT3			0x8		/* Enable lvl 3 interupts */
#define IR_VIDEO		0x10		/* Enable video interupts */
#define IR_CLOCK5		0x20		/* Enable clock lvl 5 int. */
#define IR_SCC			0x40		/* Enable SCC interupts */
#define IR_CLOCK7		0x80		/* Enable clock lvl 7 int. */

/* MEMORY */
/* Bit masks for memory control register */

#define MCR_PAR0		0x1		/* Parity error in byte 0 */
#define MCR_PAR1		0x2		/* Parity error in byte 1 */
#define MCR_PAR2		0x4		/* Parity error in byte 2 */
#define MCR_PAR3		0x8		/* Parity error in byte 3 */
#define MCR_PAR_CHECK		0x10		/* 1 = enable parity check */
#define MCR_PAR_TEST		0x20		/* 1 = test by invert. parity */
#define MCR_PAR_INT		0x40		/* 1 = parity interupt enable */
#define MCR_INT			0x80		/* 1 = parity interupt lvl. 7 */



/******************************************************************************
*
* CONTROL SPACE ADDRESSING
*/

#define	SUN_IDPROM		0x0		/* System Configuration (B) */
#define SUN_PAGE_MAP		0x1		/* The page lookup table */
#define SUN_SEGMENT_MAP		0x2		/* The segment lookup table */
#define SUN_CONTEXT		0x3		/* Context register */
#define SUN_ENABLE		0x4		/* System enable register */
#define SUN_BUS_ERROR		0x6		/* What caused BERR */
#define SUN_LED			0x7		/* 8 Pretty lights (0 = ON) */
#define SUN_UART_BACKDOOR	0xf		/* Avoids MMU translation */

/* Control space masks */

#define SUN_ENABLE_DIAG		0x1		/* Enable diagnostic led's */
#define SUN_ENABLE_FPP		0x40		/* Enable floating point unit */
#define SUN_ENABLE_BOOT		0x80		/* Boot state(0=boot;1=normal)*/

#define SUN_BUS_ERROR_WTCHDOG	0x1		/* Watchdog reset occured */
#define SUN_BUS_ERROR_VMEBERR	0x10		/* VMEbus BERR detected */
#define SUN_BUS_ERROR_TIMEOUT	0x20		/* Timeout error */
#define SUN_BUS_ERROR_PROTERR	0x40		/* Protection error */
#define SUN_BUS_ERROR_INVALID	0x80		/* Invalid page access */

#endif	INCsun3eh
