/* romInit.s - init module for code in rom for Mizar mz8115 */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01b,25jul88,gae  updated to 4.0.
01a,11may88,miz	 written by modifying v01a of mz7120/romInit.s.
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even


/********************************************************************************
* romInit - initial entry points
*
* Cold start starts at romInit which will go to romInit1.
* Warm start starts at romInit + 28 which will go to romInit2.

* NO MANUAL

*/

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */


/*******************************************************************************
*
* romInit1 - cold start initialization
*
* This code is the cold start initialization.  It clears memory,
* copies itself from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg BOOT_COLD.
*
* This routine is position independent.

* romInit1 ()

*/

romInit1:
	/* clear all of memory;
	 * outer loop counter in d2 = 0x1 =
	 *
	 *   512 Kbytes to clear
	 *   ------------------  - 1
	 *   64K * 4               ^
	 *    ^    ^               |
	 *    |    |               for dbra at end of outer loop
	 *    |    bytes per inner loop
	 *    inner loops per outer loop
	 */

	movel	#0x1,d2			/* outer loop counter */
	movel	#LOCAL_MEM_LOCAL_ADRS,a0 /* get start of local memory */
	clrl	d0			/* value to fill */


fb1:	movel	#0xffff,d1		/* set to fill 64K */
fb2:	movel	d0,a0@+			/* move 4 bytes */
	dbra	d1,fb2			/* inner loop test */
	dbra	d2,fb1			/* outer loop test */


	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop1:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop1


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/*******************************************************************************
*
* romInit2 - warm start initialization
*
* This code is the warm start initialization.
* It copies itself from rom to ram, sets the stack to grow
* down from the start of the data segment in ram, and goes to usrInit with
* the arg that was passed to it.
*
* This routine is position independent.

* romInit2 ()

*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop2:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop2


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	a6@(0x08),a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */
