/* mz8115.h - Mizar mz8115 CPU board header file */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01c,25jul88,gae  updated to 4.0.
01b,22jun88,mcl  cosmetics.
01a,10feb88,miz  written by adapting mz7120.h and mz7120sp4.h.
*/

#ifndef	INCmz8115h
#define	INCmz8115h

/*
This file contains I/O address and related constants for the
Mizar mz8115 CPU board.
*/

#include "m68681.h"

#define TARGET_MZ_8115

#define BUS		VME_BUS
#define CPU		MC68010

/* memory constants */

/* memory as it appears locally */

#define MZ_RAM_BASE_ADRS	0x00000000	  /* 1st on-card RAM adrs */
#define MZ_RAM_SIZE		0x00080000	  /* last on-card RAM adrs */

/* local user interrupts */

#define	MZ8115_INT_VEC_NUM	64

#define IV_OFFSET_68681		00

/* equates for m68681 serial channel - for more explanation see m68681.h */

#define	MZ_68681_BASE	((char *) 0x00fe8000)

#define	DUART_MRA	(MZ_68681_BASE + 0x01)	/* mode reg. A */
#define	DUART_CSRA	(MZ_68681_BASE + 0x03)	/* clock select reg. A */
#define	DUART_SRA	DUART_CSRA		/* status reg. A */
#define	DUART_CRA	(MZ_68681_BASE + 0x05)	/* command reg. A */
#define	DUART_THRA	(MZ_68681_BASE + 0x07)	/* transmit buffer A */
#define	DUART_RHRA	DUART_THRA		/* receive buffer A */
#define	DUART_ACR	(MZ_68681_BASE + 0x09)	/* auxiliary control reg. */
#define	DUART_IPCR	DUART_ACR		/* input port change reg. */
#define	DUART_IMR	(MZ_68681_BASE + 0x0b)	/* int. mask reg. */
#define	DUART_ISR	DUART_IMR		/* int. status reg. */
#define	DUART_CTUR	(MZ_68681_BASE + 0x0d)	/* counter timer upper reg. */
#define	DUART_CTLR	(MZ_68681_BASE + 0x0f)	/* counter timer lower reg. */
#define	DUART_MRB	(MZ_68681_BASE + 0x11)	/* mode reg. B */
#define	DUART_CSRB	(MZ_68681_BASE + 0x13)	/* clock select reg. B */
#define	DUART_SRB	DUART_CSRB		/* status reg. B */
#define	DUART_CRB	(MZ_68681_BASE + 0x15)	/* command reg. B */
#define	DUART_THRB	(MZ_68681_BASE + 0x17)	/* transmit buffer B */
#define	DUART_RHRB	DUART_THRB		/* receive buffer B */
#define	DUART_IVR	(MZ_68681_BASE + 0x19)	/* int. vector reg. */
#define	DUART_OPCR	(MZ_68681_BASE + 0x1b)	/* output port config. reg. */
#define	DUART_IP	DUART_OPCR		/* input port */
#define	DUART_SOPBC	(MZ_68681_BASE + 0x1d)	/* set output port bits */
#define	DUART_CTRON	DUART_SOPBC		/* counter on */
#define	DUART_ROPBC	(MZ_68681_BASE + 0x1f)	/* reset output port bits */
#define	DUART_CTROFF	DUART_ROPBC		/* counter off */

#define	DISABLE_VME_ROR	0x04			/* write to DUART_SOPBC */
#define	ENABLE_VME_ROR	0x04			/* write to DUART_ROPBC */

#define	DISABLE_BR_ADRS	0x00fe801d
#define	ENABLE_BR_ADRS	0x00fe801f

/* end of equates for m68681 */

#endif	INCmz8115h
