/* mz8115/config.h - Mizar mz8115 configuration header */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
*/

/*
This module contains the parameters that define the configuration for
VxWorks on the Mizar 8115 cpu board.   The CPU card configuration supported
is 68010 CPU, using the on-card RS232 ports, booting over the network
as per the DEFAULT_BOOT_LINE below.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "mz8115.h"

#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */

#define	WHICH	0	/* 0=WRS, 1=MIZAR, 2=MIZARBP */

#if	WHICH == 0
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/mz8115/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"
#endif	WHICH_WRS

#if	WHICH == 1
#define DEFAULT_BOOT_LINE \
"enp(0,0)mizar:/usr/vw/config/mz8115/vxWorks e=192.33.35.215 h=192.33.35.10 b=215.1 u=vw"
#endif	WHICH_MIZAR

#if	WHICH == 2
#define DEFAULT_BOOT_LINE \
"bp(0,1)mizar:/usr/vw/config/mz8115/vxWorks b=215.2 h=192.33.35.10 g=215.1 u=vw"
#endif	WHICH_MIZARBP

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */
/******************************************************************************/

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
/*#define INCLUDE_SPY		/* can't use - no auxiliary clock */
#define INCLUDE_1.5COMPAT	/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */

/* if only .5 Meg is available the following modules should be excluded. */

#define	HALF_MEG	TRUE	/* if board has only .5 M */

#ifdef	HALF_MEG
#define	INCLUDE_DBX		/* DBX debugger */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_NFS		/* nfs package */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#endif	HALFMEG

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100



/* Device controller I/O addresses:
 * MZ8115 board requires the top bits 0xff000000 to be set.
 * Also, the Excelan cannot appear at 0x00ff0000.
 */
 
#define IO_ADRS_EX      ((char *) 0xff7f0000)   /* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP     ((char *) 0xffde0000)   /* 24A,32D CMC Ethernet */
#define IO_ADRS_IE      ((char *) 0xff300000)   /* 24A,32D Sun Ethernet */
#define IO_ADRS_NW      ((char *) 0xfff80000)   /* 24A,32D ISI Ethernet */
#define IO_ADRS_PN      ((char *) 0xff100000)   /* 24A,32D Proteon ProNet */


/* interrupt and system trap vectors */

#define INT_VEC_ABORT		(IV_AUTOVEC_7)
#define INT_VEC_S1_IRQ1		(IV_AUTOVEC_6)
#define INT_VEC_BCLR		(IV_AUTOVEC_5)
#define INT_VEC_S1_IRQ2		(IV_AUTOVEC_4)
#define	INT_VEC_SERIAL		(MZ8115_INT_VEC_NUM + IV_OFFSET_68681)


/* backplane network parameters */

#define BP_ANCHOR_ADRS	((char *) (0xff800000))	/* off-board anchor adrs */

#define BP_INT_TYPE	BP_INT_NONE		/* mailbox interrupt, poll */
#define BP_INT_ARG1	0			/* none */
#define BP_INT_ARG2	0			/* none */
#define BP_INT_ARG3	0			/* none */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * The mz8115 local memory always appears at 0x00000000 locally.
 * The mz8115 local memory VMEbus address is controlled by PAL
 * 271000 at U10; in the default configuration it is 0x00e80000.
 * Multiple 8115s on a backplane will need different PALs to
 * avoid VMEbus conflicts; see the target(5) man page for
 * further information.
 */

#define LOCAL_MEM_LOCAL_ADRS	MZ_RAM_BASE_ADRS
#define LOCAL_MEM_SIZE		MZ_RAM_SIZE
#define LOCAL_MEM_BUS_ADRS	0x00e80000

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x00f80000

#endif	INCconfigh
