/* mz7122.h - Mizar mz7122 and mz7124 CPU board header file */

/* Copyright 1988, Mizar Digital Systems, Inc. */

/*
modification history
--------------------
01e,10aug88,gae  removed ^L unloved by some assemblers.
01d,26jul88,gae  updated to 4.0.  Moved initial bcl stuff here from config.h.
01c,16jun88,mcl  includes m68562 addresses, modifies other addresses.
01b,01jun88,mcl  modified for mz7124; documentation added.
01a,25jan88,sah	 written.
*/

/*
This file contains I/O address and related constants for the
Mizar mz7122 and mz7124 CPU boards.
*/

#ifndef	INCmz7122h
#define	INCmz7122h

#include "m68562.h"

#define TARGET_MZ_7122			/* _7122 used for both 7122 and 7124 */

#define BUS		VME_BUS
#define CPU		MC68020


/* memory constants: onboard dual port RAM. */

#define MZ_RAM_BASE_ADRS	0x00000000 /* 1st on-card RAM adrs */
#define MZ7122_RAM_SIZE		0x00100000 /* on board ram size: 1 Mbyte */
#define MZ7124_RAM_SIZE		0x00400000 /* on board ram size: 4 Mbytes */

/* memory constants: onboard EPROM. */

#define MZ_ROM_BASE_ADRS	0xfe800000	/* 1st on-card ROM adrs */

/* VME board control latch one.  A write only 32 bit register. */
/*	All undefined bits must be zero. */
/*	Only one of MZ_BRxEN may be set at a time. */

#define MZ_CONTROL_LATCH_ONE_AD	0xfe600000
#define MZ_CONTROL_LATCH_ONE	((unsigned long *) MZ_CONTROL_LATCH_ONE_AD)

#define MZ_IRQ1EN	0x00000001	/* 0: enable VMEbus IRQ level 1 */
#define MZ_IRQ2EN	0x00000002	/* 0: enable VMEbus IRQ level 2 */
#define MZ_IRQ3EN	0x00000004	/* 0: enable VMEbus IRQ level 3 */
#define MZ_IRQ4EN	0x00000008	/* 0: enable VMEbus IRQ level 4 */
#define MZ_IRQ5EN	0x00000010	/* 0: enable VMEbus IRQ level 5 */
#define MZ_IRQ6EN	0x00000020	/* 0: enable VMEbus IRQ level 6 */
#define MZ_IRQ7EN	0x00000040	/* 0: enable VMEbus IRQ level 7 */
#define MZ_IRQALLEN	0x0000007f	/* 0: enable all VMEbus IRQ levels */
#define MZ_MBOXEN	0x00000080	/* enable mailbox interrupt */
#define MZ_BCLREN	0x00000100	/* enable BCLR interrupt */
#define MZ_SYSFEN	0x00000200	/* enable SYSFAIL interrupt */
#define MZ_PRIARB	0x00000400	/* 0: fixed priority, 1: round robin */
#define MZ_USRLED	0x00000800	/* turn on USER LED */
#define MZ_CDIS 	0x00001000	/* 0: disable 68020 cache, 1: enable */
#define MZ_DCEN		0x00002000	/* enable daughter card addressing */
					/* at 0x80000000 to 0xfdffffff */
#define MZ_PAREN	0x00004000	/* enable parity checking */
#define MZ_BR0EN	0x00010000	/* request VMEbus on request level 0 */
#define MZ_BR1EN	0x00020000	/* request VMEbus on request level 1 */
#define MZ_BR2EN	0x00040000	/* request VMEbus on request level 2 */
#define MZ_BR3EN	0x00080000	/* request VMEbus on request level 3 */
#define MZ_VMEBUS_ROR	0x00000000	/* set VMEbus Release On Request mode */
#define MZ_VMEBUS_RWD	0x00200000	/* set VMEbus Release When Done mode */
#define MZ_VMEBUS_RALW	0x00400000	/* set VMEbus Release ALWays mode */
#define MZ_VMEBUS_MODE	0x00600000	/* mask for above */
#define MZ_MBOX		0xff000000	/* A16 mailbox address bits 15-8 */


/* VME board control latch two.  A write only 32 bit register.
/* All undefined bits must be zero. */

#define MZ_CONTROL_LATCH_TWO_AD	0xfe500000
#define MZ_CONTROL_LATCH_TWO	((unsigned long *) MZ_CONTROL_LATCH_TWO_AD)

#define MZ_VIRQ		0x00000007	/* vector to interrupt VMEbus on */
#define MZ_SINT2EN	0x00000008	/* pulse low to generate soft intr 2 */
#define MZ_SINT1EN	0x00000010	/* pulse low to generate soft intr 1 */
#define MZ_TIMEREN	0x00010000	/* enable 4.44ms heartbeat timer */
#define MZ_A24EN	0x00020000	/* enable dual port RAM in A24 space */
#define MZ_A32EN	0x00040000	/* enable dual port RAM in A32 space */
#define MZ_DP_RAM_A24_ADRS 0x00f00000	/* A24 dual port RAM addr bits 23-20 */
#define MZ_DP_RAM_A32_ADRS 0xfff00000	/* A32 dual port RAM addr bits 31-20 */

/* VME board status register.  A read only 24 bit register */

#define MZ_STATUS_LATCH_ADRS	0xfe600000
#define MZ_STATUS_LATCH		((unsigned long *) MZ_STATUS_LATCH_ADRS)

#define MZ_STATUS_PARITY	0x00000001 /* 0: parity error occurred */
#define MZ_STATUS_SINT2		0x00000002 /* state of SINT2EN bit in CR2 */
#define MZ_STATUS_SINT1		0x00000004 /* state of SINT1EN bit in CR2 */
#define MZ_STATUS_ABORT		0x00000008 /* 0: NMI caused by abort switch */
#define MZ_STATUS_BAV		0x00000010 /* 0: I am current bus master */
#define MZ_STATUS_BCLR		0x00000020 /* 0: NMI caused by BCLR */
#define MZ_STATUS_ACFAIL	0x00000040 /* 0: NMI caused by ACFAIL */
#define MZ_STATUS_SYSFAIL	0x00000080 /* 0: NMI caused by SYSFAIL */
#define MZ_STATUS_DIPSWITCH	0x00003f00 /* 10 bit dip switch input */
#define MZ_STATUS_VIRQ		0x00004000 /* interrupted VMEbus but no ack */

#define MZ_INT_VEC_LATCH_ADRS	0xfe400000
#define MZ_INT_VEC_LATCH	((unsigned long *) MZ_INT_VEC_LATCH_ADRS)

/* on-board addresses of the daughter cards */

#define	MZ7810_BASE_ADRS	0x80000000		/* DEBUG 06/16/88 mcl */
#define	MZ7830_BASE_ADRS	0x80000000		/* DEBUG 06/16/88 mcl */


/* Equates for m68562 DUSCC serial port controller.
*  For more explanation see m68562.h,
*  which must be included in any file which also includes this file.
*/

#define	M562_BASE_ADRS		0xfe700000
#define	M562_BASE		((unsigned char *) M562_BASE_ADRS)

/* A port registers */

#define M562_CMR1A	(M562_BASE + 0x00) /* channel mode register 1 */
#define M562_CMR2A	(M562_BASE + 0x02) /* channel mode register 2 */
#define M562_S1RA	(M562_BASE + 0x04) /* secondary address register 1 */
#define M562_S2RA	(M562_BASE + 0x06) /* secondary address register 2 */
#define M562_TPRA	(M562_BASE + 0x08) /* transmitter parameter register */
#define M562_TTRA	(M562_BASE + 0x0a) /* transmitter timing register */
#define M562_RPRA	(M562_BASE + 0x0c) /* receiver parameter register */
#define M562_RTRA	(M562_BASE + 0x0e) /* receiver timing register */
#define M562_CTPRHA	(M562_BASE + 0x10) /* counter/timer preset reg. high */
#define M562_CTPRLA	(M562_BASE + 0x12) /* counter/timer preset reg. low */
#define M562_CTCRA	(M562_BASE + 0x14) /* counter/timer control reg. */
#define M562_OMRA	(M562_BASE + 0x16) /* output/miscellaneous reg. */
#define M562_CTHA	(M562_BASE + 0x18) /* counter/timer high */
#define M562_CTLA	(M562_BASE + 0x1a) /* counter/timer low */
#define M562_PCRA	(M562_BASE + 0x1c) /* pin configuration register */
#define M562_CCRA	(M562_BASE + 0x1e) /* channel command register */
#define M562_RSRA	(M562_BASE + 0x30) /* receiver status register */
#define M562_TRSRA	(M562_BASE + 0x32) /* xmitter/receiver status reg. */
#define M562_ICTSRA	(M562_BASE + 0x34) /* input counter/timer status reg. */
#define M562_IERA	(M562_BASE + 0x38) /* interrupt enable register */

/* A port fifo's */

#define M562_TXFIFOA	(M562_BASE + 0x20) /* transmitter FIFO */
#define M562_RXFIFOA	(M562_BASE + 0x28) /* receiver FIFO */

/* B port registers */

#define M562_CMR1B	(M562_BASE + 0x40) /* channel mode register 1 */
#define M562_CMR2B	(M562_BASE + 0x42) /* channel mode register 2 */
#define M562_S1RB	(M562_BASE + 0x44) /* secondary address register 1 */
#define M562_S2RB	(M562_BASE + 0x46) /* secondary address register 2 */
#define M562_TPRB	(M562_BASE + 0x48) /* transmitter parameter register */
#define M562_TTRB	(M562_BASE + 0x4a) /* transmitter timing register */
#define M562_RPRB	(M562_BASE + 0x4c) /* receiver parameter reg. */
#define M562_RTRB	(M562_BASE + 0x4e) /* receiver timing reg. */
#define M562_CTPRHB	(M562_BASE + 0x50) /* counter/timer preset reg. high */
#define M562_CTPRLB	(M562_BASE + 0x52) /* counter/timer preset reg. low */
#define M562_CTCRB	(M562_BASE + 0x54) /* counter/timer control reg. */
#define M562_OMRB	(M562_BASE + 0x56) /* output/miscellaneous reg. */
#define M562_CTHB	(M562_BASE + 0x58) /* counter/timer high */
#define M562_CTLB	(M562_BASE + 0x5a) /* counter/timer low */
#define M562_PCRB	(M562_BASE + 0x5c) /* pin configuration reg. */
#define M562_CCRB	(M562_BASE + 0x5e) /* channel command reg. */
#define M562_RSRB	(M562_BASE + 0x70) /* receiver status reg. */
#define M562_TRSRB	(M562_BASE + 0x72) /* xmitter/receiver status reg. */
#define M562_ICTSRB	(M562_BASE + 0x74) /* input counter/timer status reg. */
#define M562_IERB	(M562_BASE + 0x78) /* interrupt enable reg. */

/* B port fifo's */

#define M562_TXFIFOB	(M562_BASE + 0x60) /* transmitter FIFO */
#define M562_RXFIFOB	(M562_BASE + 0x68) /* receiver FIFO */


/* common registers */

#define M562_GSR	(M562_BASE + 0x76) /* general status register */
#define M562_IVR	(M562_BASE + 0x3c) /* interrupt vector register */
#define M562_IVRM	(M562_BASE + 0x7c) /* interrupt vector modified reg. */
#define M562_ICR	(M562_BASE + 0x3e) /* interrupt control register */

/* end of equates for m68562 DUSCC serial port controller */


/* The following are the initial values of the board control latches */

/* The following is the initial value of board control latch one.	*/
/* The CPU is set up to its initial mailbox address of 0xffffbf00;	*/
/* VMEbus ROR mode; VMEbus request level 3, no parity, cache enabled	*/
/* (CDIS is active low), daughter card disabled, user LED turned on,	*/
/* round robin mode, SYSFAIL interrupt enabled, BCLR interrupt enabled,	*/
/* mailbox interrupts disabled, VMEbus interrupts disabled (IRQxEN	*/
/* are active low also).						*/

#define INITIAL_MAILBOX_BITS	0xbf000000	/* A16 address 0xffffbf00 */

#define INITIAL_LATCH_ONE	( INITIAL_MAILBOX_BITS + \
				MZ_VMEBUS_ROR	+ \
				MZ_BR3EN	+ \
				MZ_CDIS		+ \
				MZ_USRLED	+ \
				MZ_PRIARB	+ \
				MZ_IRQALLEN )

/* The following is the initial value of board control latch two.	*/
/* The CPU is set up to its initial dual-port RAM address;		*/
/* A32 DPRAM access enabled; A24 DPRAM access enabled;			*/
/* heartbeat timer enabled; software interrupts 1 and 2 initialized.	*/

#define INITIAL_LATCH_TWO	( LOCAL_MEM_BUS_ADRS + \
				MZ_A32EN	+ \
				MZ_A24EN	+ \
				MZ_SINT1EN	+ \
				MZ_SINT2EN )

#endif	INCmz7122h
