/* ms100db.h - Matrix MS-CPU100 DUART header file */

/*
modification history
--------------------
01a,09sep88,dmp  created by modifing mz7120sp4.h 
*/

/*
This file contains DUART address and related constants
for the Matrix MS-CPU100.
*/

#ifndef    INCms100dbh  
#define    INCms100dbh 

/* equates for m68681 serial channel - for more explanation see m68681.h, */
/* which must be included in any file which also includes this file  */

#define MS_68681_BASE    ((char *) 0x00fe0000)

#define DUART_MRA    (MS_68681_BASE + 0x01)    /* mode reg. A */
#define DUART_CSRA   (MS_68681_BASE + 0x03)    /* clock select reg. A */
#define DUART_SRA    DUART_CSRA                /* status reg. A */
#define DUART_CRA    (MS_68681_BASE + 0x05)    /* command reg. A */
#define DUART_THRA   (MS_68681_BASE + 0x07)    /* transmit buffer A */
#define DUART_RHRA   DUART_THRA                /* receive buffer A */
#define DUART_ACR    (MS_68681_BASE + 0x09)    /* auxiliary control reg. */
#define DUART_IPCR   DUART_ACR                 /* input port change reg. */
#define DUART_IMR    (MS_68681_BASE + 0x0b)    /* int. mask reg. */
#define DUART_ISR    DUART_IMR                 /* int. status reg. */
#define DUART_CTUR   (MS_68681_BASE + 0x0d)    /* counter timer upper reg. */
#define DUART_CTLR   (MS_68681_BASE + 0x0f)    /* counter timer lower reg. */
#define DUART_MRB    (MS_68681_BASE + 0x11)    /* mode reg. B */
#define DUART_CSRB   (MS_68681_BASE + 0x13)    /* clock select reg. B */
#define DUART_SRB    DUART_CSRB                /* status reg. B */
#define DUART_CRB    (MS_68681_BASE + 0x15)    /* command reg. B */
#define DUART_THRB   (MS_68681_BASE + 0x17)    /* transmit buffer B */
#define DUART_RHRB   DUART_THRB                /* receive buffer B */
#define DUART_IVR    (MS_68681_BASE + 0x19)    /* int. vector reg. */
#define DUART_OPCR   (MS_68681_BASE + 0x1b)    /* output port config. reg. */
#define DUART_IP     DUART_OPCR                /* input port */
#define DUART_ROPBC  (MS_68681_BASE + 0x1d)    /* reset output port bits */
#define DUART_CTRON  DUART_ROPBC               /* counter on  */
#define DUART_SOPBC  (MS_68681_BASE + 0x1f)    /* set output port bits */
#define DUART_CTROFF DUART_SOPBC               /* counter off */

/* end of equates for m68681 */

/* equates for the ms100 board control and status registers */
#define MS_BCSR_BASE    ((char *) 0x00fe4000)
 
/* equates for the bcsr interrupt source registers (r only) 1=pending 0=clear.*/
#define BCSR_TODC_ISR   (MS_BCSR_BASE + 0x01)   /* time of day clock int */
#define BCSR_ACFAIL_ISR (MS_BCSR_BASE + 0x03)   /* acfail int */
#define BCSR_DUART_ISR  (MS_BCSR_BASE + 0x05)   /* DUART int */
#define BCSR_XPBRD_ISR  (MS_BCSR_BASE + 0x07)   /* expansion board int */
#define BCSR_BUSMS_ISR  (MS_BCSR_BASE + 0x09)   /* bus master int */
/* equates for the bcsr interrupt mask registers (r/w) 1=mask 0=unmask. */
#define BCSR_ACFAIL_IMR (MS_BCSR_BASE + 0x0b)   /* acfail int mask */
#define BCSR_XPBRD_IMR  (MS_BCSR_BASE + 0x0d)   /* expansion board int mask */
#define BCSR_BUSMS_IMR  (MS_BCSR_BASE + 0x0f)   /* bus master int mask */
#define BCSR_SEMA4_IMR  (MS_BCSR_BASE + 0x11)   /* semaphore int mask */
/* equates for the bcsr instantaneous value registers (r only) 1=yes 0=no. */
#define BCSR_ACFAIL_IVR (MS_BCSR_BASE + 0x13)   /* acfail int in */
#define BCSR_XPBRD_IVR  (MS_BCSR_BASE + 0x15)   /* expansion board int in */
#define BCSR_BUSMS_IVR  (MS_BCSR_BASE + 0x17)   /* bus master int in */
/* equates for the bcsr other registers (r/w only). */
#define BCSR_ACFAIL_OR  (MS_BCSR_BASE + 0x19)   /* semaphore (init to 0) */
#define BCSR_BRH_OR     (MS_BCSR_BASE + 0x1b)   /* bus request and hold  */
#define BCSR_XPBRD_OR   (MS_BCSR_BASE + 0x1d)   /* expansion board sense */
#define BCSR_WDT_OR     (MS_BCSR_BASE + 0x1f)   /* watchdog timer */
 
/* end of equates for BCSR   */

/* equates for the ms100 time of day clock, which is the Epson RTC-72421 */
#define MS_72421_BASE   ((char *) 0x00fec000)

#define TODC_SECONDS    (MS_72421_BASE + 0x01)   /* time of day seconds */
#define TODC_TEN_SEC    (MS_72421_BASE + 0x03)   /* tens of seconds */
#define TODC_MINUTES    (MS_72421_BASE + 0x05)   /* minutes */
#define TODC_TEN_MIN    (MS_72421_BASE + 0x07)   /* tens of minutes */
#define TODC_HOURS      (MS_72421_BASE + 0x09)   /* hours */
#define TODC_TEN_HRS    (MS_72421_BASE + 0x0b)   /* tens of hours(12,24,a/pm) */
#define TODC_DAY        (MS_72421_BASE + 0x0d)   /* days  */
#define TODC_TEN_DAY    (MS_72421_BASE + 0x0f)   /* tens of days  */
#define TODC_MONTH      (MS_72421_BASE + 0x11)   /* months */
#define TODC_TEN_MTH    (MS_72421_BASE + 0x13)   /* tens of months */
#define TODC_YEAR       (MS_72421_BASE + 0x15)   /* year */
#define TODC_TEN_YRS    (MS_72421_BASE + 0x17)   /* tens of years */
#define TODC_DOW        (MS_72421_BASE + 0x19)   /* day of week */
#define TODC_CR1        (MS_72421_BASE + 0x1b)   /* control register #1 */
#define TODC_CR2        (MS_72421_BASE + 0x1d)   /* control register #2 */
#define TODC_CR3        (MS_72421_BASE + 0x1f)   /* control register #3 */

/* end of equates for e72421 */

/* Equates for the ms100 interrupt handler registers. All interrupts on & off */
/* board are brought through this chip. */
#define    MS_INTH_BASE    ((char *) 0x00fe6000)

#define INTH_MAIN_MKS   (MS_INTH_BASE + 0x01)   /* main interrupt mask reg */
#define INTH_IRQ1_MKS   (MS_INTH_BASE + 0x03)   /* int request 1 mask reg */
#define INTH_IRQ2_MKS   (MS_INTH_BASE + 0x05)   /* int request 2 mask reg */
#define INTH_IRQ3_MKS   (MS_INTH_BASE + 0x07)   /* int request 3 mask reg */
#define INTH_IRQ4_MKS   (MS_INTH_BASE + 0x09)   /* int request 4 mask reg */
#define INTH_IRQ5_MKS   (MS_INTH_BASE + 0x0b)   /* int request 5 mask reg */
#define INTH_IRQ6_MKS   (MS_INTH_BASE + 0x0d)   /* int request 6 mask reg */
#define INTH_IRQ7_MKS   (MS_INTH_BASE + 0x0f)   /* int request 7 mask reg */

/* end of equates for interrupt handler */

/* Equates for the ms100 interrupt handler registers. All interrupts on & off */

#define NV_CMD_MASK      0x07           /* command mask for non-volatile ram */
#define NV_XEBL_MASK     0x80           /* external board enable mask */
#define NV_SIZE          0x16           /* non-volatile ram size */
#define NV_WIDTH         0x16           /* non-volatile ram width */
/* equates for the non-volatile ram commands */
#define NV_WRDS_CMD      0x00           /* write de-select */
#define NV_STO_CMD       0x01           /* store ram data into EEPROM */
#define NV_SLEEP_CMD     0x02           /* enter sleep mode */
#define NV_WRITE_CMD     0x03           /* write data into ram */
#define NV_WREN_CMD      0x04           /* write enable */
#define NV_RECALL_CMD    0x05           /* recall for EEPROM to static ram */
#define NV_READ_CMD      0x06           /* read data from ram */


/* Equates for input port register. These equates are bit definitions for the *
*  input port and would normally go into m68681. However, these bits are *
*  board dependant and are therefore defined here. */

#define    IPR7        0x80        
#define    IPR6        0x40        
#define    IPR5        0x20       
#define    IPR4        0x10      
#define    IPR3        0x08     	/* 0 = sysfail, 1 = clear  */
#define    IPR2        0x04    
#define    IPR1        0x02   
#define    IPR0        0x01  

#endif    INCms100dbh  
