/* iv1624.h - Ironics IV-1624A 8-port CPU board header file */

/*
modification history
--------------------
01h,22jul88,gae  fixed name to IV-1624A.  Fixed CLK_STATUS_INT_3 defn. bug.
01g,29apr88,gae  added BUS and CPU constants.
01f,04dec87,dnw  elaborated CLK_... and IGOR_... stuff.
01e,22nov87,dnw  moved IV_LOC_BASE and IV_CLOCK to config.h
		 changed vec adrs IV_SIOn to vec nums INT_VEC_SIOn.
01d,23oct87,dnw  changed SCC_CONTROL to IV24_CONTROL_PORT.
01c,08jan87,jlf  added ifndef's to keep from being included twice.
01b,10dec86,rdc	 added STATIC_RAM stuff;
		 added 10/12 Mhz clock definitions.
01a,17jun86,jlf	 written.
*/

/*
This file contains I/O addresses and related constants
for the Ironics IV-1624A.
*/

#ifndef INCiv1624h
#define INCiv1624h

#define TARGET_IV24

#define BUS		VME_BUS
#define CPU		MC68010


#define N_SIO_CHANNELS	8		/* Number of serial I/O channels */

#define SYS_CLK_FREQ_10	19660800	/* 10Mhz sys clock freq is 19.6608MHz */
#define SYS_CLK_FREQ_12	24576000	/* 12Mhz sys clock freq is 24.576 MHz */


/* port addresses for Zilog Z8530 SCC (Serial Communication Controller) */

#define	SCC_BASE_ADR	0x00f7e000)

#define	SCC0BASE ((char *) (SCC_BASE_ADR+0x004) /* sccs 0 base address */
#define	SCC1BASE ((char *) (SCC_BASE_ADR+0x000) /* sccs 1 base address */
#define	SCC2BASE ((char *) (SCC_BASE_ADR+0x404) /* sccs 2 base address */
#define	SCC3BASE ((char *) (SCC_BASE_ADR+0x400) /* sccs 3 base address */
#define	SCC4BASE ((char *) (SCC_BASE_ADR+0x804) /* sccs 4 base address */
#define	SCC5BASE ((char *) (SCC_BASE_ADR+0x800) /* sccs 5 base address */
#define	SCC6BASE ((char *) (SCC_BASE_ADR+0xc04) /* sccs 6 base address */
#define	SCC7BASE ((char *) (SCC_BASE_ADR+0xc00) /* sccs 7 base address */


/* control port */

#define IV24_CONTROL_PORT ((char *) 0x00f7e200)	/* control port address */

#define CTRL_FAIL	0x80		/* assert SYSFAIL */
#define CTRL_LOCKVME	0x40		/* lock VME bus */


/* Motorola MC68B40 PTM (Programmable Timer Module) */

/* clock registers */

#define	CLK_BASE_ADR	0x00f7f800

#define CLK_REG13	((char *) (CLK_BASE_ADR+0x0))	/* control reg 1 & 3 */
#define CLK_REG2	((char *) (CLK_BASE_ADR+0x2))	/* control reg 2 */
#define CLK_STATUS	((char *) (CLK_BASE_ADR+0x2))
#define CLK_WMSB1	((char *) (CLK_BASE_ADR+0x4))
#define CLK_CHAN1	((char *) (CLK_BASE_ADR+0x6))
#define CLK_WMSB2	((char *) (CLK_BASE_ADR+0x8))
#define CLK_CHAN2	((char *) (CLK_BASE_ADR+0xa))
#define CLK_WMSB3	((char *) (CLK_BASE_ADR+0xc))
#define CLK_CHAN3	((char *) (CLK_BASE_ADR+0xe))

/* clock control register bits */

#define CLK_CTRL_HOLD_ALL	0x01	/* control reg 1: hold all timers */
#define CLK_CTRL_SELECT_R1	0x01	/* control reg 2: select REG13 = R1 */
#define CLK_CTRL_PRESCALE	0x01	/* control reg 3: prescale tmr 3 by 8 */
#define CLK_CTRL_USE_ENABLE_CLK	0x02	/* use Enable clk instead of external */
#define CLK_CTRL_8_BIT_COUNT	0x04	/* 8-bit count instead of 16-bit */
#define CLK_CTRL_CONTINUOUS_1	0x00	/* timer modes... */
#define CLK_CTRL_SINGLE_SHOT_1	0x08
#define CLK_CTRL_CONTINUOUS_2	0x10
#define CLK_CTRL_SINGLE_SHOT_2	0x18
#define CLK_CTRL_FREQ_COMPARE_1	0x20
#define CLK_CTRL_FREQ_COMPARE_2	0x28
#define CLK_CTRL_PW_COMPARE_1	0x30
#define CLK_CTRL_PW_COMPARE_2	0x38
#define CLK_CTRL_INT_ENABLE	0x40	/* enable interrupt */
#define CLK_CTRL_OUTPUT_ENABLE	0x80	/* enable timer output */

/* clock control register bits */

#define CLK_STATUS_INT_1	0x01
#define CLK_STATUS_INT_2	0x02
#define CLK_STATUS_INT_3	0x04
#define CLK_STATUS_INT_ANY	0x80

/* Signetics SCB68154 Interrupt Vector Handler - IVHAN */

#define	IVH_BASE_ADR	0x00f7f000

#define IVH_PTR	 ((char *) (IVH_BASE_ADR+0x1)) /* Int handler chip select */
#define IVH_CTL	 ((char *) (IVH_BASE_ADR+0x3)) /* Int handler control reg */
#define IVH_LRQV ((char *) (IVH_BASE_ADR+0x5)) /* local req vec base */
#define IVH_LRQM ((char *) (IVH_BASE_ADR+0x7)) /* local req vec mask */
#define IVH_LRQS ((char *) (IVH_BASE_ADR+0x9)) /* local req vec status */
#define IVH_IRQM ((char *) (IVH_BASE_ADR+0xb)) /* bus req mask */
#define IVH_IRQS ((char *) (IVH_BASE_ADR+0xd)) /* bus req status */
#define IVH_LIA	 ((char *) (IVH_BASE_ADR+0xf)) /* last int acknowleged */

/* bits in ivhan.ctrlReg */

#define IVH_ACTIVE_HIGH		0x01
#define IVH_EDGE_SENSITIVE	0x02
#define IVH_VEC_ENABLE		0x04

/* bits in ivhan.lrqMask */

#define IVHAN_NMI_VEC_ENABLE	0x01
#define IVHAN_NMI_ENABLE	0x80

/* interrrupt handler inputs */

#define INT_ACFAIL	7	/* from VME bus */
#define INT_SYSFAIL	6	/* from VME bus */
#define INT_TMRIRQ	5
#define INT_SIOIRQ01	4	/* interrupt from scc's 0 and 1 */
#define INT_SIOIRQ23	3	/* interrupt from scc's 2 and 3 */
#define INT_MAILBOXIRQ	2	/* mailbox int */
#define INT_DMAIRQ	1

#define INT_VEC_SIO0	128	/* base vector for sio 0 */
#define INT_VEC_SIO1	144	/* base vector for sio 1 */
#define INT_VEC_SIO2	160	/* base vector for sio 2 */
#define INT_VEC_SIO3	176	/* base vector for sio 3 */

/* Signetics SCB68154 Interrupt Generator - IGOR */

#define IGOR_IVR	((char *) 0x00f7f401)	/* int vector register */
#define IGOR_IRR	((char *) 0x00f7f403)	/* int request register */

#define IGOR_IVR_ENABLE		0x02
#define IGOR_IVR_CLEAR		0x04
#define IGOR_IVR_VEC_MASK	0xf8

#define IGOR_IRR_REQ_MASK	0xfe

/* Miscellaneous addresses */

#define IV24_SRAM	((char *)0x00fe0000)	/* static RAM local address */
#define	IV24_SRAM_SIZE	(0x4000-0x100)		/* static RAM size 16K - 256 */
#define IV24_MAILBOX_SIZE	0x100		/* last 256 bytes of static RAM
						 * cause mailbox interrupt */

#define DMACS		0x00f7fc00		/* DMA controller chip select */

#define	J10		(char *)(DMACS+0x80)
#define	J11		(char *)(DMACS+0x40)
#define	J12		(char *)(DMACS+0x00)
#define	J13		(char *)(DMACS+0xc0)

#endif	INCiv1624h
