/* romInit.s - init module for code in rom for Heurikon HKV2F */

/*
modification history
--------------------
01d,22jun88,dnw  added clearing of BCL to compensate for sysHwInit not clearing
		   system controller bit.
01c,19nov87,dnw  changed to use ROM_BASE_ADRS & LOCAL_MEM_LOCAL_ADRS in config.h
01b,16nov87,jcf	 romInit2 now takes an argument from sysToMonitor
01a,18sep87,dnw  written
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "sysLib.h"
#include "config.h"

	/* internals */

	.globl	_romInit	/* start of system code */

	/* externals */

	.globl	_usrInit	/* system initialization routine */


	.text
	.even

_romInit:
	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit1	/* initial start in rom */

	movew	#0x3700,sr	/* disable interrupts, turn on M bit */
	bra	romInit2	/* subsequent starts in rom */


/***********************************************************************
*
* romInit1 -
*
* enable cache, clear all memory, copy rom to ram, set stack, go to usrInit
* This routine is position independent.

* romInit1 ()

*/

romInit1:
	/* clear BCL to reset sys controller because sysHwInit doesn't do it */

	movel	#0,0xfe8000

	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	movel	#0x09,d0	/* clear and enable cache */
	.word	0x4e7b		/* movec ... 			*/
	.word	0x0002		/* .....	d0,cacr 	*/


	/* clear all of memory;
	 * outer loop counter in d2 = 0x3f =
	 *
	 *   16M bytes to clear
	 *   ------------------  - 1
	 *   64K * 4               ^
	 *    ^    ^               |
	 *    |    |               for dbra at end of outer loop
	 *    |    bytes per inner loop
	 *    inner loops per outer loop
	 */

	movel	#0x3f,d2		/* outer loop counter */
	movel	#LOCAL_MEM_LOCAL_ADRS,a0 /* get start of local memory */
	clrl	d0			/* value to fill */


fb1:	movel	#0xffff,d1		/* set to fill 64K */
fb2:	movel	d0,a0@+			/* move 4 bytes */
	dbra	d1,fb2			/* inner loop test */
	dbra	d2,fb1			/* outer loop test */


	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop1:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop1


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	#BOOT_COLD,a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

/***********************************************************************
*
* romInit2 -
*
* same as romInit but doesn't clear memory.
* This routine is position independent.

* romInit2 ()

*/

romInit2:
	link	a6,#0		/* no unlk necessary; we change stacks */

	/* clear BCL to reset sys controller because sysHwInit doesn't do it */

	movel	#0,0xfe8000

	/* Enable the cache by writing to the cache control register.
	 * Since the assemblers differ on the syntax for this one
	 * (if they even have it), it's done with two .word's. */

	movel	#0x09,d0	/* clear and enable cache */
	.word	0x4e7b		/* movec ... 			*/
	.word	0x0002		/* .....	d0,cacr 	*/


	/* copy system from rom to ram */

	movel	#_romInit,a0		/* where system should be in ram */
	movel	#ROM_BASE_ADRS + 8,a1	/* where system is in rom */
	movel	#0x7ffd,d1		/* 32K*4 = 128K bytes (-8 byte vector)*/
loop2:
	movel	a1@+,a0@+		/* copy 4 bytes of code */
	dbf	d1,loop2


	/* set stack to grow down from start of code and call system init */

	movel	#_romInit,a7		/* set stack to start of code */
	movel	a6@(0x08),a7@-		/* push arg = start type */
	jsr	_usrInit		/* never returns - starts up kernel */

