/* hkv2f/config.h - Heurikon HK68/V2F configuration header */

/*
modification history
--------------------
*/

/*
This file contains the parameters that define the configuration
for the Heurikon HK68/V2F.
*/

#ifndef	INCconfigh
#define	INCconfigh

#include "hkv2f.h"


#define CONSOLE_DEVICE	"/tyCo/0"	/* initial console device */
#define DEFAULT_BOOT_LINE \
"enp(0,0)host:/usr/vw/config/hkv2f/vxWorks h=90.0.0.2 e=90.0.0.50 u=target"

/******************************************************************************/
/*                                                                            */
/*                  KERNEL SOFTWARE CONFIGURATION                             */
/*                                                                            */

#define FREE_RAM_ADRS		(&end)	/* start right after bss of UniWorks */	

#define MAX_TASKS		25	/* maximum # of tasks in system */

#define INT_LOCK_LEVEL  	7	/* interrupt disable mask */

#define MAX_SYS_SYMBOLS		3500	/* max symbols in sys symbol table */

#define ROOT_STACK_SIZE		5000	/* size of root's stack, in bytes */
#define SHELL_STACK_SIZE	10000	/* size of shell's stack, in bytes */

#define ISR_STACK_SIZE		1000	/* size of ISR stack, in bytes */

/* i/o system parameters */

#define NUM_DRIVERS		20	/* max 20 drivers in drvTable */
#define NUM_FILES		50	/* max 50 file open simultaneously */
#define NUM_RT_FILES		5	/* max 5 RT-11 files open */


/******************************************************************************/
/*                                                                            */
/*                  "GENERIC" SOFTWARE CONFIGURATION                          */
/*                                                                            */
/******************************************************************************/

/* included software facilities */

#define	INCLUDE_SHELL		/* command shell */
#define	INCLUDE_RLOGIN		/* remote login */
#define INCLUDE_TELNET		/* telnet-style remote login */
#define INCLUDE_RPC		/* rpc package */
#define INCLUDE_NFS		/* nfs package */
#define INCLUDE_FLOATING_POINT	/* floating point I/O */
#define INCLUDE_MC68881		/* MC68881/2 float point proc */
#define	INCLUDE_STDIO		/* standard I/O */
#define	INCLUDE_RT11		/* RT-11 file system */
#define	INCLUDE_RAMDRV		/* ram disk driver */
#define INCLUDE_DEBUG		/* native debugging */
#define	INCLUDE_TIMEX		/* timexLib for exec timing */
#define	INCLUDE_SPY		/* spyLib for task monitoring */
#define	INCLUDE_1.5COMPAT		/* 1.5 compatibility routines */
#define	INCLUDE_RAM		/* RAM pseudo-disk driver */
#define	INCLUDE_DBX		/* DBX debugger */

/* included hardware support */

#define INCLUDE_BP		/* include backplane net interface */
#define INCLUDE_ENP		/* include CMC Ethernet interface*/

/* excluded hardware support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define INCLUDE_EX		/* include Excelan Ethernet interface */
#define INCLUDE_PN		/* include Proteon network interface*/
#define INCLUDE_NW		/* include ISI Ethernet interface */
#define INCLUDE_VB		/* include isi backplane net interface*/
#define INCLUDE_HM		/* include isi backplane net interface*/
#define	INCLUDE_TS		/* TC50 half-inch tape driver */
#define	INCLUDE_SM		/* Interphase SMD controller */
#define INCLUDE_IE		/* include Sun Ethernet interface*/
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE

/* excluded facilities/support */

#if FALSE
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*#define INCLUDE_FORTRAN*/
#define INCLUDE_PASCAL		/* support for Pascal */
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif	FALSE


/******************************************************************************/
/*                                                                            */
/*                   "GENERIC" BOARD CONFIGURATION                            */
/*                                                                            */
/******************************************************************************/

/* interrupt vectors */

#define VEC_BASE_ADRS		((char *) LOCAL_MEM_LOCAL_ADRS)

#define INT_VEC_CONFIG_TBL	63	/* usrCftbl ptr */

#define TRAP_KERNEL		0	/* trap 0 - kernel trap */
#define TRAP_UNIWORKS		1	/* trap 1 - UniWorks trap */
#define TRAP_DEBUG		2	/* trap 2 - breakpoint trap */


/******************************************************************************/
/*                                                                            */
/*                   "MISCELLANEOUS" CONSTANTS                                */
/*                                                                            */
/******************************************************************************/


/* Messages from exceptions during exceptions go at the following address */

#define EXC_MSG_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x800))

/* The bootroms put the boot line at the following address */

#define BOOT_LINE_ADRS		((char *) (LOCAL_MEM_LOCAL_ADRS + 0x700))

/* Default NFS parameters */

#define NFS_USER_ID	2001
#define NFS_GROUP_ID	100

#define	NV_RAM_SIZE	HK_NVRAM_SIZE	/* has 128 bytes of non-volatile RAM */

/*
 * Device controller I/O addresses: the hkv2f needs bit 0x0100000 set
 */

#define IO_ADRS_EX	((char *) 0x01ff0000)	/* 24A,32D Excelan Ethernet */
#define IO_ADRS_ENP	((char *) 0x01de0000)	/* 24A,32D CMC Ethernet */
#define IO_ADRS_IE	((char *) 0x01300000)	/* 24A,32D Sun Ethernet */
#define IO_ADRS_NW	((char *) 0x01f80000)	/* 24A,32D ISI Ethernet */
#define IO_ADRS_PN	((char *) 0x01100000)	/* 24A,32D Proteon ProNet */


/* interrupt vectors */

#define INT_VEC_CLOCK		(MFP_INT_VECT_NUM + MFP_INT_TIMER_A)
#define INT_VEC_PARITY_ERROR	(MFP_INT_VECT_NUM + PARITY_ERROR_VEC_NUM)

#define INT_VEC_EX	(MFP_INT_VECT_NUM + MFP_INT_VME_2)	/* Excelan */

#define INT_VEC_BP	(MFP_INT_VECT_NUM + MFP_INT_MAILBOX)	/* backplane */


/* backplane network parameters */

/*
 * Mailbox addresses for Heurikon boards are defined by 8 bits in the bus latch.
 * We set the high order 3 bits to one and use the five low order bits to
 * define the address based on the processor number:
 *
 * processor #:       VME short I/O address:
 *     0                   0xe000
 *     1                   0xe008
 *     2                   0xe010
 *     etc...
 */

#define BP_OFF_BOARD	FALSE

#if	BP_OFF_BOARD
#define BP_ANCHOR_ADRS	((char *) (0x1800000))	/* off-board anchor adrs */
#else
#define BP_ANCHOR_ADRS	((char *) (0x2000600))	/* on-board anchor adrs */
#endif	BP_OFF_BOARD

#define BP_INT_TYPE	BP_INT_MAILBOX_1		/* mailbox interrupt */
#define BP_INT_ARG1	VME_AM_SUP_SHORT_IO		/* bus address space */
#define BP_INT_ARG2	(0xe000 | (sysProcNum << 3))	/* bus adrs */
#define BP_INT_ARG3	0				/* value */

/* the backplane master (usually cpu 0) also needs to know the following
 * shared memory pool parameters. */

#if	BP_OFF_BOARD
#define BP_MEM_ADRS	BP_ANCHOR_ADRS	/* off-board shared mem adrs */
#define BP_MEM_SIZE	0x40000		/* 256K */
#else
#define BP_MEM_ADRS	NONE		/* NONE = allocate sh. mem from pool */
#define BP_MEM_SIZE	0x10000		/* 64K */
#endif	BP_OFF_BOARD


/* memory addresses */

/*
 * Local-to-Bus memory address constants:
 * the hkv2f local memory always appears at 0x02000000;
 * its address on the bus is set by bits in the BCL, currently always at 0.
 */

#define LOCAL_MEM_LOCAL_ADRS	0x02000000		/* fixed */
#define LOCAL_MEM_BUS_ADRS	0			/* set in BCL */

/* The following address is the base address of the on-board rom */

#define ROM_BASE_ADRS		0x0

#endif	INCconfigh
