/* fppALib.s - floating-point coprocessor support assembly routines */

	.data
	.asciz	"Copyright 1987, Wind River Systems, Inc."

/*
modification history
--------------------
*/

/*
DESCRIPTION
This library contains routines to be used to support the MC68881/MC68882
coprocessor.
FppSave and fppRestore save and restore all the task context information,
the programming model including the 8 extended double precision registers
and the 3 control registers.  Higher level access mechanisms are found
in fppLib(1).

SEE ALSO: MC68881/MC68882 User's Manual
*/

#define ASMLANGUAGE
#include "UniWorks.h"
#include "fppLib.h"
#include "asm.h"

/* The following flag controls the assembly of the fpp instructions.
 *   If TRUE, the fpp instructions are assembled (many assemblers can't handle).
 *   If FALSE, hand-coded machine code equivalents are assembled.
 */

#define FPP_ASSEM	FALSE


	.text
	.even

	/* internals */

	.globl _fppSave
	.globl _fppRestore
	.globl _fppDtoDx
	.globl _fppDxtoD
	.globl _fppProbeSup
	.globl _fppProbeTrap

	.text
	.even

/*******************************************************************************
*
* fppSave - save coprocessor context
*
* This routine saves the coprocessor context.
* The context saved is:
*       fpcr, fpsr, fpiar
*	f0-f7
*	internal state frame
*
* If the internal state frame is null, the other registers are not saved.
*
* SEE ALSO: fppRestore(2), MC68881 Coprocessor User's Manual

* VOID fppSave (pFpContext)
*     FP_CONTEXT *pFpContext;	/* where to save context *

*/

_fppSave:
	link	a6,#0

	movel	a6@(ARG1),a0	/* where to save registers */

#if FPP_ASSEM
	fsave	a0@(STATEFRAME)		/* get MC68881 state frame */
	tstb	a0@(STATEFRAME)		/* check for null frame */
	beq	so_null			/* yes, skip saving rest of state */
	fmovemx	f0-f7,a0@(FPX)		/* save data registers */
	fmoveml	#<fpcr,fpsr,fpiar>,a0@(FPCR)	/* save control registers */
#else
	.word	0xf328,0x006c		/* fsave   a0@(STATEFRAME) */
	tstb	a0@(STATEFRAME)
	beq	so_null
	.word	0xf228,0xf0ff,0x000c	/* fmovemx f0-f7,a0@(FPX) */
	.word	0xf228,0xbc00,0x0000	/* fmoveml #<fpcr,fpsr,fpiar>,a0@(FPCR*/
#endif

so_null:
	unlk	a6
	rts
/*******************************************************************************
*
* fppRestore - restore coprocessor context
*
* This routine restores the coprocessor programming model.
* The context restored is:
*	f0-f7
*	fpcr, fpsr, fpiar.
*	internal state frame,
*
* If the internal state frame is null, the other registers are not restored.
*
* SEE ALSO: fppSave(2), MC68881 Coprocessor User's Manual

* VOID fppRestore (pFpContext)
*    FP_CONTEXT *pFpContext;	/* from where to restore context *

*/

_fppRestore:
	link	a6,#0

	movel	a6@(ARG1),a0		/* from where to restore registers */
	tstb	a0@(STATEFRAME)		/* is it a null frame? */
	beq	si_null			/* yes, so restore only state frame */

#if FPP_ASSEM

	fmovemx	a0@(FPX),f0-f7			/* restore data registers */
	fmoveml	a0@(FPCR),#<fpcr,fpsr,fpiar>	/* restore control registers */
si_null:
	frestore	a0@(STATEFRAME)		/* restore state frame */

#else

	.word	0xf228,0xd0ff,0x000c	/* fmovemx a0@(FPX),f0-f7 */
	.word	0xf228,0x9c00,0x0000	/* fmoveml a0@(FPCR),#<fpcr,fpsr,fpiar*/
si_null:
	.word	0xf368,0x006c		/* frestore a0@(STATEFRAME) */

#endif

	unlk	a6
	rts
/*******************************************************************************
*
* fppDtoDx - convert double to extended double precision
*
* The MC68881 uses a special extended double precision format
* (12 bytes as opposed to 8 bytes) for internal operations.
* The routines fppSave and fppRestore must preserve this precision.
*
* NOMANUAL

* VOID fppDtoDx (pDx, pDouble)
*     DOUBLEX *pDx;	 /* where to save result    *
*     double *pDouble;	 /* ptr to value to convert *

*/

_fppDtoDx:
	link	a6,#0

#if FPP_ASSEM
	fmovex	f0,a7@-		/* save regs */
	movel	a6@(ARG1),a1	/* to Dx */
	movel	a6@(ARG2),a0	/* from D */
	fmoved	a0@,f0		/* convert double */
	fmovex	f0,a1@		/* to extended */
	fmovex	a7@+,f0		/* restore regs */
#else
	.word	0xf227,0x6800	/* fmovex  f0,a7@- */
	movel	a6@(ARG1),a1
	movel	a6@(ARG2),a0
	.word	0xf210,0x5400	/* fmoved  a0@,f0 */
	.word	0xf211,0x6800	/* fmovex  f0,a1@ */
	.word	0xf21f,0x4800	/* fmovex  a7@+,f0 */
#endif

	unlk	a6
	rts
/*******************************************************************************
*
* fppDxtoD - convert extended double precisoion to double
*
* The MC68881 uses a special extended double precision format
* (12 bytes as opposed to 8 bytes) for internal operations.
* The routines fppSave and fppRestore must preserve this precision.
*
* NOMANUAL

* VOID fppDxtoD (pDouble, pDx)
*     double *pDouble;		/* where to save result    *
*     DOUBLEX *pDx;		/* ptr to value to convert *

*/

_fppDxtoD:
	link	a6,#0

#if FPP_ASSEM
	fmovex	f0,a7@-		/* save regs */
	movel	a6@(ARG1),a1	/* to D */
	movel	a6@(ARG2),a0	/* from Dx */
	fmovex	a0@,f0		/* convert extended */
	fmoved	f0,a1@		/* to double */
	fmovex	a7@+,f0		/* restore regs */
#else
	.word	0xf227,0x6800	/* fmovex  f0,a7@- */
	movel	a6@(ARG1),a1
	movel	a6@(ARG2),a0
	.word	0xf210,0x4800	/* fmovex  a0@,f0 */
	.word	0xf211,0x7400	/* fmoved  f0,a1@ */
	.word	0xf21f,0x4800	/* fmovex  a7@+,f0 */
#endif

	unlk	a6
	rts
/*******************************************************************************
*
* fppProbeSup - fppProbe support routine
*
* This routine executes some coprocessor instruction which will cause a
* bus error if a coprocessor is not present.  A handler, viz. fppProbeTrap,
* should be installed at that vector.  If the coprocessor is present this
* routine returns OK.
*
* SEE ALSO: MC68881/MC68882 User's Manual, page 5-15
*
* NOMANUAL

* STATUS fppProbeSup ()
*/

_fppProbeSup:
	link	a6,#0

	clrl	d0		/* set status to OK */

#if FPP_ASSEM
	fnop			/* benign coprocessor instruction */
#else
	.word	0xf280,0x0000	/* fnop */
#endif

	unlk	a6
	rts

/****************************************************************************
*
* fppProbeTrap - fppProbe support routine
*
* This entry point is momentarily attached to the coprocessor illegal opcode
* error exception vector.
* It simply sets d0 to ERROR to indicate that
* the illegal opcode error did occur, and returns from the interrupt.
*
* NOMANUAL
*/

_fppProbeTrap:			/* we get here via the coprocessor illegal
				 * opcode error trap */

	addl	#4,a7@(2)	/* change PC to next instruction */
	movel	#-1,d0		/* set status to ERROR */
	rte			/* return to the subroutine */
