/* if_pn_s.s - proNet-80 assembly language support routines */

    .data
    .asciz  "Copyright 1987-1988, Wind River Systems, Inc."

/* @(#)if_pn_s.s	1.1 7/17/86	(c) 1986 Proteon, Inc. */


/*
modification history
--------------------
*/


#define ASMLANGUAGE
#include "UniWorks.h"
#include "asm.h"


    .globl	_movep

    .text
    .even


/*******************************************************************************
*
* movep - move bytes into destination
*
* RETURNS: whether to start on a word

* BOOL movep (from, to, nbytes, flag)
*     char *from;	/* source *
*     char *to;		/* destination *
*     int nbytes;	/* number of bytes to copy *
*     BOOL flag;	/* true = start on word *

*/

_movep:
	movl	sp@(4),a0	/* "from" */
	movl	sp@(8),a1	/* "to" */
	movl	sp@(12),d0	/* "nbytes" */
	bles	1f		/* == 0, bye */
	clrl	d1
	tstl	sp@(16)		/* "flag" */
	beqs	2f
	movw	a0@+,a1@	/* copy first word */
	subql	#2,d0
2:
	btst	#1,d0		/* all longs? */
	beqs	3f
	movl	#1,d1		/* word ending */
3:
	lsrl	#2,d0		/* bytes -> longs */
	bras	5f
4:
	movl	a0@+,a1@	/* do copy */
5:
	dbra	d0,4b
	movl	d1,d0		/* return flag in d0 */
	beqs	1f
	movw	a0@,a1@		/* copy last word */
1:
	rts
