/* sniff.c */

static char *copyright = "Copyright 1988, Integrated Solutions, Inc.";

/* 
modification history
--------------------
*/

/*
DESCRIPTION
*/

#include "UniWorks.h"
#include "types.h"
#include "socket.h"
#include "in.h"
#include "if.h"
#include "if_ether.h"
#include "lstLib.h"
#include "memLib.h"
#include "strLib.h"
#include "sysLib.h"

LOCAL struct ifnet *ourIf;
struct ifnet   *ifunit();

extern FUNCPTR  etherInputHookRtn;
extern FUNCPTR  etherOutputHookRtn;
LOCAL FUNCPTR   old_etherInputHookRtn, old_etherOutputHookRtn;

sniffInit(If)
	char           *If;
{
	VOID            sniffPacketInput();
	VOID            sniffPacketOutput();
	if (If != NULL) {
		if ((ourIf = ifunit(If)) == NULL) {
			printf("couldn't find interface %s\n", If);
			return (ERROR);
		}
	} else
		ourIf = NULL;
	old_etherInputHookRtn = etherInputHookRtn;
	old_etherOutputHookRtn = etherOutputHookRtn;
	etherInputHookRtn = sniffPacketInput;
	etherOutputHookRtn = sniffPacketOutput;
	return (OK);
}

sniffStop()
{
	etherInputHookRtn = old_etherInputHookRtn;
	etherOutputHookRtn = old_etherOutputHookRtn;
	return (OK);
}


sniffPacketInput(pIf, pEh, len)
	struct ifnet   *pIf;
	struct ether_header *pEh;
	int             len;
{
	sniffPacket("I ", pIf, pEh, len);
	if (old_etherInputHookRtn)
		return ((*old_etherInputHookRtn) (pIf, pEh, len));
	else
		return (FALSE);
}

sniffPacketOutput(pIf, pEh, len)
	struct ifnet   *pIf;
	struct ether_header *pEh;
	int             len;
{
	sniffPacket("O ", pIf, pEh, len);
	if (old_etherOutputHookRtn)
		return ((*old_etherOutputHookRtn) (pIf, pEh, len));
	else
		return (FALSE);
}

sniffPacket(leader, pIf, pEh, len)
	char           *leader;
	struct ifnet   *pIf;
	struct ether_header *pEh;
	int             len;
{
	register char  *type;

	if (pIf == ourIf || ourIf == NULL) {
		printf(leader);
		printf("%s%d: ", pIf->if_name, pIf->if_unit);
		printf("S %02x:%02x:%02x:%02x:%02x:%02x ",
		       pEh->ether_shost[0], pEh->ether_shost[1],
		       pEh->ether_shost[2], pEh->ether_shost[3],
		       pEh->ether_shost[4], pEh->ether_shost[5]);
		printf("D %02x:%02x:%02x:%02x:%02x:%02x ",
		       pEh->ether_dhost[0], pEh->ether_dhost[1],
		       pEh->ether_dhost[2], pEh->ether_dhost[3],
		       pEh->ether_dhost[4], pEh->ether_dhost[5]);

		switch (pEh->ether_type) {
		case ETHERTYPE_AARP:
			type = "AARP";
			break;
		case ETHERTYPE_APPLETALK:
			type = "APPLETALK";
			break;
		case ETHERTYPE_ARP:
			type = "ARP";
			break;
		case ETHERTYPE_IP:
			type = "IP";
			break;
		case ETHERTYPE_ISIBOOT:
			type = "ISIBOOT";
			break;
		case ETHERTYPE_ISIBOOT_OLD:
			type = "ISIBOOT_OLD";
			break;
		case ETHERTYPE_NTRAILER:
			type = "NTRAILER";
			break;
		case ETHERTYPE_PUP:
			type = "PUP";
			break;
		case ETHERTYPE_REVARP:
			type = "REVARP";
			break;
		case ETHERTYPE_RFS:
			type = "RFS";
			break;
		case ETHERTYPE_TRAIL:
			type = "TRAIL";
			break;
		case ETHERTYPE_WIPC:
			type = "WIPC";
			break;
		default:
			type = "";
			break;
		}
		if (*type)
			printf("%-6s", type);
		else
			printf("0x%-4x", pEh->ether_type);
		printf("\n");
		return (FALSE);
	}
}
