/* dbgALib.s - debugging aids assembly language interface */

	.data
	.asciz	"Copyright 1984, Wind River Systems, Inc."

/*
modification history
--------------------
*/

/*
DESCRIPTION
This module contains assembly language routines needed for the debug
package and the 680x0 exception vectors.  There are no user-callable
routines here.
*/

#define ASMLANGUAGE
#include "UniWorks.h"

	/* internal */

	.globl	_dbgBpStub		/* breakpoint exceptions handler */
	.globl	_dbgTraceStub		/* trace exceptions handler */
	.globl	_dbgCacheEntryClear	/* 680{20,30} cache coherency routine */

	/* external */

	.globl	_dbgBreakpoint	/* breakpoint processing routine */
	.globl	_dbgTrace	/* trace processing routine */
	.globl	_intEnt		/* interrupt entry routine */
        .globl  _intExit	/* interrupt exit routine */

	.text
	.even

/****************************************************************************
*
* trap2 - breakpoint handling
*
* NOMANUAL
*/

_dbgBpStub:		/* breakpoint interrupt driver */
	moveml	d0-d7/a0-a7,a7@-	/* save regs */
	movel	a7,a5			/* a7 points to saved regs */
	link	a6,#0
	subql	#0x2,a6@(0x46)		/* adjust saved program counter */
	movel	a5,a7@-			/* push pointer to saved regs */
	pea	a6@(0x44)		/* push pointer to saved info */
	jsr	_dbgBreakpoint		/* do breakpoint handling */

/* we only return if the breakpoint was hit at interrupt level */

	addl	#8,a7			/* pop the params to dbgBreakpoint */
	unlk	a6
	moveml	a7@+,d0-d7/a0-a7	/* restore regs */
	rte

/**************************************************************************
*
* trace - trace exception processing
*
* NOMANUAL
*/

_dbgTraceStub:		/* trace interrupt driver */
	andw	#0x7fff,a7@		/* clear trace bit in saved status */
	moveml	d0-d7/a0-a7,a7@-	/* save regs */
	movel	a7,a5			/* a7 points to saved regs */
	link	a6,#0
	movel	a5,a7@-			/* push pointer to saved regs */
	pea	a6@(0x44)		/* push pointer to saved info */
	jsr	_dbgTrace

/* we returned from dbgTrace if this was a CONTINUE or the break was hit 
 * at interrupt level */

	addl	#8,a7			/* pop params to dbgTrace */
	unlk	a6
	moveml	a7@+,d0-d7/a0-a7	/* restore regs */
	rte

/*******************************************************************************
*
* dbgCacheEntryClear - clear address from the 68k instuction cache
*
* This c callable routine is used to clear the specified instruction address
* from the 68020/68030 instruction cache.
*
* NOMANUAL
*    This routine belongs in a library cacheLib? of cache routines.
*
* VOID dbgCacheEntryClear (address)
*     int address;         /* new value for cache address register *

*/

_dbgCacheEntryClear:

#if (CPU==MC68020 || CPU==MC68030)
	movel	a7@(0x4),d0		/* address to clear */

	/* Since the assemblers differ on the syntax for this one
	   (if they even have it), it's done with two .word's.  Yucko. */

	.word	0x4e7b, 0x0802		/* movec d0,caar */
	.word	0x4e7a, 0x0002		/* movec cacr,d0 */
	orl	#0x4,d0			/* set the clear entry bit */
	.word	0x4e7b, 0x0002		/* movec d0,cacr */ 

#endif (CPU==MC68020 || CPU==MC68030)

	rts
