/* xsym.c - extract symbol table from object module */

/*
modification history
--------------------
*/

/*
SYNOPSIS

xsym <objMod >symTbl

DESCRIPTION
This program reads an object module (a.out format) on standard in, and
writes an object module on standard out.  The output object module contains
only the symbol table, with no code, but is otherwise a normal, executable
object module (albeit with nothing to execute).

Xsym is used to generate the VxWorks symbol table, `UniWorks.sym'.

SEE ALSO: UNIX BSD 4.3 a.out documentation
*/

#ifdef	LINT
#include "UniWorks.h"
#include "stdioLib.h"
#else
#include <stdio.h>
#include "UniWorks.h"
#endif	LINT

#include "a_out.h"


/* The different systems use different names for the same info in some
   structures.  Make them the same here */

#define A_OUT_HDR exec
#define TEXTSIZE a_text
#define DATASIZE a_data
#define BSSSIZE a_bss
#define SYMSIZE a_syms
#define TRSIZE a_trsize
#define DRSIZE a_drsize
#define ENTRY a_entry

#define U_SYM_STRUCT nlist
#define U_SYM_TYPE n_type
#define U_SYM_VALUE n_value

LOCAL char usage [] = "usage: xsym <objMod >symTbl";


/*******************************************************************************
*
* main - extract system symbol table
*/

VOID main (argc)
    int argc;

    {
    struct A_OUT_HDR hdr;
    int n;
    int nbytes;
    char buffer [512];
    int fdin = fileno (stdin);
    int fdout = fileno (stdout);

    if (argc > 1)
	error (usage);

    /* read the header of the input file */

    if (read (fdin, (char *) &hdr, sizeof (hdr)) < sizeof (hdr))
	error ("Error reading header of input file");

    /* Seek to the symbol table on the input file */

    lseek (fdin, (long)N_SYMOFF (hdr), 0);

    /* create and write header on output file */

    hdr.TEXTSIZE	= 0;
    hdr.DATASIZE	= 0;
    hdr.BSSSIZE		= 0;
    hdr.TRSIZE		= 0;
    hdr.DRSIZE		= 0;
    hdr.ENTRY		= 0;

    if (write (fdout, (char *) &hdr, sizeof (hdr)) != sizeof (hdr))
	error ("Error writing output header");

    /* write out symbol table */

    nbytes = hdr.SYMSIZE;

    while (nbytes > 0)
	{
	if ((n = read (fdin, buffer, min (nbytes, sizeof (buffer)))) <= 0)
	    error ("Error reading symbol table");


	if (write (fdout, buffer, n) != n)
	    error ("Error writing data to output");

	nbytes -= n;
	}

    /* Write out the string table */

    while ((n = read (fdin, buffer, sizeof (buffer))) > 0)
	if (write (fdout, buffer, n) != n)
	    error ("Error writing data to output");
    }
/*******************************************************************************
*
* error - print error message and die
*
* This routine prints an error message on the standard error output and
* aborts the program with the error status ERROR.  The error message is
* output with the specified format with the single specified argument.
*
* VARARGS1
*/

VOID error (format, arg)
    char *format;	/* format of error message */
    char *arg;		/* argument supplied to format (arbitrary type!) */

    {
    fprintf (stderr, format, arg);
    fprintf (stderr, "\n");
    exit (ERROR);
    }
