/* hpToBsd.c - convert HP9000/300 a.out file to BSD */

/*
modification history
--------------------
*/

/*
SYNOPSIS
hpToBsd file

DESCRIPTION
This program convert the HP9000/300 a.out file to the BSD a.out file.

*/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#include "a.out.hp.h"
#include "a_out.h"
#include "UniWorks.h"

/*******************************************************************************
*
* main - read specified file and modify 
*/

VOID main (argc, argv)
    int argc;
    char *argv [];

    {
    struct exec_ h_;
    struct nlist_ *sym_;
    struct r_info_ *rel_;
    struct exec h;
    struct nlist *sym;
    struct relocation_info *rel;
    int bytes, i, symnum, rnum;
    int size_str, size_sym, size_rtext, size_rdata;
    char *buf, *symtbl, *symtbl_, *psym, *psym_, *strtbl, *pstr;
    char *rtext, *rtext_, *rdata, *rdata_, *pr, *pr_, *ped, *pen;
    FILE *fp;
    FILE *fopen();

    if (argc < 2)
	error ("usage: hpToBsd file");

    if ((fp = fopen (argv [1], "r+")) == NULL)
	error ("hpToBsd: can't open %s\n", argv [1]);

    /* read object module header */

    if (fread (&h_, sizeof (h_), 1, fp) != 1)
	error ("hpToBsd: error reading file header.");


/* header */
    if (h_.a_magic.file_type != 0x106 && h_.a_magic.file_type != 0x107)
    	error ("hpToBsd: error wrong magic number.");
    if ((buf = (char *)malloc(h_.a_text + h_.a_data)) == NULL)
    	error ("hpToBsd: error malloc text & data.");
    if (fread (buf, h_.a_text, 1, fp) != 1)
    	error ("hpToBsd: error reading text.");
    if (fseek (fp, DATA_OFFSET(h_), 0) != 0)
    	error ("hpToBsd: error seeking data_offset.");
    if (fread (buf+h_.a_text, h_.a_data, 1, fp) != 1)
    	error ("hpToBsd: error reading data.");

/* string table */
    if (h_.a_lesyms == 0) 
        {
    	size_sym = 0;
    	goto text_rel;
    	}
    if ((symtbl_ = (char *)malloc (h_.a_lesyms)) == NULL)
    	error ("hpToBsd: error malloc symtbl_.");
    if ((strtbl = (char *)malloc (h_.a_lesyms)) == NULL)
    	error ("hpToBsd: error malloc strtbl.");
    if (fseek (fp, LESYM_OFFSET(h_), 0) != 0)
    	error ("hpToBsd: error seeking lesym_offset.");
    if (fread (symtbl_, h_.a_lesyms, 1, fp) != 1)
    	error ("hpToBsd: error reading symbol table.");
    symnum = 0;
    pstr = strtbl + 4;
    psym_ = symtbl_;
    for (bytes = h_.a_lesyms; bytes > 0; bytes -= sizeof(struct nlist_) + sym_->n_length) 
	{
    	sym_ = (struct nlist_ *)psym_;
    	psym_ += sizeof (struct nlist_);
    	for (i=0; i<sym_->n_length; i++)
    	    *pstr++ = *psym_++;
    	*pstr++ = '\0';
    	symnum++;
    	}
    size_str = pstr - strtbl;
    *((int *)strtbl) = size_str;

/* symbol table */
    ped = "_edata";
    pen = "_end";
    size_sym = symnum * sizeof(struct nlist);
    if ((symtbl = (char *)malloc(size_sym)) == NULL)
    	error ("hpToBsd: error malloc symtbl.");
    psym_ = symtbl_;
    psym = symtbl;
    pstr = strtbl + 4;
    for (i=0; i<symnum; i++) 
	{
    	sym_ = (struct nlist_ *)psym_;
    	sym = (struct nlist *)psym;
    	sym->n_type = (sym_->n_type & 0x7) * 2;
    	if (sym_->n_type & 0x20) 
	    {
    	    sym->n_type |= 0x1;
    	    }
    	if (i == 0)
    	    sym->n_un.n_strx = 4;
    	else
    	    sym->n_un.n_strx = pstr - strtbl;
    	sym->n_other = 0;
    	sym->n_desc = 0;
    	sym->n_value = sym_->n_value;
    	psym += sizeof(struct nlist);
    	psym_ += sizeof(struct nlist_) + sym_->n_length;
    	for (; *pstr != '\0'; pstr++);
    	pstr++;
#ifdef DEBUG
    	sym_print(sym,strtbl);
#endif
    	}
    
/* text relocation */
text_rel:
    if (h_.a_trsize == 0) 
	{
    	size_rtext = 0;
    	goto data_rel;
    	}
    rnum = h_.a_trsize / sizeof(struct r_info_);
    size_rtext = rnum * sizeof(struct relocation_info);
    if ((rtext = (char *)malloc(size_rtext)) == NULL)
    	error ("hpToBsd: error malloc rtext.");
    if ((rtext_ = (char *)malloc(h_.a_trsize)) == NULL)
    	error ("hpToBsd: error malloc rtext_.");
    if (fseek(fp, RTEXT_OFFSET(h_), 0) != 0)
    	error ("hpToBsd: error seeking rtext_offset.");
    if (fread (rtext_, h_.a_trsize, 1, fp) != 1)
    	error ("hpToBsd: error reading text relocation.");
    symnum = 0;
    pr = rtext;
    pr_ = rtext_;
    for (i=0; i<rnum; i++) 
	{
    	rel_ = (struct r_info_ *)pr_;
    	rel = (struct relocation_info *)pr;
    	rel->r_address = rel_->r_address;
    	rel->r_symbolnum = rel_->r_symbolnum;
    	rel->r_pcrel = 0;
    	rel->r_length = rel_->r_length;
    	if(rel_->r_segment == 0x3)
    	    rel->r_extern = 1;
    	else 
	    {
    	    rel->r_extern = 0;
    	    rel->r_symbolnum = (rel_->r_segment + 2) * 2;
    	    }
    	pr += sizeof(struct relocation_info);
    	pr_ += sizeof(struct r_info_);
#ifdef DEBUG
    	rel_print(rel,symtbl,strtbl);
#endif
    	}

/* data relocation */
data_rel:
    if (h_.a_drsize == 0) 
	{
    	size_rdata = 0;
    	goto header;
    	}
    rnum = h_.a_drsize / sizeof(struct r_info_);
    size_rdata = rnum * sizeof(struct relocation_info);
    if ((rdata = (char *)malloc(size_rdata)) == NULL)
    	error ("hpToBsd: error malloc rdata.");
    if ((rdata_ = (char *)malloc(h_.a_drsize)) == NULL)
    	error ("hpToBsd: error malloc rdata_.");
    if (fseek(fp, RDATA_OFFSET(h_), 0) != 0)
    	error ("hpToBsd: error seeking rdata_offset.");
    if (fread (rdata_, h_.a_drsize, 1, fp) != 1)
    	error ("hpToBsd: error reading data relocation.");
    pr = rdata;
    pr_ = rdata_;
    for (i=0; i<rnum; i++) 
	{
    	rel_ = (struct r_info_ *)pr_;
    	rel = (struct relocation_info *)pr;
    	rel->r_address = rel_->r_address;
    	rel->r_symbolnum = rel_->r_symbolnum;
    	rel->r_pcrel = 0;
    	rel->r_length = rel_->r_length;
    	if(rel_->r_segment == 0x3)
    	    rel->r_extern = 1;
    	else 
	    {
    	    rel->r_extern = 0;
    	    rel->r_symbolnum = (rel_->r_segment + 2) * 2;
    	    }
    	pr += sizeof(struct relocation_info);
    	pr_ += sizeof(struct r_info_);
#ifdef DEBUG
    	rel_print(rel,symtbl,strtbl);
#endif
    	}

/* header */
header:
    h.a_magic = 0x107;
    h.a_text = h_.a_text;
    h.a_data = h_.a_data;
    h.a_bss = h_.a_bss;
    h.a_syms = size_sym;
    h.a_entry = h_.a_entry;
    h.a_trsize = size_rtext;
    h.a_drsize = size_rdata;

    if (fseek (fp, 0L, 0) != 0)
        error ("hpToBsd: error seeking rdata_offset.");

    if (fwrite (&h, sizeof (h), 1, fp) != 1)
        error ("hpToBsd: error writing file header.");

    if (fwrite (buf, h.a_text + h.a_data, 1, fp) != 1)
        error ("hpToBsd: error writing text & data header.");
    free (buf);

    if (size_rtext != 0) 
	{
        if (fwrite (rtext, size_rtext, 1, fp) != 1)
    	    error ("hpToBsd: error writing text relocation.");
    	free (rtext);
    	free (rtext_);
        }

    if (size_rdata != 0) 
	{
        if (fwrite (rdata, size_rdata, 1, fp) != 1)
    	    error ("hpToBsd: error writing data relocation.");
    	free (rdata);
    	free (rdata_);
        }

    if (size_sym != 0) 
	{
    	if (fwrite (symtbl, size_sym, 1, fp) != 1)
    	    error ("hpToBsd: error writing symbol table.");
    	if (fwrite (strtbl, size_str, 1, fp) != 1)
    	    error ("hpToBsd: error writing string table.");
    	free (symtbl);
    	free (symtbl_);
    	free (strtbl);
        }

    fclose (fp);

    exit (OK);

}
    	
/*******************************************************************************
*
* error - print error message and die
*
* This routine prints an error message on the standard error output and
* aborts the program with the error status ERROR.  The error message is
* output with the specified format with the single specified argument.
*
* VARARGS1
*/

VOID error (format, arg)
    char *format;	/* format of error message */
    char *arg;		/* argument supplied to format (arbitrary type!) */

    {
    fprintf (stderr, format, arg);
    fprintf (stderr, "\n");
    exit (ERROR);
    }


#ifdef DEBUG
VOID sym_print(sym,strtbl)
    struct nlist *sym;
    char *strtbl;

    {
    printf ("<%s>\t",strtbl+sym->n_un.n_strx);
    printf ("value=0x%x\t",sym->n_value);
    printf ("type=0x%x\t",sym->n_type);
    if (sym->n_type & N_STAB)
    	printf ("STAB");
    else if ((sym->n_type & N_FN) == N_FN)
    	printf ("FN");
    else {
    	if (sym->n_type & 0x1)
    	    printf ("EXT ");
    	switch (sym->n_type & 0x1e) 
	    {
    	    case 0x0:
    		printf ("UNDEF"); break;
    	    case 0x2:
    		printf ("ABS"); break;
    	    case 0x4:
    		printf ("TEXT"); break;
    	    case 0x6:
    		printf ("DATA"); break;
    	    case 0x8:
    		printf ("BSS"); break;
    	    case 0x12:
    		printf ("COMM"); break;
    	    }
    	}
        printf ("\t");

        printf ("un.n_strx=%d\t",sym->n_un.n_strx);
        printf ("desc=0x%x\n",sym->n_desc);
    }
    
VOID rel_print(rel,symtbl,strtbl)
    struct relocation_info *rel;
    struct nlist *symtbl;
    char *strtbl;

    {
    if (rel->r_extern)
    	printf ("<%s>\n",strtbl+symtbl[rel->r_symbolnum].n_un.n_strx);
    else
    	printf ("<>\n");
    printf ("address=0x%x\t",rel->r_address);
    printf ("symbolnum=%d\t",rel->r_symbolnum);
    printf ("pcrel=%d\t",rel->r_pcrel);
    printf ("length=%d\t",rel->r_length);
    printf ("extern=%d\n",rel->r_extern);
    }
#endif
