/* xdr_nfs.h - xdr for nfs structures */

/*
modification history
--------------------
01a,19apr88,llk  created.
*/

#define NFS_PORT 2049
#define MOUNTPROG 100005
#define MOUNTVERS 1
#define NFSPROG 100003
#define NFSVERS 2
#define NFS_MNTPATHLEN 1024
#define NFS_MNTNAMLEN 255
#define NFS_MAXDATA 8192
#define NFS_MAXPATHLEN 1024
#define NFS_MAXNAMLEN 255
#define NFS_MAXDIRNAMES 255
#define NFS_COOKIESIZE 4
#define NFS_FHSIZE 32

enum nfsstat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_WFLUSH = 99,
};
typedef enum nfsstat nfsstat;
bool_t xdr_nfsstat();


enum ftype {
	NFNON = 0,
	NFREG = 1,
	NFDIR = 2,
	NFBLK = 3,
	NFCHR = 4,
	NFLNK = 5,
};
typedef enum ftype ftype;
bool_t xdr_ftype();


struct timeval {
	u_int tv_sec;
	u_int tv_usec;
};
typedef struct timeval timeval;
bool_t xdr_timeval();


struct fattr {
	ftype type;
	u_int mode;
	u_int nlink;
	u_int uid;
	u_int gid;
	u_int size;
	u_int blocksize;
	u_int rdev;
	u_int blocks;
	u_int fsid;
	u_int fileid;
	timeval atime;
	timeval mtime;
	timeval ctime;
};
typedef struct fattr fattr;
bool_t xdr_fattr();


struct sattr {
	u_int mode;
	u_int uid;
	u_int gid;
	u_int size;
	timeval atime;
	timeval mtime;
};
typedef struct sattr sattr;
bool_t xdr_sattr();


typedef char *filename;
bool_t xdr_filename();


typedef char *path;
bool_t xdr_path();


struct pathstat {
	nfsstat status;
	union {
		path name;
	} pathstat_u;
};
typedef struct pathstat pathstat;
bool_t xdr_pathstat();


struct attrstat {
	nfsstat status;
	union {
		fattr attributes;
	} attrstat_u;
};
typedef struct attrstat attrstat;
bool_t xdr_attrstat();


struct nfs_fh {
	char data[NFS_FHSIZE];
};
typedef struct nfs_fh nfs_fh;
bool_t xdr_nfs_fh();


struct diropargs {
	nfs_fh dir;
	filename name;
};
typedef struct diropargs diropargs;
bool_t xdr_diropargs();


struct sattrargs {
	nfs_fh file;
	sattr attributes;
};
typedef struct sattrargs sattrargs;
bool_t xdr_sattrargs();


struct finfo {
	nfs_fh file;
	fattr attributes;
};
typedef struct finfo finfo;
bool_t xdr_finfo();


struct diropres {
	nfsstat status;
	union {
		finfo finfo;
	} diropres_u;
};
typedef struct diropres diropres;
bool_t xdr_diropres();


struct readresult {
	fattr attributes;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct readresult readresult;
bool_t xdr_readresult();


struct readreply {
	nfsstat status;
	union {
		readresult rdresult;
	} readreply_u;
};
typedef struct readreply readreply;
bool_t xdr_readreply();


struct readargs {
	nfs_fh file;
	u_int offset;
	u_int count;
	u_int totalcount;
};
typedef struct readargs readargs;
bool_t xdr_readargs();


struct writeargs {
	nfs_fh file;
	u_int beginoffset;
	u_int offset;
	u_int totalcount;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct writeargs writeargs;
bool_t xdr_writeargs();


struct createargs {
	diropargs dirargs;
	sattr attributes;
};
typedef struct createargs createargs;
bool_t xdr_createargs();


typedef char nfscookie[NFS_COOKIESIZE];
bool_t xdr_nfscookie();


struct renameargs {
	diropargs from;
	diropargs to;
};
typedef struct renameargs renameargs;
bool_t xdr_renameargs();


struct readdirargs {
	nfs_fh dir;
	nfscookie cookie;
	u_int count;
};
typedef struct readdirargs readdirargs;
bool_t xdr_readdirargs();


struct entry {
	u_int fileid;
	filename name;
	nfscookie cookie;
	struct entry *nextentry;
};
typedef struct entry entry;
bool_t xdr_entry();


struct dirlist {
	entry *entries;
	bool_t eof;
};
typedef struct dirlist dirlist;
bool_t xdr_dirlist();


struct readdirres {
	nfsstat status;
	union {
		dirlist reply;
	} readdirres_u;
};
typedef struct readdirres readdirres;
bool_t xdr_readdirres();


typedef char *dirpath;
bool_t xdr_dirpath();


typedef char *name;
bool_t xdr_name();


struct fhstatus {
	u_int status;
	union {
		nfs_fh directory;
	} fhstatus_u;
};
typedef struct fhstatus fhstatus;
bool_t xdr_fhstatus();


struct mountlist {
	name hostname;
	dirpath directory;
	struct mountlist *nextentry;
};
typedef struct mountlist mountlist;
bool_t xdr_mountlist();


struct mountentries {
	bool_t more_entries;
	union {
		mountlist mntlist;
	} mountentries_u;
};
typedef struct mountentries mountentries;
bool_t xdr_mountentries();


struct groups {
	name grname;
	struct groups *nextgroup;
};
typedef struct groups groups;
bool_t xdr_groups();


struct exports {
	dirpath filesys;
	groups *grouplist;
	struct exports *nextexport;
};
typedef struct exports exports;
bool_t xdr_exports();


struct exportbody {
	bool_t more_entries;
	union {
		exports export;
	} exportbody_u;
};
typedef struct exportbody exportbody;
bool_t xdr_exportbody();

