/* vrtx32.h - VRTX32 interface library header */

/*
modification history
--------------------
01c,24aug88,gae  changed VX_ types to VRTX_.
01b,13may88,rdc  added format field to TCB_STACK.
01a,24mar88,ecs  modified from vrtx.h.
*/

#ifndef	INCvrtx32h
#define	INCvrtx32h

#include "vwModNum.h"
#include "taskLib.h"

/* status codes */

#define S_vrtx_TASK_ID_ERROR		(M_vrtx | 1)
#define S_vrtx_NO_TCBS_AVAILABLE	(M_vrtx | 2)
#define S_vrtx_NO_MEMORY_AVAILABLE	(M_vrtx | 3)
#define S_vrtx_NOT_A_MEMORY_BLOCK	(M_vrtx | 4)
#define S_vrtx_MAILBOX_IN_USE		(M_vrtx | 5)
#define S_vrtx_ZERO_MESSAGE		(M_vrtx | 6)
#define S_vrtx_BUFFER_FULL		(M_vrtx | 7)
#define S_vrtx_WAITC_IN_PROGRESS	(M_vrtx | 8)
#define S_vrtx_INVALID_SYSTEM_CALL	(M_vrtx | 9)
#define S_vrtx_TIMEOUT			(M_vrtx | 10)
#define S_vrtx_NO_MESSAGE_PRESENT	(M_vrtx | 11)
#define S_vrtx_QUEUE_ID_ERROR		(M_vrtx | 12)
#define S_vrtx_QUEUE_FULL		(M_vrtx | 13)
#define S_vrtx_PARTITION_ID_ERROR	(M_vrtx | 14)
#define S_vrtx_INSUFFICIENT_WORKSPACE	(M_vrtx | 15)
#define S_vrtx_NO_CHARACTER_PRESENT	(M_vrtx | 16)
#define S_vrtx_INVALID_CONFIG_TAB_PARAM	(M_vrtx | 17)
#define S_vrtx_INVALID_INPUT_PARAMETER	(M_vrtx | 18)
#define S_vrtx_NO_COMPONENT_VECTOR_TAB	(M_vrtx | 32)
#define S_vrtx_UNDEFINED_COMPONENT	(M_vrtx | 33)
#define S_vrtx_UNDEFINED_OPCODE		(M_vrtx | 34)
#define S_vrtx_NO_CONTROL_BLOCKS_AVAIL	(M_vrtx | 48)
#define S_vrtx_SEMAPHORE_ID_ERROR	(M_vrtx | 49)
#define S_vrtx_TASKS_PENDING_ON_SEM	(M_vrtx | 50)
#define S_vrtx_SEMAPHORE_IS_DELETED	(M_vrtx | 51)
#define S_vrtx_SEMAPHORE_OVERFLOW	(M_vrtx | 52)


typedef struct vrtx_tcb		/* VX_TCB */
    {
    struct vrtx_tcb32 *tcb_nextR;/* pointer to next tcb on ready/pend list */
    struct vrtx_tcb32 *tcb_prevR;/* pointer to prev tcb on ready/pend list */
    TCBX *tcb_extension;	/* pointer to tcb extension */
    unsigned char tcb_priority;	/* task priority */
    unsigned char tcb_id;	/* task id */
    short tcb_status;		/* task status */
    int tcb_data_regs [6];	/* data regs 0-5 */
    int tcb_adrs_regs [4];	/* address regs 0-3 */
    char *tcb_sp;		/* saved system stack pointer */
    char *tcb_usp;		/* saved user stack pointer */
    ULONG tcb_reserved;		/* original stack pointer */
    short tcb_flags;		/* VRTX internal flags */
    } VX_TCB;

typedef struct vrtx_tcb32	/* VX_TCB32 - VRTX32's super-TCB */
    {
    struct vrtx_tcb32 *t32_chain;	/* for hash collisions */
    int t32_delay;			/* delay/timeout ticks */
    struct vrtx_tcb32 *t32_nextD;	/* ptr to next tcb on delay list */
    struct vrtx_tcb32 *t32_prevD;	/* ptr to prev tcb on delay list */
    ULONG t32_priority;		/* task priority, with more bits */
    VX_TCB t32_tcb;		/* the tcb we've come to know and love */
    struct vrtx_tcb32 *t32_next;/* pointer to next tcb on active list */
    struct vrtx_tcb32 *t32_prev;/* pointer to previous tcb on active list */
    } VX_TCB32;


/* VRTX32 configuration table */

typedef struct		/* VRTX_CONFIG_TABLE */
    {
    char *wrkspcAdrs;		/* VRTX32 RAM address */
    int wrkspcSize;		/* VRTX32 RAM size */
    short sysStackSize;		/* system stack size */
    short isrStackSize;		/* interrupt service routine stack size */
    short ctlBlkCount;		/* max # of semaphores & event flag groups */
    short blank1;		/* reserved by VRTX32 MUST BE SET TO 0 */
    int blank2;			/* reserved by VRTX32 MUST BE SET TO 0 */
    short vrtxDisableMask;	/* VRTX32 disable mask */
    short usrStackSize;		/* user stack size */
    int blank3;			/* reserved by VRTX32 MUST BE SET TO 0 */
    short maxTasks;		/* user task count (max tasks) */
    short blank4;		/* reserved by VRTX32 MUST BE SET TO 0 */
    FUNCPTR txrdyDriver;	/* Supported IO device driver */
    FUNCPTR tskCreate;		/* task create routine */
    FUNCPTR tskDelete;		/* task delete routine */
    FUNCPTR tskSwitch;		/* task swap routine */
    char *cvt;			/* component vector table address */
    } VRTX_CONFIG_TABLE;

typedef struct		/* TCB_STACK - task's regs that get put on the stack */
    {
    int d6;
    int d7;
    int a4;
    int a5;
    int a6;
    short sr;
    INSTR *pc;
    short format;
    } TCB_STACK;

/* task status values VRTX */

#define VRTX_READY	0x00	/* ready */
#define VRTX_SUSPEND	0x01	/* explicitly suspended */
#define VRTX_PEND	0x02	/* suspended for message */
#define VRTX_GETC	0x04	/* suspended for input */
#define VRTX_PUTC	0x08	/* suspended for output */
#define VRTX_WAITC	0x10	/* awaiting special character */
#define VRTX_DELAY	0x20	/* suspended for task delay (or timeout) */
#define VRTX_QPEND	0x40	/* suspended on queue */
#define VRTX_IDLE	0x100	/* idle task */
#define VRTX_FLAG	0x200	/* suspended on event flag group */
#define VRTX_SEMAPHORE	0x400	/* suspended on semaphore */

#endif	INCvrtx32h
