/* sysLib.h - system dependent routines header */

/*
modification history
--------------------
01h,24mar88,ecs  added declaration of sysExcMsg.
01g,13nov87,jcf  changed names of boot types.
01f,29oct87,dnw  added SYSFLG_DEBUG.
01e,14oct87,dnw  added SYSFLG_NO_SYS_CONTROLLER.
01d,14jul87,dnw  added more system global varaibles.
		 deleted sysLocalToBusAdrs().
		 added system restart types.
01c,14feb87,dnw  added sysBus, sysCpu, sysLocalToBusAdrs
01b,18dec86,llk  added BOOT_FIELD_LEN.
01a,04aug84,dnw  written
*/

#ifndef INCsysLibh
#define INCsysLibh	1


/* system restart types */

#define BOOT_WARM_AUTOBOOT	0
#define BOOT_WARM_NO_AUTOBOOT	1
#define BOOT_COLD		2


/* length of boot command fields, used for buffers */

#define BOOT_FIELD_LEN	70


/* system configuration flags in sysFlags */

#define SYSFLG_NO_SYS_CONTROLLER 0x01	/* For targets that have sys controllers
					 * that can be enabled in software,
					 * the sys controller is enabled for
					 * processor 0.  This flag inhibits
					 * enabling the sys controller even for
					 * processor 0.
					 */
#define SYSFLG_DEBUG             0x02	/* system debug option -
					 *   load kernel symbol table with all
					 *   symbols (not just globals) */


/* system parameters */

#ifndef ASMLANGUAGE

IMPORT int sysBus;		/* system bus type (VME_BUS, MULTI_BUS, etc) */
IMPORT int sysCpu;		/* system cpu type (MC680x0) */
IMPORT int sysProcNum;		/* processor number of this cpu */
IMPORT char *sysBootLine;	/* address of boot line */
IMPORT char *sysExcMsg;		/* address of exception message area */
IMPORT int sysFlags;		/* configuration flags */
IMPORT char sysBootHost[];	/* name of host from which system was booted */
IMPORT char sysBootFile[];	/* name of file from which system was booted */

/* function declarations */

IMPORT char *sysMemTop ();

#endif ASMLANGUAGE

#endif
