/* symLib.h - symbol table subroutine library header */

/*
modification history
--------------------
02d,30may88,dnw  changed to v4 names.
02c,24dec86,gae  changed stsLib.h to vwModNum.h.
02b,05jun86,dnw  changed SYMTAB structure to have ptr to symbol array
		   instead of imbedded array.
02a,11oct85,dnw  changed SYMTAB structure to have maxSymbols instead of
		   string table pool pointer.
		 deleted obsolete definition of MAX_SYM_LENGTH.
01g,11jun85,rdc  added maxSymLength and free to the SYMTAB structure.
		 These were necessary
		 for variable symbol length.
01f,13aug84,ecs  deleted status code S_sysLib_EMPTY_SYMBOL_TABLE.
01e,08aug84,ecs  added include of stsLib.h, symLib status codes.
01d,27jun84,ecs  changed length of name in SYMBOL to allow room for EOS.
01c,15jun84,dnw  moved typedefs for SYMBOL and SYMTAB here from symLib.c.
		 added typedef for SYMTAB_ID.
01b,27jan84,ecs  added inclusion test.
01a,03aug83,dnw  written
*/

#ifndef INCsymLibh
#define INCsymLibh	1

#include "vwModNum.h"


/* symLib status codes */

#define S_symLib_FULL_SYMBOL_TABLE	(M_symLib | 1)
#define S_symLib_SYMBOL_NOT_FOUND	(M_symLib | 2)

/* HIDDEN */

typedef struct		/* SYMBOL - entry in symbol table */
    {
    char *name;				/* pointer to symbol name */
    char *adrs;				/* symbol address */
    TINY type;				/* symbol type (text, data, bss) */
    } SYMBOL;

typedef struct		/* SYMTAB - symbol table */
    {
    short nsymbols;		/* current number of symbols in table */
    short maxSymbols;		/* maximum number of symbols in table */
    short maxSymLen;		/* maximum symbol length */
    SYMBOL *symbols;		/* ptr to array of symbol entries */
    } SYMTAB;

/* END_HIDDEN */

typedef SYMTAB *SYMTAB_ID;

SYMTAB_ID symTblCreate ();

#endif
