/* sigLib.h - signal facility library header */

/*
modification history
--------------------
01e,01jul88,rdc  changed SEM_ID's back to SEMAPHORE's.
01d,17jun88,rdc  added sigMaskSem to TASK_SIGNAL_INFO.
01c,29may88,dnw  added status valude S_sigLib_NO_HANDLER_FOR_SIGNAL.
01b,24may88,gae  added declaration of sigTaskVecGet(), cleanup.
	   +ecs
01a,12apr88,rdc  written.
*/

#ifndef INCsigLibh
#define INCsigLibh

#include "semLib.h"

/* status values */

#define S_sigLib_NO_HANDLER_FOR_SIGNAL		(M_sigLib | 1)

/* signals and codes */

#define NUM_SIGNALS 32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
#define     ILL_ILLINSTR_FAULT	0x10	/* illegal instruction fault */
#define     ILL_PRIVVIO_FAULT	0x20	/* privilege violation fault */
#define     ILL_COPROCERR_FAULT	0x34	/* [coprocesser protocol error fault] */
#define     ILL_TRAP1_FAULT	0x84	/* trap #1 fault */
#define     ILL_TRAP2_FAULT	0x88	/* trap #2 fault */
#define     ILL_TRAP3_FAULT	0x8c	/* trap #3 fault */
#define     ILL_TRAP4_FAULT	0x90	/* trap #4 fault */
#define     ILL_TRAP5_FAULT	0x94	/* trap #5 fault */
#define     ILL_TRAP6_FAULT	0x98	/* trap #6 fault */
#define     ILL_TRAP7_FAULT	0x9c	/* trap #7 fault */
#define     ILL_TRAP8_FAULT	0xa0	/* trap #8 fault */
#define     ILL_TRAP9_FAULT	0xa4	/* trap #9 fault */
#define     ILL_TRAP10_FAULT	0xa8	/* trap #10 fault */
#define     ILL_TRAP11_FAULT	0xac	/* trap #11 fault */
#define     ILL_TRAP12_FAULT	0xb0	/* trap #12 fault */
#define     ILL_TRAP13_FAULT	0xb4	/* trap #13 fault */
#define     ILL_TRAP14_FAULT	0xb8	/* trap #14 fault */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define     EMT_EMU1010		0x28	/* line 1010 emulator trap */
#define     EMT_EMU1111		0x2c	/* line 1111 emulator trap */
#define	SIGFPE	8	/* floating point exception */
#define     FPE_INTDIV_TRAP	0x14	/* integer divide by zero */
#define     FPE_CHKINST_TRAP	0x18	/* CHK [CHK2] instruction */
#define     FPE_TRAPV_TRAP	0x1c	/* TRAPV [cpTRAPcc TRAPcc] instr */
#define     FPE_FLTBSUN_TRAP	0xc0	/* [branch or set on unordered cond] */
#define     FPE_FLTINEX_TRAP	0xc4	/* [floating inexact result] */
#define     FPE_FLTDIV_TRAP	0xc8	/* [floating divide by zero] */
#define     FPE_FLTUND_TRAP	0xcc	/* [floating underflow] */
#define     FPE_FLTOPERR_TRAP	0xd0	/* [floating operand error] */
#define     FPE_FLTOVF_TRAP	0xd4	/* [floating overflow] */
#define     FPE_FLTNAN_TRAP	0xd8	/* [floating Not-A-Number] */
#define     FPE_FPA_ENABLE	0x400	/* [FPA not enabled] */
#define     FPE_FPA_ERROR	0x404	/* [FPA arithmetic exception] */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	    BUS_BUSERR		0x01	/* 68000 BUS ERROR */
#define     BUS_ADDERR		0x02	/* 68000 ADDRESS ERROR */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGFMT	12	/* 68000 STACK FORMAT ERROR */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGURG	16	/* urgent condition on IO channel */
#define	SIGSTOP	17	/* sendable stop signal not from tty */
#define	SIGTSTP	18	/* stop signal from tty */
#define	SIGCONT	19	/* continue a stopped process */
#define	SIGCHLD	20	/* to parent on child stop or exit */
#define	SIGCLD	20	/* System V name for SIGCHLD */
#define	SIGTTIN	21	/* to readers pgrp upon background tty read */
#define	SIGTTOU	22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define	SIGIO	23	/* input/output possible signal */
#define	SIGPOLL	SIGIO	/* System V name for SIGIO */
#define	SIGXCPU	24	/* exceeded CPU time limit */
#define	SIGXFSZ	25	/* exceeded file size limit */
#define	SIGVTALRM 26	/* virtual time alarm */
#define	SIGPROF	27	/* profiling time alarm */
#define	SIGWINCH 28	/* window changed */
#define	SIGLOST 29	/* resource lost (eg, record-lock lost) */
#define SIGUSR1 30	/* user defined signal 1 */
#define SIGUSR2 31	/* user defined signal 2 */


struct sigvec		/* signal vector "template" used in sigvec call */
    {
    FUNCPTR sv_handler;		/* signal handler */
    int	sv_mask;		/* signal mask to apply */
    int	sv_flags;		/* signal options */
    };

typedef struct sigvec SIGVEC;

/* values for sv_flags */

#define SV_ONSTACK	0x0001	/* take signal on signal stack */

struct sigstack		/* used in sigstack call */
    {
    char *ss_sp;		/* signal stack pointer */
    int	ss_onstack;		/* current status */
    };

typedef struct sigstack SIGSTACK;


/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */

struct sigcontext	/* pushed on stack when signal delivered */
    {
    int	sc_onstack;		/* sigstack state to restore */
    int	sc_mask;		/* signal mask to restore */
    int	sc_sp;			/* sp to restore */
    int	sc_pc;			/* pc to retore */
    int	sc_ps;			/* psl to restore (status reg) */
    int sc_aregs [7];		/* address registers */
    int sc_dregs [8];		/* data registers */
    };

typedef struct sigcontext SIGCONTEXT;

/* Macro for converting signal number to a mask suitable for sigblock() */
#define SIGMASK(m)	(1 << ((m)-1))

/* function declarations */

IMPORT SIGVEC *sigTaskVecGet ();


/* HIDDEN */

typedef struct		/* TASK_SIGNAL_INFO */
    {
    SIGVEC sigHandlers [32];
    SEMAPHORE sigMaskSem;	/* mut. excl. for sigMask and sigPendingMask */
    int sigMask;
    int sigPendingMask;
    SEMAPHORE sigPauseSem;
    BOOL taskPaused;
    SIGSTACK sigStack;
    } TASK_SIGNAL_INFO;

/* END_HIDDEN */

#endif	INCsigLibh
