/* psos.h - header for pSOS interface library */

/*
modification history
--------------------
01d,03jun88,jcf  fixed defines for event masks.
01c,28may88,jcf  added defines for exchange and event masks.
01b,21apr88,llk  added dummy field to XCB so compiler doesn't choke.
01a,24aug87,jcf  written
*/

#ifndef INCpsosh
#define INCpsosh	1

#include "vwModNum.h"
#include "taskLib.h"

/* status codes */

#define S_psos_SPAWN_P_NO_PCBS_AVAILABLE		(M_psos | 0x0101)
#define S_psos_SPAWN_P_CANNOT_ALLOCATE_STACK		(M_psos | 0x0102)
#define S_psos_SPAWN_P_STACK_CANNOT_HOLD_ARGLIST	(M_psos | 0x0103)
#define S_psos_SPAWN_P_PRIORITY_ZERO_RESERVED		(M_psos | 0x0104)

#define S_psos_ACTIVATE_P_PROCESS_DELETED		(M_psos | 0x0201)
#define S_psos_ACTIVATE_P_TASK_ID_NOT_FOUND		(M_psos | 0x0202)
#define S_psos_ACTIVATE_P_NOT_IN_SAME_GROUP		(M_psos | 0x0203)
#define S_psos_ACTIVATE_P_ALREADY_ACTIVATED		(M_psos | 0x0205)

#define S_psos_IDENT_P_NAME_NOT_FOUND			(M_psos | 0x0301)

#define S_psos_DELETE_P_ALREADY_DELETED			(M_psos | 0x0401)
#define S_psos_DELETE_P_TASK_ID_NOT_FOUND		(M_psos | 0x0402)
#define S_psos_DELETE_P_GROUP_VIOLATION			(M_psos | 0x0403)
#define S_psos_DELETE_P_FILES_OPEN			(M_psos | 0x0405)

#define S_psos_SUSPEND_P_PROCESS_DELETED		(M_psos | 0x0501)
#define S_psos_SUSPEND_P_TASK_ID_NOT_FOUND		(M_psos | 0x0502)
#define S_psos_SUSPEND_P_GROUP_VIOLATION		(M_psos | 0x0503)
#define S_psos_SUSPEND_P_ALREADY_SUSPENDED		(M_psos | 0x0504)

#define S_psos_RESUME_P_PROCESS_DELETED			(M_psos | 0x0601)
#define S_psos_RESUME_P_TASK_ID_NOT_FOUND		(M_psos | 0x0602)
#define S_psos_RESUME_P_GROUP_VIOLATION			(M_psos | 0x0603)
#define S_psos_RESUME_P_PROCESS_NOT_SUSPENDED		(M_psos | 0x0604)

#define S_psos_PRIORITY_P_PROCESS_DELETED		(M_psos | 0x0701)
#define S_psos_PRIORITY_P_TASK_ID_NOT_FOUND		(M_psos | 0x0702)
#define S_psos_PRIORITY_P_GROUP_VIOLATION		(M_psos | 0x0703)
#define S_psos_PRIORITY_P_OVERFLOW			(M_psos | 0x0780)
#define S_psos_PRIORITY_P_UNDERFLOW			(M_psos | 0x0781)

#define S_psos_ALLOC_SEG_PARAMETRIC_ERROR		(M_psos | 0x0802)
#define S_psos_ALLOC_SEG_NO_FREE_SEG			(M_psos | 0x0880)
#define S_psos_ALLOC_SEG_TIMED_OUT			(M_psos | 0x0881)

#define S_psos_FREE_SEG_NOT_OWNER			(M_psos | 0x0901)
#define S_psos_FREE_SEG_BAD_ADDRESS			(M_psos | 0x0905)

#define S_psos_ASSIGN_SEG_NOT_OWNER			(M_psos | 0x0a01)
#define S_psos_ASSIGN_SEG_TASK_NOT_FOUND		(M_psos | 0x0a02)
#define S_psos_ASSIGN_SEG_GROUP_VIOLATION		(M_psos | 0x0a03)
#define S_psos_ASSIGN_SEG_BAD_ADDRESS			(M_psos | 0x0a05)

#define S_psos_GRAB_SEG_NOT_OWNER			(M_psos | 0x1001)
#define S_psos_GRAB_TASK_NOT_FOUND			(M_psos | 0x1002)
#define S_psos_GRAB_GROUP_VIOLATION			(M_psos | 0x1003)
#define S_psos_GRAB_BAD_ADDRESS				(M_psos | 0x1005)

#define S_psos_LIBER_X_EXCHANGE_DELETED			(M_psos | 0x1201)
#define S_psos_LIBER_X_EXCHANGE_NOT_FOUND		(M_psos | 0x1202)
#define S_psos_LIBER_X_GROUP_VIOLATION			(M_psos | 0x1203)
#define S_psos_LIBER_X_NOT_ENOUGH_SYSTEM_MSG_BUFS	(M_psos | 0x1205)
#define S_psos_LIBER_X_EXCEEDS_MAX_MSG_QUEUE		(M_psos | 0x1206)
#define S_psos_LIBER_X_CANNOT_LIB_SPECIAL_MSGS		(M_psos | 0x1207)
	
#define S_psos_JAM_X_EXCHANGE_DELETED			(M_psos | 0x1301)
#define S_psos_JAM_X_EXCHANGE_NOT_FOUND			(M_psos | 0x1302)
#define S_psos_JAM_X_GROUP_VIOLATION			(M_psos | 0x1303)
#define S_psos_JAM_X_HOME_EXCHANGE_ERROR		(M_psos | 0x1304)
#define S_psos_JAM_X_NOT_ENOUGH_SYSTEM_MSG_BUFS		(M_psos | 0x1305)
#define S_psos_JAM_X_EXCEEDS_MAX_MSG_QUEUE		(M_psos | 0x1306)

#define S_psos_CREATE_X_OUT_OF_XCBS			(M_psos | 0x1401)

#define S_psos_ATTACH_X_EXCHANGE_NOT_FOUND		(M_psos | 0x1501)
#define S_psos_ATTACH_X_GROUP_VIOLATION			(M_psos | 0x1503)

#define S_psos_DELETE_X_EXCHANGE_DELETED		(M_psos | 0x1601)
#define S_psos_DELETE_X_EXCHANGE_NOT_FOUND		(M_psos | 0x1602)
#define S_psos_DELETE_X_GROUP_VIOLATION			(M_psos | 0x1603)
#define S_psos_DELETE_X_DELETED_WAITING_P_UNBLOCKED	(M_psos | 0x1680)
#define S_psos_DELETE_X_DELETED_WAITING_MSGS_RET	(M_psos | 0x1681)

#define S_psos_SEND_X_EXCHANGE_DELETED			(M_psos | 0x1701)
#define S_psos_SEND_X_EXCHANGE_NOT_FOUND		(M_psos | 0x1702)
#define S_psos_SEND_X_GROUP_VIOLATION			(M_psos | 0x1703)
#define S_psos_SEND_X_HOME_EXCHANGE_ERROR		(M_psos | 0x1704)
#define S_psos_SEND_X_OUT_OF_SYSTEM_MSG_BUFS		(M_psos | 0x1705)
#define S_psos_SEND_X_EXCEEDS_MAX_MSG_QUEUE		(M_psos | 0x1706)

#define S_psos_REQ_X_EXCHANGE_DELETED			(M_psos | 0x1801)
#define S_psos_REQ_X_EXCHANGE_NOT_FOUND			(M_psos | 0x1802)
#define S_psos_REQ_X_GROUP_VIOLATION			(M_psos | 0x1803)
#define S_psos_REQ_X_NO_MESSAGE				(M_psos | 0x1880)
#define S_psos_REQ_X_TIME_OUT				(M_psos | 0x1881)

#define S_psos_SIGNAL_TASK_DELETED			(M_psos | 0x1901)
#define S_psos_SIGNAL_TASK_NOT_FOUND			(M_psos | 0x1902)
#define S_psos_SIGNAL_GROUP_VIOLATION			(M_psos | 0x1903)

#define S_psos_WAIT_V_TIMED_OUT				(M_psos | 0x1a81)

#define S_psos_GET_V_CONDITION_NOT_MET			(M_psos | 0x1b80)

#define S_psos_GET_T_TIME_NOT_SET			(M_psos | 0x1e01)

#define S_psos_SET_T_DATE_PARAMETER_ERROR		(M_psos | 0x1f01)
#define S_psos_SET_T_TIME_PARAMETER_ERROR		(M_psos | 0x1f02)

#define S_psos_DELETE_PT_WRONG_BUF_SIZE			(M_psos | 0x2401)
#define S_psos_DELETE_PT_BUFS_IN_USE			(M_psos | 0x2402)

#define S_psos_GET_BUF_WRONG_BUF_SIZE			(M_psos | 0x2501)
#define S_psos_GET_BUF_PT_OUT_OF_BUFS			(M_psos | 0x2502)

#define S_psos_RET_BUF_WRONG_BUF_SIZE			(M_psos | 0x2601)

/* supervisor stack of at least 96 for psos calls; minimum user stack */

#define STK_SIZES	(120 << 16)


/* process control block */

typedef struct psos_pcb		/* PSOS_PCB */
    {
    struct psos_pcb *pcb_flink;	/* (forward link) in either ready, msg_wait */
    struct psos_pcb *pcb_blink;	/* (backward link) ... or mem_wait queue */
    struct psos_pcb *pcb_dflink;/* (forward link) when in the timeout list */
    struct psos_pcb *pcb_dblink;/* (backward link) when in the timeout list */
    UTINY pcb_prior;		/* priority 0 = lowest, 255 = highest */
    UTINY pcb_mode;		/* process mode byte */
    char pcb_dflag;		/* 0 = not paused, 1 = paused, -1 being paused*/
    UTINY pcb_status;		/* status byte, <<must follow dflag>> */
    UTINY pcb_grid;		/* group id, 0 = privileged */
    UTINY pcb_resvd;		/* reserved for future use */
    short pcb_events;		/* events waited for, msb = and/or (0/1) */
    short pcb_signals;		/* signals pending */
    short pcb_tslice;		/* remainder of time slice, in ticks */
    int pcb_claimlist;		/* chain of owned special messages */
    int pcb_msglist;		/* chain of owned memory segments*/
    int pcb_name;		/* process name */
    int pcb_key;		/* verify pid: ~.W <KEY> must = PID */
    struct psos_pcb *pcb_parent;/* parent's PID */
    struct psos_pcb *pcb_thread;/* chains all active pcb's together */

    short pcb_foroff;		/* format/offset from frame (68020 only) */
    char *pcb_ssp;		/* master stk ptr, or ptr-> user stack */
    char *pcb_usp;		/* real user portion of user stack */
    INSTR *pcb_pc;		/* program counter */
    short pcb_unused1;		/* unused */
    short pcb_sr;		/* process status register */
    int pcb_a6;			/* */
    int pcb_a5;			/* */
    int pcb_d0;			/* */
    int pcb_d1;			/* */
    int pcb_d2;			/* */
    int pcb_d3;			/* */
    int pcb_d4;			/* */
    int pcb_d5;			/* */
    int pcb_d6;			/* */
    int pcb_d7;			/* */
    int pcb_a0;			/* */
    int pcb_a1;			/* */
    int pcb_a2;			/* */
    int pcb_a3;			/* */
    int pcb_a4;			/* */

/* posible extensions */
    TCBX *pcb_extend;		/* ptr to user's pcb extension */
    char *pcb_phiext;			/* ptr to phile's own pcb extension */

/* spare fields */
    int pcb_spare1;			/* spares */
    int pcb_spare2;
    int pcb_spare3;
    int pcb_spare4;

/* profiling probe fields */
    int pcb_keccnt;			/* */
    int pcb_ioccnt;			/* */
    int pcb_runcnt;			/* */
    int pcb_blkcnt;			/* */
    int pcb_precnt;			/* */
    int pcb_ticks;			/* */

    } PSOS_PCB;

/* psos exchange passing structure */

typedef struct 	/* XXX not documented XXX */
    {
    int dummy;
    } XCB;

/* psos mesage passing structure */

typedef struct 
    {
    int nop;	/* don't care */
    int home;	/* must be 0 or xid */
    int body1;	/* body */
    int body2;
    int body3;
    int body4;
    } MSG;

/* psos information kept in the beginning of region 1 */

typedef struct			/* PDAT */
    {
    PSOS_PCB *pRunning;		/* current executing process */
    PSOS_PCB *pReadyHead;	/* head of ready list of PCBs */
    PSOS_PCB *pPauseHead;	/* head of pause list of PCBs */
    PSOS_PCB *pActiveHead;	/* head of active list of PCBs */
    PSOS_PCB *pFreeHead;	/* head of free list of PCBs */
    XCB *xActiveHead;		/* head of free list of XCBs */
    XCB *xFreeHead;		/* head of free list of XCBs */
    MSG *mFreehead;		/* head of free mesage buffers */
    } PDAT;

/* psos configuration table */

typedef struct			/* PSOS_CONFIG_TABLE */
    {
    int ramStart1;		/* start address of region 1 */
    int ramEnd1;		/* end address of region 1 */
    int minSeg1;		/* minimum segment size in region 1 */
    int ramStart2;		/* start address of region 2 */
    int ramEnd2;		/* end address of region 2 */
    int minSeg2;		/* minimum segment size in region 2 */
    short nProc;		/* maximum number of active processes */
    short nExch;		/* maximum number of active exchanges */
    short nMsgB;		/* maximum number of message buffers */
    short ticksPerSec;		/* clock interupt frequency */
    short ticksPerSlice;	/* full time slice in ticks */
    short nIoD;			/* maximum logical device number */
    int ioJTable;		/* address of device driver jump table */
    int sysStackSize;		/* pSOS system stack size */
    int rootStart;		/* ROOT start address */
    short rootSStkSize;		/* ROOT supervisor stack size (words) */
    short rootUStkSize;		/* ROOT user stack size (words) */
    short rootPriority;		/* ROOT priority */
    FUNCPTR activateProc;	/* callout at process activation */
    FUNCPTR deleteProc;		/* callout at process deletion */
    FUNCPTR switchProc;		/* callout at process switch */
    int	probeAddr;		/* address of probe module */
    int	phileAddr;		/* address of phile module */
    int	spare1;			/* spares */
    int	spare2;
    int	spare3;
    int	spare4;
    int	spare5;
    int	spare6;
    } PSOS_CONFIG_TABLE;

/* task status values for pSOS */

#define PSOS_READY	0x00	/* ready */
#define PSOS_SUSPEND	0x04	/* explicitly suspended */
#define PSOS_DELAY	0x08	/* suspended for task delay (or timeout) */
#define PSOS_EVENT	0x10	/* suspended for event */
#define PSOS_EXCHANGE	0x20	/* suspended for message */
#define PSOS_MEM	0x40	/* suspended for memory */
#define PSOS_DEAD	0x80	/* dead process */

/* exchange masks */

#define PSOS_XCB_FIFO		0x0	/* FIFO queueing of messages */
#define PSOS_XCB_PRI		0xf0	/* priority queueing of messages */
#define PSOS_XCB_LEN_FINITE	0x0	/* finite queue of messages */
#define PSOS_XCB_LEN_INFINITE	0x2	/* unlimited length of messages */
#define PSOS_XCB_UNRESTRICTED	0x0	/* open for anyone's use */
#define PSOS_XCB_RESTRICTED	0x1	/* only accessable from same group */

/* event masks */

#define PSOS_EVENT_COND_OR	0x1	/* any of the events */
#define PSOS_EVENT_COND_AND	0x0	/* all of the events */

#define PSOS_EVENT_0		(1 << 0)		/* event #0 */
#define PSOS_EVENT_1		(1 << 1)	/* event #1 */
#define PSOS_EVENT_2		(1 << 2)	/* event #2 */
#define PSOS_EVENT_3		(1 << 3)	/* event #3 */
#define PSOS_EVENT_4		(1 << 4)	/* event #4 */
#define PSOS_EVENT_5		(1 << 5)	/* event #5 */
#define PSOS_EVENT_6		(1 << 6)	/* event #6 */
#define PSOS_EVENT_7		(1 << 7)	/* event #7 */
#define PSOS_EVENT_8		(1 << 8)	/* event #8 */
#define PSOS_EVENT_9		(1 << 9)	/* event #9 */
#define PSOS_EVENT_10		(1 << 10)	/* event #10 */
#define PSOS_EVENT_11		(1 << 11)	/* event #11 */
#define PSOS_EVENT_12		(1 << 12)	/* event #12 */
#define PSOS_EVENT_13		(1 << 13)	/* event #13 - child deleted */
#define PSOS_EVENT_14		(1 << 14)	/* event #14 */
#define PSOS_EVENT_15		(1 << 15)	/* event #15 - reserved */

#endif
