/* nfsLib.h - Network File System library header file */

/*
modification history
--------------------
01d,09sep88,llk  added NFS_TIMEOUT_SEC, NFS_TIMEOUT_USEC, NFS_SOCKOPTVAL.
01c,26aug88,gae  removed unused imports.
01b,04jun88,llk  moved FOLLOW_LINK, DEFAULT_FILE_PERM and DEFAULT_DIR_PERM
		   to ioLib.h.
01a,19apr88,llk  written.
*/

#ifndef	INCnfsLibh
#define	INCnfsLibh

#include "vwModNum.h"

#define MNTPROC_NULL		0
#define MNTPROC_MNT		1
#define MNTPROC_DUMP		2
#define MNTPROC_UMNT		3
#define MNTPROC_UMNTALL		4
#define MNTPROC_EXPORT		5
	
#define NFSPROC_NULL		0
#define NFSPROC_GETATTR		1
#define NFSPROC_SETATTR		2
#define NFSPROC_ROOT		3
#define NFSPROC_LOOKUP		4
#define NFSPROC_READLINK	5
#define NFSPROC_READ		6
#define NFSPROC_WRITE		8
#define NFSPROC_CREATE		9
#define NFSPROC_REMOVE		10
#define NFSPROC_RENAME		11
#define NFSPROC_LINK		12
#define NFSPROC_SYMLINK		13
#define NFSPROC_MKDIR		14
#define NFSPROC_RMDIR		15
#define NFSPROC_READDIR		16
#define NFSPROC_STATFS		17

/* file status types -- from the nfs protocol spec, if these change,
   then the FSTAT values in ioLib.h should also be changed */

#define NFS_FSTAT_DIR		0040000		/* directory */
#define NFS_FSTAT_CHR		0020000		/* character special file */
#define NFS_FSTAT_BLK		0060000		/* block special file */
#define NFS_FSTAT_REG		0100000		/* regular file */
#define NFS_FSTAT_LNK		0120000		/* symbolic link file */
#define NFS_FSTAT_NON		0140000		/* named socket */

/* nfsLib status codes */

#define	S_nfsLib_NFS_AUTH_UNIX_FAILED		(M_nfsLib | 1)
#define	S_nfsLib_NFS_INAPPLICABLE_FILE_TYPE	(M_nfsLib | 2)

/* nfsLib status codes derived from Sun's NFS specification (see xdr_nfs.h)  */

#define S_nfsLib_NFS_OK			(M_nfsStat | (int) NFS_OK)
#define S_nfsLib_NFSERR_PERM		(M_nfsStat | (int) NFSERR_PERM)
#define S_nfsLib_NFSERR_NOENT		(M_nfsStat | (int) NFSERR_NOENT)
#define S_nfsLib_NFSERR_IO		(M_nfsStat | (int) NFSERR_IO)
#define S_nfsLib_NFSERR_NXIO		(M_nfsStat | (int) NFSERR_NXIO)
#define S_nfsLib_NFSERR_ACCES		(M_nfsStat | (int) NFSERR_ACCES)
#define S_nfsLib_NFSERR_EXIST		(M_nfsStat | (int) NFSERR_EXIST)
#define S_nfsLib_NFSERR_NODEV		(M_nfsStat | (int) NFSERR_NODEV)
#define S_nfsLib_NFSERR_NOTDIR		(M_nfsStat | (int) NFSERR_NOTDIR)
#define S_nfsLib_NFSERR_ISDIR		(M_nfsStat | (int) NFSERR_ISDIR)
#define S_nfsLib_NFSERR_FBIG		(M_nfsStat | (int) NFSERR_FBIG)
#define S_nfsLib_NFSERR_NOSPC		(M_nfsStat | (int) NFSERR_NOSPC)
#define S_nfsLib_NFSERR_ROFS		(M_nfsStat | (int) NFSERR_ROFS)
#define S_nfsLib_NFSERR_NAMETOOLONG	(M_nfsStat | (int) NFSERR_NAMETOOLONG)
#define S_nfsLib_NFSERR_NOTEMPTY	(M_nfsStat | (int) NFSERR_NOTEMPTY)
#define S_nfsLib_NFSERR_DQUOT		(M_nfsStat | (int) NFSERR_DQUOT)
#define S_nfsLib_NFSERR_STALE		(M_nfsStat | (int) NFSERR_STALE)
#define S_nfsLib_NFSERR_WFLUSH		(M_nfsStat | (int) NFSERR_WFLUSH)


/* default NFS parameters */

#define NFS_TIMEOUT_SEC         25
#define NFS_TIMEOUT_USEC        0
#define NFS_SOCKOPTVAL          10000

#endif	INCnfsLibh
