#define	T_SEND			1
#define	T_RECEIVED		2
#define	T_REPLY			3
#define	T_COPY_FROM_REQ		4
#define	T_COPY_FROM_REP		5
#define	T_COPY_TO_REQ		6
#define	T_COPY_TO_REP		7
#define	T_NACK			8
#define	T_EXPAND_RETRY		9

#define	BIG_PACKET_LEN		512
#define	MAX_NPKT		10	/* cannot be greater than 32 */
#define	MAX_RETRY		12

#define	VERSION		(((1) << 4) | ((1) << 0))
#define	MAJVER(v)	((v) & 0xF0)
#define	MINVER(v)	((v) & 0x0F)

struct packet {
	unsigned char	type;
	unsigned char	version;
	unsigned char	retry;
	unsigned char	errcode;
	unsigned short	sendseqid;
	unsigned short	copyseqid;
	unsigned long	src;
	unsigned long	dst;
};

struct fragment {
	unsigned char	flags;
	unsigned char	fragid;
	unsigned char	srcxs;
	unsigned char	dstxs;
	unsigned short	len;
	unsigned short	off;
	char		*srcaddr;
	char		*dstaddr;
};

struct sendpk {
	struct packet	h;
	struct fragment	frag0;
	struct fragment	frag1;
	struct wmsg	msg;
	struct wctl	ctl;
	unsigned char	rocp_xs, cfos_xs, flags, pad1;
	char		*rocp_addr, *cfos_addr;
};
#define	SF_HOLD		(1<<0)
#define	SF_REPLIED	(1<<1)
#define	SEND_SZ		(sizeof(struct sendpk))

struct datapk {
	struct packet	h;
	struct fragment	frag;
	unsigned long	copybits;
	unsigned short	maxfraglen;
	unsigned short	pad;
};

struct cptoreppk {
	struct packet	h;
	unsigned long	rcvdbits;
};

struct cpfmreqpk {
	struct packet	h;
	char		*srcaddr;
	char		*dstaddr;
	unsigned long	len;
	unsigned char	srcxs;
	unsigned char	dstxs;
	unsigned short	pad;
};
