/* memLib.h - memory management library header file */

/*
modification history
--------------------
02a,11jun88,dnw  changed for rev 03a of memLib.
01l,28mar88,gae  added function decl. of calloc().
01j,13nov87,gae  removed FRAGMENT definition; made function decl.'s IMPORTs.
01h,23oct87,rdc  added PARTITION defenitions.
01g,24dec86,gae  changed stsLib.h to vwModNum.h.
01f,21may86,rdc	 added forward declarations for malloc and realloc.
		 added FRAGMENT structure.
01e,13aug84,ecs  changed S_memLib_NO_MORE_MEMORY to S_memLib_NOT_ENOUGH_MEMORY.
01d,07aug84,ecs  added include of stsLib.h, and status codes.
01c,15jun84,dnw  removed declaration of memEnd (no longer exists).
01b,27jan84,ecs  added inclusion test.
01a,24may83,dnw  written
*/

#ifndef INCmemLibh
#define INCmemLibh

#include "vwModNum.h"
#include "lstLib.h"
#include "semLib.h"


/* status codes */

#define S_memLib_NOT_ENOUGH_MEMORY		(M_memLib | 1)
#define S_memLib_INVALID_NBYTES			(M_memLib | 2)
#define S_memLib_BLOCK_ERROR			(M_memLib | 3)


/* HIDDEN */

typedef struct 
    {
    LIST freeList;			/* list of free blocks */
    SEMAPHORE sem;			/* partition semaphore */
    unsigned totalWords;		/* total number of words in pool */
    unsigned minBlockWords;		/* min block size in words
					 *   (including hdr) */
    unsigned options;			/* options */

    /* allocation statistics */

    unsigned curBlocksAllocated;	/* current # of blocks allocated */
    unsigned curWordsAllocated;		/* current # of words allocated */
    unsigned cumBlocksAllocated;	/* cumulative # of blocks allocated */
    unsigned cumWordsAllocated;		/* cumulative # of words allocated */

    } PARTITION;

/* END_HIDDEN */

typedef PARTITION *PART_ID; 


/* partition options */

/* optional check for bad blocks */

#define MEM_BLOCK_CHECK			0x10
    
/* allocation errors - block too big, insufficient space */

#define MEM_ALLOC_ERROR_MASK		0x03
#define MEM_ALLOC_ERROR_RETURN		0
#define MEM_ALLOC_ERROR_LOG_MSG		0x01
#define MEM_ALLOC_ERROR_LOG_AND_SUSPEND	0x02

/* bad block found */

#define MEM_BLOCK_ERROR_MASK		0x0c
#define MEM_BLOCK_ERROR_RETURN		0
#define MEM_BLOCK_ERROR_LOG_MSG		0x04
#define MEM_BLOCK_ERROR_LOG_AND_SUSPEND	0x08


/* function declarations */

IMPORT char *malloc ();
IMPORT char *realloc ();
IMPORT char *calloc ();

IMPORT PART_ID memPartCreate ();
IMPORT char *memPartAlloc ();
IMPORT char *memPartRealloc ();

#endif INCmemLibh
