/* esf68k.h - exception stack frames for 68k cpus */

/*
modification history
--------------------
01a,03apr86,dnw  extracted from dbgLib.c
*/

#ifndef INCesf68kh
#define INCesf68kh	1

/* Exception stack frames.  Most of these can happen only for one
   CPU or another, but they are all defined for all CPU's */

/* ESF68K_BA - bus and address error for 68K only */

typedef struct
    {
    unsigned short fn;			/* function code */
    unsigned long aa;			/* access address */
    unsigned short ir;			/* instruction register */
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    } ESF68K_BA;

/* ESF68K - all other exceptions for 68K only */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    } ESF68K;

/* ESF0: format 0 stack frame.  Generated by interrupts, format errors, TRAP #n
   instructions, and illegal instructions.  68010 and 68020. */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    } ESF0;

/* ESF2: format 2 stack frame. Generated by instruction-related exceptions,
   including coprecessor post-instruction exceptions, CHK, CHK2, cpTRAPcc,
   TRAPcc, TRAPV, trace, and zero divide.  68020 only */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    unsigned long aa;			/* fault address */
    } ESF2;

/* ESF8: format 8 exception stack frame. Generated by bus or address
   error on 68010 only */

typedef struct	
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    unsigned short fn;			/* special status word */
    unsigned long aa;			/* fault address */
    short unused1;
    unsigned short dataOutBuf;		/* data output buffer */
    short unused2;
    unsigned short dataInBuf;		/* data input buffer */
    short unused3;
    unsigned short ir;			/* instruction input buffer */
    short intInfo[16];			/* internal information, 16 words */
    } ESF8;

/* ESF9: format 9 stack frame.  Generated by coprocessor mid-instruction
   exception.  68020 only */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    unsigned long aa;			/* fault address */
    short InternalRegs [4];		/* internal registers */
    } ESF9;

/* ESFA: format A exception stack frame.  Generated
   by a 'short' bus cycle fault. 68020 only. */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    unsigned short internalReg1;	/* internal register */
    unsigned short fn;			/* special status word */
    unsigned short instPipeC;		/* instruction pipe stage C */
    unsigned short instPipeB;		/* instruction pipe stage B */
    unsigned long aa;			/* fault address */
    unsigned short internalReg2;	/* internal register */
    unsigned short internalReg3;	/* internal register */
    unsigned long dataOutBuf;		/* data output buffer */
    unsigned short internalReg4;	/* internal register */
    unsigned short internalReg5;	/* internal register */
    } ESFA;

/* ESFB: format B exception stack frame.  Generated
   by a 'long' bus cycle fault. 68020 only. */

typedef struct
    {
    unsigned short sr;			/* status register */
    INSTR *pc;				/* program counter */
    unsigned short vectorOffset;	/* vector offset */
    unsigned short internalReg1;	/* internal register */
    unsigned short fn;			/* special status word */
    unsigned short instPipeC;		/* instruction pipe stage C */
    unsigned short instPipeB;		/* instruction pipe stage B */
    unsigned long aa;			/* fault address */
    unsigned short internalReg2;	/* internal register */
    unsigned short internalReg3;	/* internal register */
    unsigned long dataOutBuf;		/* data output buffer */
    unsigned short internalReg4;	/* internal register */
    unsigned short internalReg5;	/* internal register */
    unsigned long addrStageB;		/* stage B address */
    unsigned short internalReg6;	/* internal register */
    unsigned short internalReg7;	/* internal register */
    unsigned long dataInBuf;		/* data input buffer */
    unsigned short internalRegs [22];	/* more internal registers */
    } ESFB;

#endif
