/* 
 * qsvar.h - ISI Liberator structs common to lower level SCSI qs and 
 * upper level drivers (disk, tape, etc.).
 */


struct qs_queue	{
	struct	qs_queue	*qsq_forw;
	struct	qs_queue	*qsq_back;
	int			(*qsq_getcmd) ();
	int			(*qsq_doerr) ();
};


/* OpenChip lun struct */

struct lunelem {
	struct scsi_cmd *l_cmndptr; /* ptr to command struct */

	u_char l_state;		/* state of lun */
#define	L_ST_NULL	0
#define	L_ST_PENDING	1	/* discon cmd pending reconnection for lun */

	u_char l_flaqs;		/* bits 0-3 indicate target ID */
#define	L_FL_DESTMASK	0x07
#define	L_FL_SEL_ATN	0x08
#define	L_FL_CHK_PARITY	0x10
#define	L_FL_MANUAL	0x20

	u_char l_sync_trans;	/* value loaded into sync/trans register */
	u_char l_identify;	/* byte passed to targ for msg out */
};

#define LEN_STATUS	2

/* OpenChip command struct - these are queued up in the scratch area */

struct scsi_cmnd {
	struct qs_link qs_datlnk;	/* saved data pointer */
	struct qs_link qs_dat3lnk;	/* after each data transfer phase the
					 * current data pointer gets copied here
					 */
	char *qs_pcmnd;	/* pointer to command bytes */
	char *qs_pstat;	/* pointer to status bytes */
	char qs_ncmnd;	/* number of command bytes */
	char qs_nstat;	/* number of status bytes */
	char qs_finstat;	/* end status */
	char qs_pad;
	struct scsi_cmnd *qs_chain;
	struct lunelem *qs_ptrlun;
		/*
		 * All fields before this point are used by the Openchip.
		 * When the command is passed to scissue(), qs_dat2lnk should
		 * have been set up. scissue() will copy it into qs_datlnk and
		 * qs_dat3lnk each time the command has to be sent (multiple
		 * issuinqs are the result of a received BUSY response).
		 */
	char qs_status[LEN_STATUS];
	struct qs_link qs_dat2lnk;
	struct scsiproto *qs_proto;
	long qs_cmndlngth;	/* length of data transfer for the command */
	long qs_rqsnslngth;	/* length of data transfer for request sense */
	short qs_flaqs;
	char qs_retries;	/* maximum number of times to issue command */
	u_char qs_lun;
	char dbgmsg[80];
};

#define	SET_CMD(cmd,chain,cdb,ncmnd,pstat,finstat,nstat,datptr,datcnt, \
		flaqs, stat){ \
		bzero(cmd, sizeof (struct scsi_cmnd));			\
		(cmd)->qs_chain = (struct scsi_cmnd *) chain;		\
		(cmd)->qs_pcmnd = (char *) cdb;				\
		(cmd)->qs_ncmnd = ncmnd;				\
		(cmd)->qs_pstat = (char *) pstat;			\
		(cmd)->qs_finstat = finstat;				\
		(cmd)->qs_nstat = nstat;				\
		(cmd)->qs_datlnk.sl_ptr = (char *) datptr;		\
		(cmd)->qs_datlnk.sl_cnt = datcnt;			\
		(cmd)->qs_flaqs = flaqs;				\
		(*(cmd)->qs_pstat) = stat;				}
/*
 * Note that the values taken by the qs_finstat and qs_flaqs fields are the
 * same values used by the sp_finstat and sp_flaqs fields of a scsiproto
 * structure.
 */

/*
 * values of sp_finstat. The Openchip can generate the first four. Others
 * explain why the software decided to try and abort the commands.
 */
#define	SFN_NOT_FINISHED	0
#define	SFN_NORMAL_END		1
#define	SFN_NO_CMND_CMPLT	2
#define	SFN_SLCT_TIMEOUT	3

#define	SFN_ABRT_REJ_MSG	4	/* a message rejection that the software couldn't recover from */
#define	SFN_ABRT_MSG_PRTY	5	/* there was a message parity error for  which the target didn't perform a message out phase */
#define	SFN_ABRT_MDFY_PTRS	6	/* a modify data pointer message moved the pointer back past the start */
#define	SFN_ABRT_BERR	7	/* a bus error occurred during DMA */

#define	SFN_INACTIVE	8	/* command block is inactive */
#define	SFN_STILL_BUSY	9	/* ran out of retries on receiving BUSY status */
#define	SFN_FUNNY_STATUS	10	/* any status other than good, check or busy */
#define	SFN_RQS_SNS_CHK	11	/* request sense command returned check status */
#define SFN_NOINTRFACE	12	/* no attached interface for this command */
#define SFN_TOO_MANY_BUFFERS 13	/* the attached interface didn't have the necessary buffers or other structures to handle this command */
#define SFN_ILL_PHASE	14	/* one of the two illegal phases occured */
#define SFN_STATOVFL	15	/* too many status bytes were sent */
#define	SFN_UNSPEC	16	/* unspecified error */

/*
 * bit positions in sp_flaqs.
 */
#define	SCF_RQS_SNS	0x0001		/* request sense issued */
#define	SCF_DATA_PRTY	0x0002		/* data transfer parity error */
#define SCF_DATA_OVFL	0x0004		/* data transfer exceeded allowed space */
#define SCF_COMM_OVFL	0x0008		/* command transfer exceeded allowed space */
#define SCF_STATUS_OVFL	0x0010		/* status transfer exceeded allowed space */
#define	SCF_UNSPEC_PHASE	0x0020		/* unspecified phase occurred */

#define SCF_FATAL_COMB	(SCF_DATA_PRTY | SCF_DATA_OVFL | SCF_COMM_OVFL | SCF_STATUS_OVFL | SCF_UNSPEC_PHASE)	/* the fatal flaqs */

/*
 * status byte values and mask pattern.
 */
#define	SC_STATUS_MASK	0x1e
#define	SCSTAT_GOOD	0x00
#define	SCSTAT_CHK	0x02
#define	SCSTAT_CONDITN	0x04
#define	SCSTAT_BUSY	0x08
#define	SCSTAT_INTERM	0x10
#define	SCSTAT_INTRCOND	0x14
#define	SCSTAT_RSRVCONF	0x18

