/* ctype.h - ascii character macros header file */

/*
modification history
--------------------
01a,16feb87,llk  created.
*/

#ifndef INCctypeh
#define INCctypeh

#define	C_UPPER		0x1
#define	C_LOWER		0x2
#define	C_NUMBER	0x4
#define	C_WHITE_SPACE	0x8
#define C_PUNCT		0x10
#define C_CONTROL	0x20
#define C_HEX_NUMBER	0x40

extern	char	_ctype_[];

#define	isalpha(c)	((_ctype_+1)[c] & (C_UPPER | C_LOWER))
#define	isupper(c)	((_ctype_+1)[c] & C_UPPER)
#define	islower(c)	((_ctype_+1)[c] & C_LOWER)
#define	isdigit(c)	((_ctype_+1)[c] & C_NUMBER)
#define	isxdigit(c)	((_ctype_+1)[c] & (C_NUMBER | C_HEX_NUMBER))
#define	isspace(c)	((_ctype_+1)[c] & C_WHITE_SPACE)
#define ispunct(c)	((_ctype_+1)[c] & C_PUNCT)
#define isalnum(c)	((_ctype_+1)[c] & (C_UPPER | C_LOWER | C_NUMBER))
#define isprint(c)	((_ctype_+1)[c] & (C_PUNCT | C_UPPER | C_LOWER \
					   | C_NUMBER))
#define iscntrl(c)	((_ctype_+1)[c] & C_CONTROL)
#define isascii(c)	((unsigned) (c) <= 0177)
#define toupper(c)	((c) - 'a' + 'A')
#define tolower(c)	((c) - 'A' + 'a')
#define toascii(c)	((c) & 0177)

#endif INCctypeh
