/* usrConfig.c - user defined system configuration module */

static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";

/*#define	DEBUG		/**/

/*
modification history
--------------------
*/

/*
DESCRIPTION
This is the WRS-supplied configuration module for UniWorks.
It contains the root task, the primary system
initialization routine, the network initialization routine, and the clock
interrupt routine.

The include file "config.h" includes a number of system-dependent paramters
used in this file.

INCLUDE FILE: config.h

SEE ALSO: "Cross-Development", "Tutorial"
*/

/* LINTLIBRARY */

#include "ctype.h"
#include "UniWorks.h"

#include "inetLib.h"
#include "ioLib.h"
#include "iv68k.h"
#include "ldLib.h"
#include "socket.h"
#include "strLib.h"
#include "sysLib.h"
#include "sysSymTbl.h"
#include "taskLib.h"
#include "version.h"

#include "config.h"

IMPORT VOID sysVwTrapRtn ();	/* UniWorks trap handler entry */
IMPORT VOID sysMemParityError();/* memory parity err handling routine */
IMPORT char *bootCrackParams ();/* interpret boot line */
IMPORT char *sysModel ();	/* model name of system CPU */
IMPORT char *kernelVersion ();	/* get kernel version string */
IMPORT VOID logMsg ();		/* log error message */
IMPORT ULONG tickGet ();	/* get current time in ticks */

IMPORT char edata;		/* automatically defined by the loader */
IMPORT char etext;		/* automatically defined by the loader */
IMPORT char end;		/* automatically defined by the loader */
IMPORT int  remLastResvPort;	/* last port num used (from bootroms) */
IMPORT SYMTAB_ID standAloneSymTbl;	/* ptr to linked in symbol table -
					 * STANDALONE versions only */

/* global variables */

SYMTAB_ID sysSymTbl;		/* system symbol table id */
int idleTaskId;			/* task id of idle task */

#ifdef INCLUDE_IE
char ieEnetAddr[6] = IE_ENET_ADDR;	/* ethernet adrs for sun ie board only*/
#endif

/* forward declarations */

VOID usrClock ();
VOID usrRoot ();
LOCAL STATUS loadSymTbl ();

/* check include dependencies */

#if defined(INCLUDE_DBX) || defined(INCLUDE_NFS)
#define INCLUDE_RPC		/* rpc required by dbx and nfs */
#endif

#ifdef INCLUDE_DBX
#define INCLUDE_DEBUG		/* native debugging required by dbx */
#endif

#ifdef INCLUDE_RAM
#define INCLUDE_RT11		/* rt11 required by ramDrv */
#endif

/* implicit includes */

#if defined(INCLUDE_DBX)
#define	INCLUDE_MC68881		/* gets dragged in by DBX */
#endif

/***************************************************************
*
* usrInit - user defined system initialization routine
*
* THIS IS THE FIRST "C" CODE EXECUTED AFTER BOOT UP. This routine is
* called by the assembly language start-up routine sysInit which is
* in the sysALib.s file of the target specific directory.  It simply
* puts us in system mode, with the interrupts locked out.  The Kernel is
* not multi-tasking at this point.
*
* This routine starts by clearing BSS, so all variables are initialized to 0 as
* per the C specification.  Then it initializes the hardware by calling
* sysHwInit, sets up the 68K interrupt/exception vectors, spawns usrRoot
* to do the bulk of the initialization, and starts the kernel.  The root task,
* usrRoot, will start up AFTER the kernelGo call.
*/

VOID usrInit ()

    {


#if ((CPU==MC68020) || (CPU==MC68030))
    sysCacheEnable (TRUE);		/* enable cache memory */
#endif

    bzero (&edata, &end - &edata);	/* clear bss */

    /* set the vector base register (except on 68000);
     * initialize exception/interrupt vectors */

#if ((CPU==MC68010) || (CPU==MC68020) || (CPU==MC68030))
    intSetVecBase((FUNCPTR *) VEC_BASE_ADRS);
#endif

    excVecInit ();
    intSetVec(TRAPNUM_TO_IVEC (TRAP_UNIWORKS), sysVwTrapRtn); /*UniWorks trap*/

    /* do system dependent hardware initialization */

    sysHwInit ();

    /* start the kernel specifying usrRoot as the root task */

    kernelInit (TRAP_KERNEL, usrRoot, (ULONG) ROOT_STACK_SIZE,
		(ULONG) FREE_RAM_ADRS, (ULONG) sysMemTop (),
		(ULONG) ISR_STACK_SIZE, (ULONG) INT_LOCK_LEVEL);
    }
/***************************************************************
*
* usrRoot - root task
*
* The root task must perform any initialization that cannot be
* done before a vxVrtxGo.
*
* It initializes the I/O system, install drivers, create devices,
* sets up the network, etc., as necessary for the particular configuration.
* It may also create the system symbol table if one is to be included.
* It should then load and/or spawn additional tasks as needed.
* In a debug configuration, this is usually just a spawn of the shell.
*/

VOID usrRoot ()
    {
    int fd;
    char line[80];
    long addr;


    /* set up parity error interrupt routine, if interrupt vector is defined */

#ifdef INT_VEC_PARITY_ERROR
    intConnect (INUM_TO_IVEC (INT_VEC_PARITY_ERROR), sysMemParityError, 0);
#endif
#ifdef TARGET_TYPE_IS68K30
    {
    extern sysNmiTrap ();
    intConnect (INUM_TO_IVEC (INT_VEC_NMI), sysNmiTrap, NULL);
    }
#endif TARGET_TYPE_IS68K30


    /* set up system timer */

    wdLibInit ();			/* init watchdog lib */
    sysClkConnect (usrClock, 0);	/* connect clock interrupt routine */

#ifdef  TARGET_TYPE_LIBERATOR

    /*
     * Set up the hardware clock at a rate of 1200 ticks per second.
     * Then set up the system clock at a rate of 60 ticks per second.
     * This is done so that we can get both a system clock and an
     * aux clock from one hardware clock.
     */

    sysClkInit (1200);
    sysClkSetRate (60);

#else  TARGET_TYPE_LIBERATOR

    sysClkSetRate (60);			/* set sys clock rate */

#endif  TARGET_TYPE_LIBERATOR

    sysClkEnable ();			/* start it */
    tickSet ((ULONG) 0);		/* set initial time to zero */


    /* initialize i/o system */

    iosInit (NUM_DRIVERS, NUM_FILES, "/null");	/* init i/o system */

#ifdef	TARGET_ISI
    sysInitVdma ();		/* initialize virtual DMA */

#ifdef  INCLUDE_TS
    /* if ts driver is used, we have to open
     * a window to low memory so the controller
     * can access the ts_cmd_buf
     */
    {
    extern ts_cmd_buf_end;
    sysSetVdma (0, &ts_cmd_buf_end);
    }
#endif  INCLUDE_TS
#endif	TARGET_ISI

    /* install driver for on-board ports and make devices */

    tyCoDrv ();

    tyCoDevCreate ("/tyCo/0", 0, 1024, 1024);
    tyCoDevCreate ("/tyCo/1", 1, 1024, 1024);    /* connect second serial port *
						* if there is one. */

#ifdef  TARGET_TYPE_IS68K30
    tyCoDevCreate ("/tyCo/2", 2, 512, 512);
    tyCoDevCreate ("/tyCo/3", 3, 512, 512);
    tyCoDevCreate ("/tyCo/4", 4, 512, 512);
    tyCoDevCreate ("/tyCo/5", 5, 512, 512);
    tyCoDevCreate ("/tyCo/6", 6, 512, 512);
    tyCoDevCreate ("/tyCo/7", 7, 512, 512);
#endif	TARGET_TYPE_IS68K30

    /* make specified console device be standard in/out */

    fd = open (CONSOLE_DEVICE, UPDATE, 0);	/* open console device */
#ifndef	TARGET_TYPE_LIBERATOR
    ioctl (fd, FIOBAUDRATE, 9600);		/* set to 9600 baud */
#endif	TARGET_TYPE_LIBERATOR
    ioctl (fd, FIOOPTIONS, OPT_TERMINAL);	/* set normal terminal opts */
    ioGlobalStdSet (STD_IN, fd);		/* set as std in */
    ioGlobalStdSet (STD_OUT, fd);		/* set as std out */
    ioGlobalStdSet (STD_ERR, fd);		/* set as std error */

#ifdef	INCLUDE_SHELL
    printLogo ();	/* print out id message */

    sprintf(line,"%s cpu, processor #%d.", sysModel(), sysGetProcNum());
    center(line);

#endif	INCLUDE_SHELL

    /* install pipe driver and initialize exception reporting,
     * debugging, and logging */

    idleTaskId = taskSpawn ("idle", 254, VX_SUPERVISOR_MODE | VX_UNBREAKABLE,
			    1000, idle);

    pipeDrv ();			/* init pipe driver */
    excInit ();			/* init exception reporting/handling */
    logInit (fd, 500);		/* init logging */
    sigInit ();			/* initialize signals */

#ifdef INCLUDE_DEBUG
    dbgInit (TRAP_DEBUG);	/* init debugging */
#endif

#ifdef INCLUDE_RT11
    rtInit (NUM_RT_FILES);	/* init RT-11 file system */
#endif

#ifdef INCLUDE_FLOATING_POINT
    fltInit ();		/* initialize floating point i/o support */
#endif

#ifdef INCLUDE_MC68881
    fppInit ();			/* initialize 68881 support */
    mathInit ();		/* get 68881 math functions (trig, log, etc) */
#endif

#ifdef INCLUDE_STDIO
    stdioInit ();		/* intialize standard I/O library */
#endif

#ifdef INCLUDE_SPY
    stopSpy ();			/* harmless call to drag in spyLib */
#endif

#ifdef INCLUDE_TIMEX
    timeFInit ();		/* harmless call to drag in timexLib */
#endif

#ifdef	KERNEL_VRTX
#ifdef	INCLUDE_1.5COMPAT
    compatHInit();		/* harmless call to drag in compatHLib */
    compatPInit();		/* harmless call to drag in compatPLib */
    compatVInit();		/* harmless call to drag in compatVLib */
#endif	INCLUDE_1.5COMPAT
#endif	KERNEL_VRTX

    /* create system symbol table; 
     * used compiled-in symbol definitions if STANDALONE,
     * otherwise load across net */ 

#ifdef STANDALONE
    sysSymTbl = standAloneSymTbl;
#ifdef	EASTPORT
    if (netInit (DEFAULT_BOOT_LINE) != OK)
	printf("Error initializing network\n");	
#endif  EASTPORT
#else STANDALONE
    /*
     * Create system symbol table and load across the network.
     * The name of the symbol table file is constructed as:
     *      <host>:<bootFile>.sym
     *
     * First initialize the network.
     */

    if (netInit (BOOT_LINE_ADRS) == OK)
	{
	char symTblFile [BOOT_FIELD_LEN];	/* name of symbol table file */

	sysSymTbl = (SYMTAB_ID)symCreate (MAX_SYS_SYMBOLS, MAX_SYS_SYM_LEN);

	sprintf (symTblFile, "%s:%s.sym", sysBootHost, sysBootFile);
	printf ("\nLoading symbol table from %s ...\n", symTblFile);
	loadSymTbl (symTblFile);
	}
#endif STANDALONE
    
	/* optional drivers */

#ifdef	INCLUDE_RAM
    ramDrv();
    ramMkfs("/ram0",10000,0,0);
#endif	INCLUDE_RAM

#ifdef	INCLUDE_TS
    tsDrv();
#endif	INCLUDE_TS
#ifdef	INCLUDE_SM
    smDrv();
#endif	INCLUDE_SM
#ifdef	INCLUDE_DR
    drDrv();
#endif	INCLUDE_DR
#ifdef	INCLUDE_QD
    qdDrv();	/**/
#endif	INCLUDE_QD
#ifdef	INCLUDE_QT
    qtDrv();	/**/
#endif	INCLUDE_QT

#ifndef	STANDALONE
#ifdef	INCLUDE_PN
#ifdef	EASTPORT	
	/* 
	 * Attach Eastport's cluster's proNET board, configure the pn
	 * network, 95.0.0.1 is this side, 95.0.0.2 is the other side. 
	 */
	pnattach(0);
	ifconfig("pn0","inet","95.0.0.1",0,0,0,0);
/*	proNet("pronet1","95.0.0.1");	/**/
	remAddHost("pronet2","95.0.0.2");
#else	EASTPORT
	pnattach(0);
#endif	EASTPORT
#endif	INCLUDE_PN
#endif	STANDALONE

#ifdef	INCLUDE_PASCAL
    pascalInit();
#endif	INCLUDE_PASCAL

#ifdef	INCLUDE_SHELL
#ifdef	INCLUDE_PASCAL
    shellInit (SHELL_STACK_SIZE, TRUE, TRUE);
#else	INCLUDE_PASCAL
    shellInit (SHELL_STACK_SIZE, TRUE, FALSE);
#endif	INCLUDE_PASCAL
    tset ();
#endif	INCLUDE_SHELL

#ifdef INCLUDE_FORTRAN
    fortInit ();		/* initialize Fortran support library */
    fortGlue ();		/* force loading of Fortran interfaces */
#endif

    }
/*******************************************************************************
*
* usrClock - user defined system clock interrupt routine
*
* This routine is called at interrupt level on each clock interrupt.
* It is installed by usrRoot with a sysClkConnect call.
* It calls all the other packages that need to know about clock ticks,
* including the kernel itself.
*
* If the application needs anything to happen at clock interrupt level,
* it should be added to this routine.
*/

extern struct addrst smaddrlist[4];

VOID usrClock ()

    {

#ifdef	TARGET_TYPE_LIBERATOR

    /* sysTick generates both a system clock and an aux clock */

    sysTick();

#else	TARGET_TYPE_LIBERATOR

    wdTick ();		/* check watchdog timers */
    tickAnnounce ();	/* announce system tick to kernel */

#endif	TARGET_TYPE_LIBERATOR
    }
/*******************************************************************************
*
* netInit - system-dependent network initialization
*
* This routine initializes the network.  
*
* NetInit initializes the ethernet and backplane drivers and the TCP/IP 
* software.  It also adds hosts (analogous to the etc/hosts file in Unix), 
* and sets up our access rights on the host system (with 'iam').
*
* This routine takes as a parameter the boot string.  This is normally left
* behind by the boot ROMs, at address BOOT_LINE_ADRS.
*
* RETURNS
*  OK,   or
*  ERROR if a problem in the boot string, or initializing network.
*/

STATUS netInit (paramString)
    char *paramString;		/* boot parameter string */

    {
    char devName [MAX_FILENAME_LENGTH];	/* device name */
    char bootDev [BOOT_FIELD_LEN];	/* boot device code */
    char ead [BOOT_FIELD_LEN];		/* ethernet internet addr */
    char bad [BOOT_FIELD_LEN];		/* backplane internet addr */
    char had [BOOT_FIELD_LEN];		/* host internet addr */
    char gad [BOOT_FIELD_LEN];		/* gateway internet addr */
    char usr [BOOT_FIELD_LEN];		/* user id */
    char passwd [BOOT_FIELD_LEN];	/* password */
    int procNum;			/* processor number */
    char nad [BOOT_FIELD_LEN];		/* host's network internet addr */
    int protocol;
    char nfsDisk [MAX_FILENAME_LENGTH];
    char *p;
    FAST char *pS;
    char ifname [20];
    STATUS status;
    int eNetmask;
    int bNetmask;
    int gid;				/* group id for nfs */

#ifdef TARGET_ISI
#ifndef	EASTPORT
    /* for compatibility with ISI boot roms, turn single EOS into spaces;
     * boot line MUST be terminated with TWO EOS! */

    for (pS = paramString; (pS[0] != EOS) || (pS[1] != EOS); ++pS)
	{
	if (pS[0] == EOS)
	    pS[0] = ' ';
	}

    /* KLUDGE get rid of %%%%% on boot line */
    for (pS = paramString; *pS != EOS; ++pS)
	if ((*pS & 0x7f) == '%')
	    *pS = ' ';

#endif	EASTPORT
#endif TARGET_ISI

    /* interpret boot command */

    pS = bootCrackParams (paramString, bootDev, sysBootHost, sysBootFile,
			  ead, bad, had, gad, usr, passwd, &procNum, &sysFlags);
    if (*pS != EOS)
	{
	/* print error msg with '^' where parse failed */

	printf ("Error in boot command:\n%s\n%*c\n", paramString,
		pS - paramString + 1, '^');
	return (ERROR);
	}

    eNetmask = bootNetmaskExtract (ead);
    bNetmask = bootNetmaskExtract (bad);

    /* set processor number: may establish vme bus access, etc. */

    sysSetProcNum (procNum);

    hostTblInit ();		/* initialize remote command library */

    /* attach and configure the network interfaces */
    
    remLastResvPort = 1010;	/* pick an unused port number so we don't *
				 * have to wait for the one used by the *
				 * by the bootroms to time out */
    netStart ();


    /* if enet address specified, initialize enet boot device */

    if (ead[0] != NULL)
	{
	if (FALSE)	/* so INCLUDEs will work with 'else if's */
	    ;
#ifdef INCLUDE_EX
	else if (strcmp (bootDev, "ex") == 0)
	    status = exattach (0);
#endif
#ifdef INCLUDE_NW
	else if (strcmp (bootDev, "nw") == 0)
	    status = nwattach (0);
#endif
#ifdef	INCLUDE_QX
	else if (strcmp (bootDev, "qx") == 0)
	    status = qxattach (0);
#endif	INCLUDE_QX

#ifdef	STANDALONE
#ifdef	EASTPORT
#ifdef	INCLUDE_PN
	else if (strcmp (bootDev, "pn") == 0) {

	    /* 
	     * Attach Eastport's target CPU's proNET, add the remote host
	     * (Cluster is 95.0.0.1), we are 95.0.0.2.
	     */
	    status = pnattach(0);
	    remAddHost("pronet1","95.0.0.1");
	}
#endif	INCLUDE_PN
#endif	EASTPORT
#endif	STANDALONE

	else
	    {
	    printf ("Boot device \"%s\" unknown.\n", bootDev);
	    return (ERROR);
	    }

	if (status != OK)
	    {
	    printf ("Error attaching \"%s\" device: status = 0x%x.\n", bootDev,
		    errnoGet ());
	    return (ERROR);
	    }

 	/* configure ethernet interface with specified inet adrs and net mask */

	strcpy (ifname, bootDev);
	strcat (ifname, "0");

	if (eNetmask != 0)
	    ifMaskSet (ifname, eNetmask);

	ifconfig (ifname, "inet", ead,0,0,0,0);
	}


    /* if bp net address specified, initialize bp device */

    if (bad[0] != NULL)
	{
	char *bpDev = NULL;

#ifdef INCLUDE_VB
	/* If the ISI cluster-compatible backplane driver is required
	 * (for use with ISI Unix-to-UniWorks backplane communications),
	 * use the "vb" driver instead of the "bp" driver. 
	 */

	bpDev = "vb";
	status = vbattach (0, sysProcNum);
#endif	INCLUDE_VB

	if (bpDev == NULL)
	    printf (
		"Error: backplane address specified but no driver included.\n");

	else if (status != OK)
	    printf ("Error attaching \"%s\" device: status = 0x%x.\n",
		    bpDev, errnoGet ());
	
	else
	    {
	    /* configure backplane interface with specified inet adrs */

	    strcpy (ifname, bpDev);
	    strcat (ifname, "0");

	    if (bNetmask != 0)
		ifMaskSet (ifname, bNetmask);

	    ifconfig (ifname, "inet", bad,0,0,0,0);
	    }
	}


    /* add loop-back interface */

    loattach ();
    ifconfig ("lo0", "inet", "127.0.0.1",0,0,0,0);
    remAddHost ("localhost", "127.0.0.1");

    /* if a gateway was specified, extract the network part of the host's
       address and add a route to this network */

    if (gad[0] != EOS)
        {
	inet_netof_string (had, nad);
	routeAdd (nad, gad);
        }


    /* associate host name with the specified host address */

#ifndef	STANDALONE
    remAddHost (sysBootHost, had);		
#endif	STANDALONE


    /* create transparent remote file access device;
     * device name is sysBootHost with ':' appended.
     * protocol is rcmd if no password, or ftp if password specified */

    netDrv ();					/* init remote file driver */
    strcpy (devName, sysBootHost);		/* create device name */
    strcat (devName, ":");
    protocol = (passwd[0] == EOS) ? 0 : 1;	/* pick protocol based on pw */
    netDevCreate (devName, sysBootHost, protocol); /* create remote file dev */


    /* set the user id, and current directory */

    iam (usr, passwd);
    ioDefPathSet (devName);

    taskDelay (15);


    /* start the rlogin or telnet daemon,
     * again based on whether or not password was specified */

#ifdef INCLUDE_RLOGIN
    if (passwd[0] == EOS)
	rlogInit ();
#endif

#ifdef INCLUDE_TELNET
    if (passwd[0] != EOS)
	telnetInit ();
#endif

    /* initialize the vb backplane poll if specified */

#ifdef INCLUDE_VB
    {
    IMPORT VOID vbPoll ();

    if (ifunit("vb0")) {
        taskSpawn ("vbPoll", 11, VX_SUPERVISOR_MODE, 0x2000, vbPoll);
        isiBootInit ();
        }
    }
#endif

    /* initialize rpc and dbx daemon if specified */

#ifdef INCLUDE_RPC
    rpcInit ();
    clnt_tcpInit ();		/* pulls in tcp client module */
#endif

#ifdef INCLUDE_DBX
    dbxInit ();
#endif

#ifdef INCLUDE_NFS
    gid = NFS_GROUP_ID;		/* initialize nfs unix authorization */
    nfsAuthUnixSet (sysBootHost, NFS_USER_ID, gid, 1, &gid);

    if (nfsDrv () == ERROR)	/* initialize nfs driver */
	{
	printf ("NFS driver did not start up\n");
	}
    else
	{
	/* strip the nfs disk name from the boot file's name */

	strcpy (nfsDisk, sysBootFile);
	if (*nfsDisk != '/')
	    printf ("no NFS disk specified\n");
	else
	    {
	    /* boot file name begins with '/' */

	    if ((p = index (&nfsDisk [1], '/')) != NULL)
		{
		/* there's a second '/' in path,
		 * mount first directory in path name */

		*p = EOS;
		strcat (nfsDisk, "/");
		}
	    else
		{
		/* mount '/' */

		nfsDisk [1] = EOS;
		}

	    /* mount the disk */

	    if (nfsMount (sysBootHost, nfsDisk, nfsDisk) == ERROR)
		printf ("NFS mount of %s from host %s failed \n", nfsDisk,
			 sysBootHost);
	    else
		{
		printf ("NFS disk %s mounted\n", nfsDisk);

		/* reset the current directory to be the nfs disk */

		ioDefPathSet (nfsDisk);
		}
	    }
	}

#endif

    return (OK);
    }
/*******************************************************************************
*
* loadSymTbl - load system symbol table
*
* This routine loads the system symbol table.
*/

LOCAL STATUS loadSymTbl (symTblName)
    char *symTblName;

    {
    int err;
    int symfd;
    char *loadAddr;

#ifdef	DEBUG
	printf("loadSymTbl\n");
#endif	DEBUG

    /* open symbol table file */

    symfd = open (symTblName, READ, 0);
    if (symfd == ERROR)
	{
	err = errnoGet();
	printf ("\nError opening %s\n", symTblName);
	printf ("Error status = 0x%x ",err);
	printErrno(err);
	return (ERROR);
	}

    /* load system symbol table */

    loadAddr = 0;		/* to prevent symbols from being relocated */
    if (ldLoadModule (symfd, 
		      (sysFlags & SYSFLG_DEBUG) ? ALL_SYMBOLS : GLOBAL_SYMBOLS,
		      &loadAddr, (char **) NULL, (char **) NULL) == ERROR)
	{
	printf ("Error loading symbol table: status = 0x%x\n", errnoGet ());
	close (symfd);
	return (ERROR);
	}

    close (symfd);

#ifdef	DEBUG
	printf("loadSymTbl, loaded.\n");
#endif	DEBUG

    return (OK);
    }

