/* mv131.h - Motorola MVME-131 CPU board header file */

/*
modification history
--------------------
01c,08jun88,gae  added include of z8036.h.
01b,29apr88,gae  added BUS and CPU constants.
01a,05may87,dnw	 written.
*/

/*
This file contains I/O address and related constants
for the Motorola MVME-131.
*/

#ifndef	INCmv131h
#define	INCmv131h

#include "z8036.h"

#define TARGET_MVME_131

#define BUS		VME_BUS
#define CPU		MC68020


/* Zilog Z8036 CIO (Counter/Timer) */

#define CIO_BASE	((char *) 0xfffb0000)

/* status and control registers */

#define	MV131_BASE	0xfffb0000

#define MV131_STAT0 ((char *) (MV131_BASE+0x30)) /* front panel switch status */
#define MV131_STAT1 ((char *) (MV131_BASE+0x31)) /* front panel switch status */
#define MV131_STAT2 ((char *) (MV131_BASE+0x32)) /* BERR source status */

#define MV131_CNT0 ((char *) (MV131_BASE+0x0d)) /* VMEbus interrupt vector */
						/*    (z8036 port A) */
#define MV131_CNT1 ((char *) (MV131_BASE+0x0e)) /* multi-proc sync interrupt */
						/*    (z8036 port B) */
#define MV131_CNT2 ((char *) (MV131_BASE+0x38)) /* VMEbus interrupt masks */
#define MV131_CNT3 ((char *) (MV131_BASE+0x39)) /* interrupt control */
#define MV131_CNT4 ((char *) (MV131_BASE+0x3a)) /* not used */
#define MV131_CNT5 ((char *) (MV131_BASE+0x3b)) /* bus control */


/* control register 2 */

#define MV131_CNT2_INT_STATUS_INT_MASK	0x01

/* control register 3 */

#define MV131_CNT3_INT_ENABLE		0x40
#define MV131_CNT3_SYS_FAIL_INT		0x20
#define MV131_CNT3_GEN_INT_LEVEL	0x0e

/* control register 5 */

#define MV131_CNT5_VMX_DISABLE		0x40
#define MV131_CNT5_NOT_VMX_READ_ONLY	0x20
#define MV131_CNT5_VMX_DECODE_ENABLE	0x10
#define MV131_CNT5_NOT_VMX_INT_REQ	0x08
#define MV131_CNT5_NOT_24_BIT_ADRS	0x04
#define MV131_CNT5_NOT_16_BIT_DATA	0x02
#define MV131_CNT5_BOARD_FAIL		0x01

#endif	INCmv131h
