/* auth_none.c -  client authentication for remote systems */

static char *copyright = "Copyright 1987, Wind River Systems, Inc.";

/*
 * Copyright (c) 1987 Wind River Systems, Inc.
 * Copyright (C) 1984, Sun Microsystems, Inc. 
 *
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
modification history
--------------------
*/

/*
 * auth_none.c
 * Creates a client authentication handle for passing "null" 
 * credentials and verifiers to remote systems. 
 * 
 * Copyright (C) 1984, Sun Microsystems, Inc. 
 */

#include "rpctypes.h"
#include "xdr.h"
#include "auth.h"
#include "rpcGbl.h"
#include "UniWorks.h"

/* XXX #define NULL ((caddr_t)0) */
#define MAX_MARSHEL_SIZE 20

/*
 * Authenticator operations routines
 */
void	authnone_verf();
void	authnone_destroy();
bool_t	authnone_marshal();
bool_t	authnone_validate();
bool_t	authnone_refresh();

static struct auth_ops ops = {
	authnone_verf,
	authnone_marshal,
	authnone_validate,
	authnone_refresh,
	authnone_destroy
};

struct moduleStatics 
    {
    AUTH no_client;
    char marshalled_client[MAX_MARSHEL_SIZE];
    u_int mcnt;
    };

STATUS auth_noneInit (myModuleList)
    FAST MODULE_LIST *myModuleList;
    {

    /* allocate the module statics */

    myModuleList->auth_none = 
	 (struct moduleStatics *) malloc (sizeof (struct moduleStatics)); 

    if (myModuleList->auth_none == NULL)
	{
	printErr ("auth_noneInit: out of Memory! \n");
	return (ERROR);
	}
    
    bzero (myModuleList->auth_none, sizeof (struct moduleStatics)); 
    return (OK);
    }

AUTH *
authnone_create()
{
	XDR xdr_stream;
	register XDR *xdrs;
	FAST struct moduleStatics *ms = taskModuleList->auth_none;

	if (! ms->mcnt) {
		ms->no_client.ah_cred = ms->no_client.ah_verf = _null_auth;
		ms->no_client.ah_ops = &ops;
		xdrs = &xdr_stream;
		xdrmem_create(xdrs, ms->marshalled_client, 
		    (u_int)MAX_MARSHEL_SIZE, XDR_ENCODE);
		(void)xdr_opaque_auth(xdrs, &ms->no_client.ah_cred);
		(void)xdr_opaque_auth(xdrs, &ms->no_client.ah_verf);
		ms->mcnt = XDR_GETPOS(xdrs);
		XDR_DESTROY(xdrs);
	}
	return (&ms->no_client);
}

/*ARGSUSED*/
bool_t
authnone_marshal(client, xdrs)
	AUTH *client;
	XDR *xdrs;
{
	FAST struct moduleStatics *ms = taskModuleList->auth_none;

	return ((*xdrs->x_ops->x_putbytes)(xdrs, ms->marshalled_client, 
					   ms->mcnt));
}

void 
authnone_verf()
{
}

bool_t
authnone_validate()
{

	return (TRUE);
}

bool_t
authnone_refresh()
{

	return (FALSE);
}

void
authnone_destroy()
{
}
