/* cALib.s - C language support routines */

	.data
	.asciz	"Copyright 1988, Wind River Systems, Inc."

/*
modification history 
--------------------
*/

/*
DESCRIPTION
This library contains C language support routines.  It includes:

    setjmp/longjmp "non-local goto" routines,

    various routines and data necessary to satisfy the compilers
    or libraries of particular host systems.

INCLUDE FILE: setjmp.h
*/

#define ASMLANGUAGE
#include "UniWorks.h"

	/* internals */

        .globl  _longjmp
        .globl  _setjmp

	/* externals */

	.globl _sigOnstackFlagSet
	.globl _sigOnstackFlagGet
	.globl _sigblock
	.globl _sigsetmask

/******************************************************************************
*
* HOST_SUN - Sun Unix stuff
*
* NO_MANUAL
*/

#if defined(HOST_SUN)

	.globl f68881_used

	.text
	.even

f68881_used: rts

#endif

/******************************************************************************
*
* HOST_ISI - ISI Unix stuff
*
* The definition of "is68020" is required by the Integrated Solutions 3.07
* C compiler (actually its support routines).
* It should be 0xffffffff for 68020 CPUs and 0 for others.
*
* NO_MANUAL
*/

#if defined(HOST_ISI)

	.globl is68020
	.globl fltused

	.data
	.even
#if ((CPU==MC68020)||(CPU==MC68030))
is68020: .long	0xffffffff
#else
is68020: .long	0
#endif

	.text
	.even

fltused: rts

#endif (HOST_ISI)

/******************************************************************************
*
* HOST_IRIS - Silicon Graphics Unix stuff
*
* The definition of "_errno" is required for the Silicon Graphics
* IRIS compiler (actually the floating-point support routines).
*
* NO_MANUAL
*/

#if defined(HOST_IRIS)

	.globl _errno

	.data
	.even

_errno:	.long 0x0

#endif	(HOST_IRIS)

/******************************************************************************
*
* HOST_HK - Heurikon Unix stuff
*
* NO_MANUAL
*/  

#if defined(HOST_HK)

        .globl  splimit%
        .globl  spgrow%

	.text
	.even

spgrow%: rts

	.data
	.even

splimit%: .long	0

#endif (HOST_HK)

	.text
	.even

/*******************************************************************************
* 
* setjmp - set non-local goto
*
* This routine saves the current task context and program counter
* in `env' for later use by longjmp (2).   When called this routine
* returns 0, however program execution will also return to this
* point and setjmp will return `val' as specified in longjmp (2).
*
* RETURNS: 0 or `val' if return via longjmp

* int setjmp (env)
*    jmp_buf env;	/* where to save stack environmnet *

*/

_setjmp:
	/* save the pc */
	movel	a7@(0x4),a0
	movel	a7@,a0@

	/* save the signal mask */
	movel	#0,a7@-
	jsr	_sigblock
	addl	#4, a7
	movel	a7@(0x4),a0
	movel	d0,a0@(0x4)

	/* save the onstack flag */
	jsr	_sigOnstackFlagGet
	movel	a7@(0x4),a0
	movel	d0,a0@(0x8)

	/* save the registers */
	movel	a7@(0x4),a0
	moveml	d2-d7/a2-a7,a0@(0xc)
	clrl	d0
	rts

/*******************************************************************************
* 
* longjmp - do non-local goto
*
* longjmp retores the previously saved setjmp (2) context and
* jumps to where setjmp was called.
* The routine setjmp will then return with the result `val'.
*
* RETURNS:
*  DOESN'T! causes a return from the last setjmp
*  with return value `val' (if `val' is zero then return 1)

* VOID longjmp (env, val)
*     jmp_buf env;	/* where stack environmnet was saved *
*     int val;		/* value for setjmp (2) to return    *

*/

_longjmp:
	/* restore the signal mask */
	movel	a7@(0x4),a0
	movel	a0@(0x4),d0 
	movel	d0,a7@-
	jsr	_sigsetmask
	addl	#4,a7

	/* restore the onstack flag */
	movel	a7@(0x4),a0
	movel	a0@(0x8),d0 
	movel	d0,a7@-
	jsr	_sigOnstackFlagSet
	addl	#4,a7

	movel	a7@(0x4),a0
	movel	a7@(0x8),d0 
	bne	L1
	moveq	#0x1,d0 
L1:
	movel	a0@,a1
	moveml	a0@(0xc),d2-d7/a2-a7
	addql	#4,a7
	jmp	a1@
