/* semULib.c - semaphore library for UNIX */

static char *copyright = "Copyright 1984, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
This library contains dummy versions of semLib routines so that UNIX programs
can make use of libraries that have calls to semLib routines.
These routines don't really do anything, since UNIX doesn't have
an equivalent facility, but they do allow some libraries to be linked into
UNIX tasks that would otherwise have problems.

SEE ALSO: semLib (1)
*/

/* LINTLIBRARY */

#include "UniWorks.h"
#include "semLib.h"


/***********************************************************************
*
* semCreate - create semaphore
*/

SEM_ID semCreate ()

    {
    }

/***********************************************************************
*
* semGive - give semaphore
*/

VOID semGive (semId)
    SEM_ID semId;	/* semaphore id */

    {
    semId->count = 1;
    }
/***********************************************************************
*
* semTake - take semaphore
*/

VOID semTake (semId)
    SEM_ID semId;	/* semaphore id */

    {
    semId->count = 0;
    }
/***********************************************************************
*
* semClear - clear semaphore
*/

VOID semClear (semId)
    SEM_ID semId;	/* semaphore id */

    {
    semId->count = 0;
    }
/***********************************************************************
*
* semDelete - delete semaphore
*/

VOID semDelete (semId)
    SEM_ID semId;	/* semaphore id */

    {
    }
/***********************************************************************
*
* semInit - initialize semaphore
*/

VOID semInit (pSemaphore)
    SEMAPHORE *pSemaphore;	/* pointer to semaphore to init */

    {
    pSemaphore->count = 0;
    }
