/* pasLib.h - Pascal library defines */

/*
modification history
--------------------
*/

#ifndef INCpasLibh
#define INCpasLibh

#include "vwModNum.h"

struct pasftype {
	unsigned int    elementsize:24;
	unsigned int    open:1;
	unsigned int    read:1;
	unsigned int    linemark:1;
	unsigned int    valid:1;/* is the thing in buffervar valid or not */
	unsigned int    text:1;
	unsigned int    eof:1;
	unsigned int    temp:1;	/* is this a temporary file? */
	char           *filename;
	FILE           *filevar;
	/*
	 * if more fields are added above this, then the magic number 96 in
	 * iscsize() in pasdec.p may need to be changed
	 * (96=sizeof(pasftype)-sizeof(buffervar) 
	 */
	char            buffervar;
	int            tid;
};

/* Pascal status codes */

#define S_pasLib_BAD_FILENAME		(M_pasLib | 1)
#define S_pasLib_BAD_FILEVARIABLE	(M_pasLib | 2)
#define S_pasLib_FILE_NOT_OPEN		(M_pasLib | 3)
#define S_pasLib_FILE_READ_ONLY		(M_pasLib | 4)
#define S_pasLib_FILE_WRT_ONLY		(M_pasLib | 5)
#define S_pasLib_FILE_OPEN_ERR		(M_pasLib | 6)
#define S_pasLib_FILE_REC_ERR		(M_pasLib | 7)
#define S_pasLib_UNDEF_FILE_VAR		(M_pasLib | 8)
#define S_pasLib_INPUT_ERR		(M_pasLib | 9)
#define S_pasLib_FORMAT_ERR		(M_pasLib | 10)
#define S_pasLib_EOF			(M_pasLib | 11)
#define S_pasLib_BUF_VAR_ERR		(M_pasLib | 12)
#define S_pasLib_NEG_OR_0_ERR		(M_pasLib | 13)
#define S_pasLib_NEW_ERR		(M_pasLib | 14)
#define S_pasLib_DISPOSE_ERR		(M_pasLib | 15)

#define	PAS_DBG_LEV_ERR_ONLY	0	/* set errno only */
#define	PAS_DBG_LEV_ERR_MSG	1	/* set errno and print msg */
#define	PAS_DBG_LEV_ERR_MSG_DIE	2	/* set errno, print msg and die */
#define	PAS_DBG_LEV_ERR_DIE	3	/* set errno and die */

#endif INCpasLibh
