/* 
 * Generic structures for driver which use a file system (RT-11 or other)
 */

/*
 * qb_diskst structure describes the geometry and partition sizes for a disk.
 */

struct qb_diskst {
	USHORT st_ncpd;			/* num cylinders per drive */
	USHORT st_nspt;			/* num sectors per track */
	USHORT st_ntpc;			/* num tracks per cylinder */
	USHORT st_nspc;			/* num sectors per cylinder */
	short st_spare1;		/* num bytes per sector */
	short st_spare2;
	struct diskst_psize {
		int nblocks;		/* size of partition in blocks */
		int cyloff;		/* start cylinder for partition */
	}	st_size[8];
};
		
#define ST_ncpd		(st->st_ncpd)
#define ST_nspt		(st->st_nspt)
#define ST_ntpc		(st->st_ntpc)
#define ST_nspc		(st->st_nspc)
#define ST_spare1	(st->st_spare1)
#define ST_spare2	(st->st_spare2)

/*
 * Per-device structure
 */

#define DEV_NAME_SIZE	8

struct qb_device {
	RT_VOL_DESC     rtvol;		/* rt volume descriptor struct */
	char		name[DEV_NAME_SIZE]; /* name of device - for badstrat */
	char            ctlr;		/* controller number */
	char            drive;		/* drive number */
	char		partition;	/* partition num for this device */
	int 		blk_size; 	/* block size in bytes */
	unsigned int	dev;		/* CONT|TARG|LUN|PART */
};

/*
 * Per-drive structure
 */

struct qb_drive {
	char            	here;	/* BOOLEAN - drive exists or not */
	struct qb_diskst 	diskst;	/* disk geometry struct */
	struct dkbad 		bad;	/* bad sector map for disk */
};

/*
 * Per-controller structure
 */

struct qb_ctlr {
	SEMAPHORE       ctlr_sem;	/* control of controller sem */
	SEMAPHORE       intr_sem;	/* wait for interrupt complete sem */
	UTINY           errcnt;		/* retry count for interrupt code */
	char            status;		/* interrupt code status */
};

