
/*
 * Donated by Mark Whetzel.
 * based on: disk.h   -   layout of reserved cylinders on the fixed disks *
 */

#define	DEF_LEN	(64)		/* default # sectors to check at once */

#define	PAT1	(0x6DB6DB6D)
#define	PAT2	(0xB6CB6CB6)
#define	PAT3	(0xDB6DB6DB)
#define	PAT4	(0x264C9932)
#define	PAT5	(0X4C993264)
#define	PAT6	(0x993264C8)

#define	NPATS	(6)

#define	LSN(cyl, head, sector) ((sector-1) + \
				cr->last_sector*(head + (cr->last_head+1)*cyl))

#define	CYL(lsn)	((lsn/cr->last_sector)/(cr->last_head+1))
#define	HEAD(lsn)	((lsn/cr->last_sector)%(cr->last_head+1))
#define	SECTOR(lsn)	((lsn%cr->last_sector) + 1)
#define	BPS		(256*cr->sector_size)

/* convert LSN to HIDDEN defect format (cccchhss) */
#define	LSN_TO_HID(lsn)		((CYL(lsn)<<16)|(HEAD(lsn)<<8)|(SECTOR(lsn)))

#define	HID_DIR1_LSN	(LSN(0,1,18))
#define	HID_DIR2_LSN	(LSN(0,2,18))
#define	HID_DIR1_LEN	(LSN(0,1,cr->last_sector) - HID_DIR1_LSN + 1)
#define	HID_DIR2_LEN	(LSN(0,2,cr->last_sector) - HID_DIR2_LSN + 1)


#define	IPL_REC_LSN	(0x0)		/* LSN of IPL record */
#define	CONFIG_REC_LSN	(0x1)		/* LSN of config record */
#define	MD_DIR_LSN	(0x3)		/* LSN of minidisk directory */
#define	MD_DIR_LEN	(0x3)		/* #sectors in minidisk directory */
#define	BAD_DIR_LSN	(0x8)		/* LSN of bad block directory */
#define	BAD_DIR_LEN	(LSN(0,1,13) - BAD_DIR_LSN + 1)
					/* #sectors in minidisk directory */

typedef	struct {

#define CONFIG_MAGIC    0xF8E9DACB      /* configuration record magic # */

    unsigned long	id;		/* config record ID == 0xF8E9DACB */
    unsigned long	capacity;	/* formatted data capacity (blocks?) */
    unsigned short	res1;		/* reserved */
    unsigned char	interleave;	/* interleave factor */
    unsigned char	sector_size;	/* sector size */
    unsigned short	last_data_cyl;	/* last data cylinder */
    unsigned char	last_head;	/* last head */
    unsigned char	last_sector;	/* last sector */
    unsigned char	precomp;	/* precompensation value */
    unsigned char	dev_status;	/* device status */
    unsigned short	CE_cyl;		/* CE cylinder */
    unsigned short	end_of_life;	/* end-of-life */
    unsigned char	seek_profile[30];	/* seek profile (?) */
    unsigned char	manufacturer_ID[3];	/* manufacturer ID */
    unsigned char	res2;		/* reserved */
    unsigned short	serv_req_num;	/* service request number */
    unsigned char	drive_char;	/* drive characteristic */
    unsigned char	head_skew;	/* head switch sector skewing */
    unsigned short	hidmax;		/* max # hidden defects */
    unsigned char	res3a[256-62];	/* fill up to halfway */
    unsigned char	disk_name[8];	/* name of disk */
    unsigned char	res3b[512-264];	/* fill up to the end */

}	config_rec;

typedef struct {

    unsigned short	prev;		/* index of previous entry */
    unsigned short	next;		/* index of next entry */
    char		name[4];	/* minidisk name from create minidisk */
    unsigned long	res1;		/* reserved */
    unsigned long	ctime;		/* date minidisk was created */
    unsigned short	iodn;		/* minidisk IODN, or 0 if free space */
    unsigned char	lblksize;	/* logical block size */
    unsigned char	type;		/* minidisk type */
#define	WRITE_VERIFY	(0x80)		/* write verify */
#define	NO_BAD_RELOC	(0x40)		/* no bad block relocation */
#define	PAGE_SPACE_MD	(0x20)		/* paging space minidisk */
#define	AIX_FILESYS_MD	(0x10)		/* AIX filesystem minidisk */
#define	AIX_OS_MD	(0x08)		/* AIX operating system minidisk */
#define	AT_COPROC_MD	(0x04)		/* AT coprocessor option minidisk */
#define	VRM_MD		(0x02)		/* VRM minidisk */
#define	AUTO_IPL_MD	(0x01)		/* auto IPL minidisk */
    unsigned long	res2;		/* reserved */
    unsigned long	lsn_start;	/* LSN for start of minidisk */
    unsigned long	nsectors;	/* number of sectors used by minidisk */

}	mini_dirent;

typedef struct {

    unsigned long	nmini;		/* number of minidisks, incl free */
    unsigned long	level;		/* level id of minidisk directory */
    unsigned short	next;		/* index of next unused dir entry */
    unsigned short	res1;		/* reserved */
    unsigned short	first;		/* index of first minidisk directory */
    unsigned short	last;		/* index of last minidisk directry */
    unsigned long	bad_lsn;	/* LSN of start of bad reloc area */
    unsigned long	bad_size;	/* size of bad block area in sectors */
    unsigned long	recent_dir;	/* I/O counter for recent direct used */
    unsigned long	res2;		/* reserved */

    mini_dirent		entry[1];	/* directory entries */

}	minidisk_dir;

typedef struct {

    unsigned     	reason:8,	/* reason block marked as unusable */
#define	MANUFACT_DEF		(0x00)	/* manufacturer found the defect */
#define	SURFACE_SCAN_DEF	(0xAA)	/* surface verify found the defect */
#define	SYSTEM_DEF		(0xBB)	/* system found the defect */
#define	MANUFACT_TEST_DEF	(0xCC)	/* manufacturing test found defect */
                 	bad_lsn:24;	/* LSN of the bad block */
    unsigned long	reloc_lsn;	/* LSN where bad block is relocated */
#define	RELOC_DATA_INVALID	(0x80000000)	/* relocated block invalid */

}	bad_dirent;

typedef	struct	{

    unsigned char	id[6];		/* ASCII string "DEFECT" */
    unsigned short	total;		/* total number of bad blocks */
    bad_dirent		entry[1];	/* directory entries */

}	bad_block_dir;

typedef struct {

    unsigned short	cyl;		/* cylinder number */
    unsigned char	head;		/* head number */
    unsigned char	sector;		/* sector number */

}	hidden_entry;

typedef struct {

    unsigned char	id[6];		/* ASCII string "HIDDEN" */
    unsigned short	total;		/* total number of hidden defects */
    hidden_entry	entry[1];	/* directory entries */

}	hidden_defect_dir;

