/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:mount.h 12.0$ */
/* $ACIS:mount.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ufs/RCS/mount.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidmount = "$Header:mount.h 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

/* @(#)mount.h	1.3 87/05/11 3.2/4.3NFSSRC */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)mount.h	7.1 (Berkeley) 6/4/86
 */

#ifdef VFS
/*
 * Mount structure.
 * One allocated on every mount.
 * Used to find the super block.
 */
struct	mount
{
	struct vfs	*m_vfsp;	/* vfs structure for this filesystem */
	dev_t	m_dev;		/* device mounted */
	struct vnode	*m_devvp;	/* vnode for block device mounted */
	struct	buf *m_bufp;	/* pointer to superblock */
	struct	inode *m_qinod;	/* QUOTA: pointer to quota file */
	u_short		m_qflags;	/* QUOTA: filesystem flags */
	u_long		m_btimelimit;	/* QUOTA: block time limit */
	u_long		m_ftimelimit;	/* QUOTA: file time limit */
};

#ifdef KERNEL
/*
 * Convert vfs ptr to mount ptr. ONLY WORKS IF m_vfsp IS FIRST.
 */
#define VFSTOM(VFSP)	((struct mount *)(VFSP->vfs_data))

/*
 * mount table
 */
struct	mount mount[NMOUNT];

/*
 * Operations
 */
struct mount *getmp();
#endif
#endif
