/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:cmap.h 12.0$ */
/* $ACIS:cmap.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/cmap.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidcmap = "$Header:cmap.h 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)cmap.h	7.1 (Berkeley) 6/4/86
 */

/*
 * core map entry
 *
 * Limits imposed by this structure:
 *
 *		limit		     cur. size		fields
 *	Physical memory*		64 Mb	c_next, c_prev, c_hlink
 *	Mounted filesystems		255	c_mdev
 *	size of a process segment	1 Gb	c_page
 *	filesystem size			8 Gb	c_blkno
 *	proc, text table size		64K	c_ndx
 *
 *	* memory can be expanded by converting first three entries
 *	to bit fields of larger than 16 bits, shrinking c_ndx accordingly,
 *	and increasing MAXMEM below.  Also, the type of cmhash
 *	(below) must be changed to long.
 */
struct cmap
{
#ifdef ibm032
unsigned short 	c_next,		/* index of next free list entry */
		c_prev,		/* index of previous free list entry */
		c_page,		/* virtual page number in segment */
		c_hlink,	/* hash link for <blkno,mdev> */
		c_ndx;		/* index of owner proc or text */
#ifndef VFS
unsigned char	c_mdev,		/* which mounted dev this is from */
#else
unsigned char	c_unused,	/* unused */
#endif
		c_lock:1,	/* locked for raw i/o or pagein */
		c_want:1,	/* wanted */
		c_intrans:1,	/* intransit bit */
		c_free:1,	/* on the free list */
		c_gone:1,	/* associated page has been released */
		c_type:2,	/* type CSYS or CTEXT or CSTACK or CDATA */
		c_mapped:1;	/* mapped in HAT/IPT */
unsigned int	c_blkno;	/* disk block this is a copy of */
#if defined(VFS) || !defined(COMPAT_43)
struct vnode	*c_vp;		/* vnode to which c_blkno refers */
#endif
#else
unsigned short 	c_next,		/* index of next free list entry */
		c_prev,		/* index of previous free list entry */
		c_hlink;	/* hash link for <blkno,mdev> */
unsigned short	c_ndx;		/* index of owner proc or text */
unsigned int	c_page:21,	/* virtual page number in segment */
		c_lock:1,	/* locked for raw i/o or pagein */
		c_want:1,	/* wanted */
		c_intrans:1,	/* intransit bit */
		c_free:1,	/* on the free list */
		c_gone:1,	/* associated page has been released */
		c_type:2,	/* type CSYS or CTEXT or CSTACK or CDATA */
		:4,		/* to longword boundary */
		c_blkno:24,	/* disk block this is a copy of */
#ifndef VFS
		c_mdev:8;	/* which mounted dev this is from */
#else
		:8;			/* unused */
#endif
#if defined(VFS) || !defined(COMPAT_43)
struct vnode	*c_vp;		/* vnode to which c_blkno refers */
#endif
#endif
};

/*
 * bit offsets of elements in cmap
 */
#define	C_INTRANS	87
#define	C_FREE		88

#define	MAXMEM		64*1024		/* maximum memory, in Kbytes */

#define	CMHEAD	0

/*
 * Shared text pages are not totally abandoned when a process
#ifndef VFS
 * exits, but are remembered while in the free list hashed by <mdev,blkno>
#else
 * exits, but are remembered while in the free list hashed by <vp,blkno>
#endif
 * off the cmhash structure so that they can be reattached
 * if another instance of the program runs again soon.
 */
#ifdef SMALLMEM
#define	CMHSIZ	512	/* SHOULD BE DYNAMIC */
#else
#define	CMHSIZ	2048	/* SHOULD BE DYNAMIC */
#endif
#define	CMHASH(bn)	((bn)&(CMHSIZ-1))

#ifdef	KERNEL
struct	cmap *cmap;
struct	cmap *ecmap;
int	ncmap;
struct	cmap *mfind();

int	firstfree, maxfree;
int	ecmx;			/* cmap index of ecmap */
short	cmhash[CMHSIZ];
#endif

/* bits defined in c_type */

#define	CSYS		0		/* none of below */
#define	CTEXT		1		/* belongs to shared text segment */
#define	CDATA		2		/* belongs to data segment */
#define	CSTACK		3		/* belongs to stack segment */

#ifdef ibm032
#define CUSTRUCT	4		/* is a u struct (really CSYS) */
#endif

#define	pgtocm(x)	(((int) ((x)-firstfree) / CLSIZE) + 1)
#define	cmtopg(x)	((((x)-1) * CLSIZE) + firstfree)
