/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:apaaed.h 12.0$ */
/* $ACIS:apaaed.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/apaaed.h,v $ */

#ifndef lint
static char *rcsidapaaed = "$Header:apaaed.h 12.0$";
#endif

/*
 * Simulated bitmap area addresses
 */

#define AED_BM_ADDR	0xEF100000
#define AED_BM_SIZE	(((((1024 / 8) * 800) + 2047) / 2048) * 2048)
#define AED_COLOR	(*(int *)(AED_BM_ADDR + AED_BM_SIZE + 0))
#define AED_CMDQ_SEMA	(*(int *)(AED_BM_ADDR + AED_BM_SIZE + 4))
#define AED_CMDQ_INDEX	(*(int *)(AED_BM_ADDR + AED_BM_SIZE + 8))
#define AED_CURSOR_LOAD	(*(int *)(AED_BM_ADDR + AED_BM_SIZE + 16))
#define AED_CURSOR_X	(*(short *)(AED_BM_ADDR + AED_BM_SIZE + 20))
#define AED_CURSOR_Y	(*(short *)(AED_BM_ADDR + AED_BM_SIZE + 22))
#define AED_CURSOR	((Locator *)(AED_BM_ADDR + AED_BM_SIZE + 24))
#define AED_CMDQ	((struct aed_cmd *)(AED_BM_ADDR + AED_BM_SIZE + 128))
#define AED_CMD_SIZE	64
#define AED_MAX_CMDS	((2048 - 128) / AED_CMD_SIZE)

/*
 * Hardware addresses
 */

#ifdef ATR
#define UCODE		(0x0A0000&0x1ffff)
#define AED		(0x0A4000&0x1ffff)
#else
#define UCODE		0xF40A0000
#define AED		0xF40A4000
#endif

/*
 * Types of things put on the kernel command queue
 */

#define AED_ECHO_RECT 	1
#define AED_DRAW_LINE 	2
#define AED_SCREEN_COPY 3

/*
 * Echo a rectangle from the simulated bitmap to the display.
 */

struct aed_echo_rect {
	short origin_y, origin_x;
	short corner_y, corner_x;
};

/*
 * Draw a line
 */

struct aed_draw_line {
	short from_x, from_y;
	short to_x, to_y;
	short rule;
	short width;
	short color;
	short pat, patlen;
	short top, left;
	short bottom, right;
};

/*
 * Screen to screen blt
 */

struct aed_screen_copy {
	short from_x, from_y;
	short to_x, to_y;
	short width, height;
	short rule;
};

/*
 * The whole ball of wax. AED command structure.
 */

struct aed_cmd {
	long cmd;
	union cmd_block {
		struct aed_echo_rect echo_rect;
		struct aed_draw_line draw_line;
		struct aed_screen_copy screen_copy;
	} aed_cmd_block;
	char padding[AED_CMD_SIZE - sizeof(long) - sizeof(union cmd_block)];
};

#define ECHO_RECT 	aed_cmd_block.echo_rect
#define SCREEN_COPY 	aed_cmd_block.screen_copy
#define DRAW_LINE 	aed_cmd_block.draw_line
