/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pcb.h 12.0$ */
/* $ACIS:pcb.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/pcb.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidpcb = "$Header:pcb.h 12.0$";
#endif

/*     pcb.h   6.1     83/07/29        */

/*
 * VAX process control block, modified for IBM RT PC
 */

#ifndef LOCORE     /* use c version */
struct pcb
{
	int	pcb_ksp;        /* kernel stack pointer */
#ifdef ATR
	int	pcb_io;        /* segment D (access to I/O space for ATR) */
#else
	int	pcb_afpalen;	/* afpa length register */
#endif
	int	pcb_sr08;        /* segment 8 */
#define pcb_usp pcb_r1         /* user stack pointer */
	int	pcb_r0;
	int	pcb_r1;
	int	pcb_r2;
	int	pcb_r3;
	int	pcb_r4;
	int	pcb_r5;
	int	pcb_r6;
	int	pcb_r7;
	int	pcb_r8;
	int	pcb_r9;
	int	pcb_r10;
	int	pcb_r11;
	int	pcb_r12;
	int	pcb_r13;
	int	pcb_r14;
	int	pcb_r15;
	int	pcb_iar;        /* instruction address */
	int	pcb_icscs;      /* program status longword */
	struct	pte *pcb_p0br;  /* seg 0 base register */
	int	pcb_p0lr;       /* seg 0 length register and astlevel */
	struct	pte *pcb_p1br;  /* seg 1 base register */
	int	pcb_p1lr;       /* seg 1 length register and pme */
/*
 * Software pcb (extension)
 */
	int	pcb_szpt;       /* number of pages of user page table */
	int	pcb_cmap2;
	int	*pcb_sswap;
	int	pcb_sigc[2];
	int	pcb_fpastatus;	/* fpa status value when owned an exception */
#ifdef IBMRTPC
	char	pcb_ccr;	/* value for CCR for this process */
#else
	char	pcb_win;	/* used for 128k window in ATR */
#endif
	char	pcb_consdev;	/* which console devices are open for HW access */
	char	pcb_fill[2];	/* filler */
};

#define AST_USER 0x80000000    /* VAX AST simulation - changed WEW*/

#define aston() (u.u_pcb.pcb_icscs |= AST_USER)

#define astoff() (u.u_pcb.pcb_icscs &= ~AST_USER)
#endif
